/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.audit.log4j.appender;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.htree.HTree;

public class JdbmQueue<E> {
    private static final String STAT_NAME = "stat";
    private static final String DATA_TREE = "data";
    private RecordManager db;
    private long stat;
    private HTree data;
    private boolean open;

    public JdbmQueue(File file) throws IOException {
        Properties props = new Properties();
        this.db = RecordManagerFactory.createRecordManager((String)file.getAbsolutePath(), (Properties)props);
        this.stat = this.findStat();
        this.data = this.getData();
        this.db.commit();
        this.open = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void enqueue(E e) throws IOException {
        boolean committed = false;
        try {
            Stat stat = this.getStat();
            stat.lastEnqueue++;
            this.setStat(stat);
            this.data.put((Object)stat.lastEnqueue, e);
            this.db.commit();
            committed = true;
            this.notify();
        }
        finally {
            if (!committed) {
                this.db.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized E dequeue() throws InterruptedException, IOException {
        boolean committed = false;
        try {
            Stat s = this.getStat();
            while (this.open && s.size() == 0L) {
                this.wait();
                if (!this.open) {
                    E e = null;
                    return e;
                }
                s = this.getStat();
            }
            s.nextDequeue++;
            Long key = s.nextDequeue;
            Object e = this.data.get((Object)key);
            this.data.remove((Object)key);
            this.db.update(this.stat, (Object)s);
            this.db.commit();
            committed = true;
            Object object = e;
            return (E)object;
        }
        finally {
            if (!committed && this.open) {
                this.db.rollback();
            }
        }
    }

    public synchronized boolean process(Consumer<E> consumer) throws IOException {
        boolean committed = false;
        try {
            E e = this.dequeue();
            boolean consumed = consumer.consume(e);
            if (consumed && this.open) {
                this.db.commit();
                committed = true;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            if (!committed && this.open) {
                this.db.rollback();
            }
        }
        return committed;
    }

    public synchronized void stop() {
        this.open = false;
        this.notifyAll();
    }

    public synchronized void close() throws IOException {
        this.stop();
        this.db.close();
    }

    long findStat() throws IOException {
        long recid = this.db.getNamedObject(STAT_NAME);
        if (recid == 0L) {
            recid = this.db.insert((Object)new Stat());
            this.db.setNamedObject(STAT_NAME, recid);
        }
        return recid;
    }

    Stat getStat() throws IOException {
        Stat stat;
        long recid = this.db.getNamedObject(STAT_NAME);
        if (recid == 0L) {
            stat = new Stat();
            this.db.setNamedObject(STAT_NAME, this.db.insert((Object)stat));
        } else {
            stat = (Stat)this.db.fetch(recid);
        }
        return stat;
    }

    void setStat(Stat update) throws IOException {
        this.db.update(this.stat, (Object)update);
    }

    HTree getData() throws IOException {
        HTree tree;
        long recid = this.db.getNamedObject(DATA_TREE);
        if (recid != 0L) {
            tree = HTree.load((RecordManager)this.db, (long)recid);
        } else {
            tree = HTree.createInstance((RecordManager)this.db);
            this.db.setNamedObject(DATA_TREE, tree.getRecid());
        }
        return tree;
    }

    public static interface Consumer<E> {
        public boolean consume(E var1);
    }

    private static final class Stat
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long lastEnqueue = 0L;
        private long nextDequeue = 0L;

        private Stat() {
        }

        private long size() {
            return this.lastEnqueue - this.nextDequeue;
        }
    }
}

