/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.audit.log4j.audit;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.gateway.audit.api.AuditContext;
import org.apache.hadoop.gateway.audit.api.AuditService;
import org.apache.hadoop.gateway.audit.api.Auditor;
import org.apache.hadoop.gateway.audit.log4j.audit.Log4jAuditContext;
import org.apache.hadoop.gateway.audit.log4j.audit.Log4jAuditor;
import org.apache.log4j.MDC;

public class Log4jAuditService
implements AuditService {
    public static final String MDC_AUDIT_CONTEXT_KEY = "audit_context";
    private Map<String, Auditor> auditors = new ConcurrentHashMap<String, Auditor>();

    @Override
    public AuditContext createContext() {
        AuditContext context = this.getContext();
        if (context == null) {
            context = new Log4jAuditContext();
            this.attachContext(context);
        }
        return context;
    }

    @Override
    public AuditContext getContext() {
        return (Log4jAuditContext)MDC.get((String)MDC_AUDIT_CONTEXT_KEY);
    }

    @Override
    public void attachContext(AuditContext context) {
        if (context != null) {
            MDC.put((String)MDC_AUDIT_CONTEXT_KEY, (Object)context);
        }
    }

    @Override
    public AuditContext detachContext() {
        AuditContext context = (AuditContext)MDC.get((String)MDC_AUDIT_CONTEXT_KEY);
        MDC.remove((String)MDC_AUDIT_CONTEXT_KEY);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(AuditContext context, Callable<T> callable) throws Exception {
        try {
            this.attachContext(context);
            T t = callable.call();
            return t;
        }
        finally {
            this.detachContext();
        }
    }

    @Override
    public synchronized Auditor getAuditor(String auditorName, String componentName, String serviceName) {
        String key = auditorName + componentName + serviceName;
        Auditor auditor = this.auditors.get(key);
        if (auditor == null) {
            auditor = new Log4jAuditor(auditorName, componentName, serviceName);
            this.auditors.put(key, auditor);
        }
        return auditor;
    }
}

