/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.audit.log4j.audit;

import org.apache.hadoop.gateway.audit.api.AuditContext;
import org.apache.hadoop.gateway.audit.api.AuditService;
import org.apache.hadoop.gateway.audit.api.Auditor;
import org.apache.hadoop.gateway.audit.api.CorrelationContext;
import org.apache.hadoop.gateway.audit.api.CorrelationService;
import org.apache.hadoop.gateway.audit.log4j.audit.Log4jAuditService;
import org.apache.hadoop.gateway.audit.log4j.correlation.Log4jCorrelationService;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class Log4jAuditor
implements Auditor {
    private Logger logger;
    private String componentName;
    private String serviceName;
    private AuditService auditService = new Log4jAuditService();
    private CorrelationService correlationService = new Log4jCorrelationService();

    public Log4jAuditor(String loggerName, String componentName, String serviceName) {
        this.logger = Logger.getLogger((String)loggerName);
        this.logger.setAdditivity(false);
        this.componentName = componentName;
        this.serviceName = serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void audit(CorrelationContext correlationContext, AuditContext auditContext, String action, String resourceName, String resourceType, String outcome, String message) {
        CorrelationContext previousCorrelationContext = null;
        AuditContext previousAuditContext = null;
        try {
            previousCorrelationContext = this.correlationService.getContext();
            previousAuditContext = this.auditService.getContext();
            this.auditService.attachContext(auditContext);
            this.correlationService.attachContext(correlationContext);
            this.auditLog(action, resourceName, resourceType, outcome, message);
        }
        finally {
            if (previousAuditContext != null) {
                this.auditService.attachContext(previousAuditContext);
            }
            if (previousCorrelationContext != null) {
                this.correlationService.attachContext(previousCorrelationContext);
            }
        }
    }

    @Override
    public void audit(String action, String resourceName, String resourceType, String outcome, String message) {
        this.auditLog(action, resourceName, resourceType, outcome, message);
    }

    @Override
    public void audit(String action, String resourceName, String resourceType, String outcome) {
        this.auditLog(action, resourceName, resourceType, outcome, null);
    }

    private void auditLog(String action, String resourceName, String resourceType, String outcome, String message) {
        if (this.logger.isInfoEnabled()) {
            MDC.put((String)"action", (Object)action);
            MDC.put((String)"resource_name", (Object)resourceName);
            MDC.put((String)"resource_type", (Object)resourceType);
            MDC.put((String)"outcome", (Object)outcome);
            MDC.put((String)"service_name", (Object)this.serviceName);
            MDC.put((String)"component_name", (Object)this.componentName);
            this.logger.info((Object)message);
            MDC.remove((String)"action");
            MDC.remove((String)"resource_name");
            MDC.remove((String)"resource_type");
            MDC.remove((String)"outcome");
            MDC.remove((String)"service_name");
            MDC.remove((String)"component_name");
        }
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getAuditorName() {
        return this.logger.getName();
    }
}

