/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.audit.log4j.correlation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.Callable;
import org.apache.hadoop.gateway.audit.api.CorrelationContext;
import org.apache.hadoop.gateway.audit.api.CorrelationService;
import org.apache.hadoop.gateway.audit.log4j.correlation.Log4jCorrelationContext;
import org.apache.log4j.MDC;

public class Log4jCorrelationService
implements CorrelationService {
    public static final String MDC_CORRELATION_CONTEXT_KEY = "correlation_context";

    @Override
    public CorrelationContext createContext() {
        CorrelationContext context = this.getContext();
        if (context == null) {
            context = new Log4jCorrelationContext();
            this.attachContext(context);
        }
        return context;
    }

    @Override
    public CorrelationContext getContext() {
        return (CorrelationContext)MDC.get((String)MDC_CORRELATION_CONTEXT_KEY);
    }

    @Override
    public void attachContext(CorrelationContext context) {
        if (context != null) {
            MDC.put((String)MDC_CORRELATION_CONTEXT_KEY, (Object)context);
        }
    }

    @Override
    public CorrelationContext detachContext() {
        CorrelationContext context = (CorrelationContext)MDC.get((String)MDC_CORRELATION_CONTEXT_KEY);
        MDC.remove((String)MDC_CORRELATION_CONTEXT_KEY);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(CorrelationContext context, Callable<T> callable) throws Exception {
        try {
            this.attachContext(context);
            T t = callable.call();
            return t;
        }
        finally {
            this.detachContext();
        }
    }

    @Override
    public CorrelationContext attachExternalizedContext(byte[] externalizedContext) {
        CorrelationContext context = this.readExternalizedContext(externalizedContext);
        this.attachContext(context);
        return context;
    }

    @Override
    public byte[] detachExternalizedContext() {
        byte[] result = this.getExternalizedContext();
        this.detachContext();
        return result;
    }

    @Override
    public CorrelationContext readExternalizedContext(byte[] externalizedContext) {
        ByteArrayInputStream bais = new ByteArrayInputStream(externalizedContext);
        ObjectInputStream oi = null;
        CorrelationContext context = null;
        try {
            oi = new ObjectInputStream(bais);
            context = (CorrelationContext)oi.readObject();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            try {
                bais.close();
                if (oi != null) {
                    oi.close();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return context;
    }

    @Override
    public byte[] getExternalizedContext() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.getContext());
            oos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }
}

