/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.gateway.i18n.GatewayUtilCommonMessages;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;

public class JsonUtils {
    private static final GatewayUtilCommonMessages LOG = (GatewayUtilCommonMessages)MessagesFactory.get(GatewayUtilCommonMessages.class);

    public static String renderAsJsonString(Map<String, Object> map) {
        String json = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            json = mapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            LOG.failedToSerializeMapToJSON(map, (Exception)((Object)e));
        }
        return json;
    }

    public static Map<String, String> getMapFromJsonString(String json) {
        Map map = null;
        JsonFactory factory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(factory);
        TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
        try {
            map = (Map)mapper.readValue(json, (TypeReference)typeRef);
        }
        catch (JsonParseException e) {
            LOG.failedToGetMapFromJsonString(json, (Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            LOG.failedToGetMapFromJsonString(json, (Exception)((Object)e));
        }
        catch (IOException e) {
            LOG.failedToGetMapFromJsonString(json, e);
        }
        return map;
    }
}

