/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.util;

import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;

public class MimeTypes {
    private static final String CHARSET_PARAMETER_NAME = "charset";

    public static MimeType create(String base, String encoding) {
        MimeType type = null;
        if (base != null) {
            try {
                type = new MimeType(base);
                if (encoding != null && MimeTypes.getCharset(type, null) == null) {
                    MimeTypes.setCharset(type, encoding);
                }
            }
            catch (MimeTypeParseException e) {
                throw new IllegalArgumentException(base, e);
            }
        }
        return type;
    }

    public static String getCharset(MimeType type, String defaultCharset) {
        String charset = null;
        if (type != null) {
            charset = type.getParameter(CHARSET_PARAMETER_NAME);
        }
        if (charset == null) {
            charset = defaultCharset;
        }
        return charset;
    }

    public static void setCharset(MimeType type, String charset) {
        type.setParameter(CHARSET_PARAMETER_NAME, charset);
    }
}

