/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.util.urltemplate;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.gateway.util.urltemplate.Evaluator;
import org.apache.hadoop.gateway.util.urltemplate.Function;
import org.apache.hadoop.gateway.util.urltemplate.Host;
import org.apache.hadoop.gateway.util.urltemplate.Params;
import org.apache.hadoop.gateway.util.urltemplate.Parser;
import org.apache.hadoop.gateway.util.urltemplate.Password;
import org.apache.hadoop.gateway.util.urltemplate.Path;
import org.apache.hadoop.gateway.util.urltemplate.Port;
import org.apache.hadoop.gateway.util.urltemplate.Query;
import org.apache.hadoop.gateway.util.urltemplate.Scheme;
import org.apache.hadoop.gateway.util.urltemplate.Segment;
import org.apache.hadoop.gateway.util.urltemplate.Template;
import org.apache.hadoop.gateway.util.urltemplate.Username;

public class Expander {
    private static Params EMPTY_PARAMS = new EmptyParams();

    public static URI expand(Template template, Params params, Evaluator evaluator) throws URISyntaxException {
        new Expander();
        return Expander.expandToUri(template, params, evaluator);
    }

    public static URI expandToUri(Template template, Params params, Evaluator evaluator) throws URISyntaxException {
        return new URI(Expander.expandToString(template, params, evaluator));
    }

    public static Template expandToTemplate(Template template, Params params, Evaluator evaluator) throws URISyntaxException {
        return Parser.parse(Expander.expandToString(template, params, evaluator));
    }

    public static String expandToString(Template template, Params params, Evaluator evaluator) {
        StringBuilder builder = new StringBuilder();
        if (params == null) {
            params = EMPTY_PARAMS;
        }
        HashSet<String> names = new HashSet<String>(params.getNames());
        Expander.expandScheme(template, names, params, evaluator, builder);
        Expander.expandAuthority(template, names, params, evaluator, builder);
        Expander.expandPath(template, names, params, evaluator, builder);
        Expander.expandQuery(template, names, params, evaluator, builder);
        Expander.expandFragment(template, names, params, evaluator, builder);
        return builder.toString();
    }

    private static void expandScheme(Template template, Set<String> names, Params params, Evaluator evaluator, StringBuilder builder) {
        Scheme segment = template.getScheme();
        if (segment != null) {
            Expander.expandSingleValue(template.getScheme(), names, params, evaluator, builder);
            builder.append(":");
        }
    }

    private static void expandAuthority(Template template, Set<String> names, Params params, Evaluator evaluator, StringBuilder builder) {
        if (template.hasAuthority()) {
            if (!template.isAuthorityOnly()) {
                builder.append("//");
            }
            Username username = template.getUsername();
            Password password = template.getPassword();
            Host host = template.getHost();
            Port port = template.getPort();
            Expander.expandSingleValue(username, names, params, evaluator, builder);
            if (password != null) {
                builder.append(":");
                Expander.expandSingleValue(password, names, params, evaluator, builder);
            }
            if (username != null || password != null) {
                builder.append("@");
            }
            if (host != null) {
                Expander.expandSingleValue(host, names, params, evaluator, builder);
            }
            if (port != null) {
                builder.append(":");
                Expander.expandSingleValue(port, names, params, evaluator, builder);
            }
        }
    }

    private static void expandPath(Template template, Set<String> names, Params params, Evaluator evaluator, StringBuilder builder) {
        if (template.isAbsolute()) {
            builder.append("/");
        }
        List<Path> path = template.getPath();
        int n = path.size();
        block4: for (int i = 0; i < n; ++i) {
            if (i > 0) {
                builder.append("/");
            }
            Path segment = path.get(i);
            String name = segment.getParamName();
            Function function = new Function(name);
            names.remove(function.getParameterName());
            Segment.Value value = segment.getFirstValue();
            switch (value.getType()) {
                case 1: {
                    String pattern = value.getOriginalPattern();
                    builder.append(pattern);
                    continue block4;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    List<String> values = function.evaluate(params, evaluator);
                    Expander.expandPathValues(segment, values, builder);
                }
            }
        }
        if (template.isDirectory() && path.size() > 0) {
            builder.append("/");
        }
    }

    private static void expandPathValues(Path segment, List<String> values, StringBuilder builder) {
        if (values != null && values.size() > 0) {
            int type = segment.getFirstValue().getType();
            if (type == 5 || type == 4) {
                int n = values.size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        builder.append("/");
                    }
                    builder.append(values.get(i));
                }
            } else {
                builder.append(values.get(0));
            }
        } else {
            builder.append(segment.getFirstValue().getOriginalPattern());
        }
    }

    private static void expandQuery(Template template, Set<String> names, Params params, Evaluator evaluator, StringBuilder builder) {
        AtomicInteger index = new AtomicInteger(0);
        Expander.expandExplicitQuery(template, names, params, evaluator, builder, index);
        Expander.expandExtraQuery(template, names, params, builder, index);
    }

    private static void expandExplicitQuery(Template template, Set<String> names, Params params, Evaluator evaluator, StringBuilder builder, AtomicInteger index) {
        Collection<Query> query = template.getQuery().values();
        if (!query.isEmpty()) {
            Iterator<Query> iterator = query.iterator();
            while (iterator.hasNext()) {
                int i = index.incrementAndGet();
                if (i == 1) {
                    builder.append("?");
                } else {
                    builder.append("&");
                }
                Query segment = iterator.next();
                String queryName = segment.getQueryName();
                String paramName = segment.getParamName();
                Function function = new Function(paramName);
                names.remove(function.getParameterName());
                for (Segment.Value value : segment.getValues()) {
                    switch (value.getType()) {
                        case 1: {
                            builder.append(queryName);
                            String pattern = value.getOriginalPattern();
                            if (pattern == null) break;
                            builder.append("=");
                            builder.append(pattern);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            List<String> values = function.evaluate(params, evaluator);
                            Expander.expandQueryValues(segment, queryName, values, builder);
                            break;
                        }
                    }
                }
            }
        }
    }

    private static void expandExtraQuery(Template template, Set<String> names, Params params, StringBuilder builder, AtomicInteger index) {
        Query extra = template.getExtra();
        if (extra != null) {
            String[] array = new String[names.size()];
            names.toArray(array);
            for (String name : array) {
                names.remove(name);
                List<String> values = params.resolve(name);
                if (values == null) continue;
                for (String value : values) {
                    int i = index.incrementAndGet();
                    if (i == 1) {
                        builder.append("?");
                    } else {
                        builder.append("&");
                    }
                    builder.append(name);
                    builder.append("=");
                    builder.append(value);
                }
            }
        }
    }

    private static void expandQueryValues(Query segment, String queryName, List<String> values, StringBuilder builder) {
        if (values == null || values.size() == 0) {
            builder.append(queryName);
        } else {
            int type = segment.getFirstValue().getType();
            if (type == 5 || type == 4) {
                int n = values.size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        builder.append("&");
                    }
                    builder.append(queryName);
                    builder.append("=");
                    builder.append(values.get(i));
                }
            } else {
                builder.append(queryName);
                builder.append("=");
                builder.append(values.get(0));
            }
        }
    }

    private static void expandFragment(Template template, Set<String> names, Params params, Evaluator evaluator, StringBuilder builder) {
        if (template.hasFragment()) {
            builder.append("#");
        }
        Expander.expandSingleValue(template.getFragment(), names, params, evaluator, builder);
    }

    private static void expandSingleValue(Segment segment, Set<String> names, Params params, Evaluator evaluator, StringBuilder builder) {
        if (segment != null) {
            String str;
            String paramName = segment.getParamName();
            Function function = new Function(paramName);
            names.remove(function.getParameterName());
            Segment.Value value = segment.getFirstValue();
            switch (value.getType()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    List<String> values = function.evaluate(params, evaluator);
                    if (values != null && !values.isEmpty()) {
                        str = values.get(0);
                        break;
                    }
                    if (function.getFunctionName() != null) {
                        str = paramName;
                        break;
                    }
                    str = value.getOriginalPattern();
                    break;
                }
                default: {
                    str = value.getOriginalPattern();
                }
            }
            builder.append(str);
        }
    }

    private static class EmptyParams
    implements Params {
        private EmptyParams() {
        }

        @Override
        public Set<String> getNames() {
            return Collections.EMPTY_SET;
        }

        @Override
        public List<String> resolve(String name) {
            return Collections.EMPTY_LIST;
        }
    }
}

