/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.util.urltemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.gateway.util.urltemplate.Params;
import org.apache.hadoop.gateway.util.urltemplate.Path;
import org.apache.hadoop.gateway.util.urltemplate.Query;
import org.apache.hadoop.gateway.util.urltemplate.Segment;
import org.apache.hadoop.gateway.util.urltemplate.Template;

public class Matcher<V> {
    private Map<Template, V> map = new LinkedHashMap<Template, V>();
    private PathNode root = new PathNode(null, null);

    public Matcher() {
    }

    public Matcher(Template template, V value) {
        this();
        this.add(template, value);
    }

    public V get(Template template) {
        return this.map.get(template);
    }

    public void add(Template template, V value) {
        this.map.put(template, value);
        PathNode node = this.root;
        node = this.add(node, template.getScheme());
        node = this.add(node, template.getUsername());
        node = this.add(node, template.getPassword());
        node = this.add(node, template.getHost());
        node = this.add(node, template.getPort());
        for (Path segment : template.getPath()) {
            node = this.add(node, segment);
        }
        node = this.add(node, template.getFragment());
        if (template.getQuery().isEmpty() && template.getExtra() == null) {
            if (node.value == null) {
                node.template = template;
                node.value = value;
            }
        } else {
            node.addQuery(template, value);
        }
    }

    private PathNode add(PathNode parent, Segment segment) {
        PathNode child = parent;
        if (segment != null) {
            child = parent.children != null && parent.children.containsKey(segment) ? parent.children.get(segment) : parent.addPath(segment);
        }
        return child;
    }

    public Match match(Template input) {
        Status status = new Status();
        status.candidates.add(new MatchSegment(null, this.root, null, null));
        boolean matches = true;
        matches &= this.matchScheme(input, status);
        matches &= this.matchAuthority(input, status);
        matches &= this.matchPath(input, status);
        Match winner = (matches &= this.matchFragment(input, status)) ? this.pickBestMatch(input, status) : null;
        return winner;
    }

    private boolean matchScheme(Template input, Status status) {
        this.pickMatchingChildren(input.getScheme(), status);
        return status.hasCandidates();
    }

    private boolean matchAuthority(Template input, Status status) {
        this.pickMatchingChildren(input.getUsername(), status);
        this.pickMatchingChildren(input.getPassword(), status);
        this.pickMatchingChildren(input.getHost(), status);
        this.pickMatchingChildren(input.getPort(), status);
        return status.hasCandidates();
    }

    private boolean matchPath(Template input, Status status) {
        Iterator<Path> segments = input.getPath().iterator();
        while (segments.hasNext() && status.hasCandidates()) {
            Path segment = segments.next();
            this.pickMatchingChildren(segment, status);
        }
        return status.hasCandidates();
    }

    private boolean matchFragment(Template input, Status status) {
        this.pickMatchingChildren(input.getFragment(), status);
        return status.hasCandidates();
    }

    private void pickMatchingChildren(Segment segment, Status status) {
        if (segment != null) {
            for (MatchSegment parent : status.candidates) {
                if (parent.pathNode.hasGlob()) {
                    status.matches.add(new MatchSegment(parent, parent.pathNode, ((MatchSegment)parent).pathNode.segment, segment));
                }
                if (((MatchSegment)parent).pathNode.children == null) continue;
                for (PathNode node : ((MatchSegment)parent).pathNode.children.values()) {
                    if (!node.matches(segment)) continue;
                    status.matches.add(new MatchSegment(parent, node, node.segment, segment));
                }
            }
            status.swapMatchesToCandidates();
        }
    }

    private Match pickBestMatch(Template input, Status status) {
        Match bestMatch = new Match(null, null);
        PathNode bestPath = null;
        QueryNode bestQuery = null;
        MatchSegment bestMatchSegment = null;
        for (MatchSegment matchSegment : status.candidates) {
            PathNode pathNode = matchSegment.pathNode;
            if (bestPath != null && pathNode.depth <= bestPath.depth && (pathNode.depth != bestPath.depth || pathNode.getType() >= bestPath.getType())) continue;
            if (pathNode.template != null) {
                bestPath = pathNode;
                bestQuery = null;
                bestMatch.template = pathNode.template;
                bestMatch.value = pathNode.value;
                bestMatchSegment = matchSegment;
            }
            if (!pathNode.hasQueries() || (bestQuery = this.pickBestQueryMatch(input, pathNode)) == null || bestQuery.template == null) continue;
            bestPath = pathNode;
            bestMatch.template = bestQuery.template;
            bestMatch.value = bestQuery.value;
            bestMatchSegment = matchSegment;
        }
        Match match = this.createMatch(bestMatchSegment, bestPath, bestQuery, input);
        return match;
    }

    private QueryNode pickBestQueryMatch(Template input, PathNode pathNode) {
        QueryNode bestNode = null;
        int bestMatchCount = 0;
        for (QueryNode node : pathNode.queries) {
            boolean matchesExtraQuery;
            Query extra = node.template.getExtra();
            int nodeQuerySize = node.template.getQuery().size();
            int queryMatchCount = this.calcQueryMatchCount(node, input);
            boolean matchesNamedQueries = queryMatchCount >= nodeQuerySize;
            boolean bl = matchesExtraQuery = extra == null || "**".equals(extra.getQueryName()) || input.getQuery().size() > nodeQuerySize;
            if (bestNode != null && queryMatchCount <= bestMatchCount || !matchesNamedQueries || !matchesExtraQuery) continue;
            bestMatchCount = queryMatchCount;
            bestNode = node;
        }
        return bestNode;
    }

    private int calcQueryMatchCount(QueryNode node, Template input) {
        int matchCount = 0;
        Map<String, Query> inputQuery = input.getQuery();
        Map<String, Query> templateQuery = node.template.getQuery();
        for (Query templateSegment : templateQuery.values()) {
            Query inputSegment = inputQuery.get(templateSegment.getQueryName());
            if (inputSegment != null && templateSegment.matches(inputSegment)) {
                ++matchCount;
                continue;
            }
            matchCount = 0;
            break;
        }
        return matchCount;
    }

    private Match createMatch(MatchSegment bestMatchSegment, PathNode bestPath, QueryNode bestQuery, Template input) {
        Match match = null;
        if (bestPath != null) {
            String paramName;
            Query extra;
            match = bestQuery != null ? new Match(bestQuery.template, bestQuery.value) : new Match(bestPath.template, bestPath.value);
            MatchParams matchParams = new MatchParams();
            if (bestQuery != null) {
                Map<String, Query> inputQuery = input.getQuery();
                for (Query templateSegment : bestQuery.template.getQuery().values()) {
                    Query inputSegment = inputQuery.get(templateSegment.getQueryName());
                    if (inputSegment == null || !templateSegment.matches(inputSegment)) continue;
                    this.extractSegmentParams(templateSegment, inputSegment, matchParams);
                }
            }
            if (bestQuery != null && (extra = bestQuery.template.getExtra()) != null && (paramName = extra.getParamName()) != null && paramName.length() > 0) {
                for (Query query : input.getQuery().values()) {
                    String queryName = query.getQueryName();
                    if (matchParams.resolve(queryName) != null) continue;
                    for (Segment.Value value : query.getValues()) {
                        matchParams.addValue(queryName, value.getEffectivePattern());
                    }
                }
            }
            MatchSegment matchSegment = bestMatchSegment;
            while (matchSegment != null && ((MatchSegment)matchSegment).pathNode.depth > 0) {
                this.extractSegmentParams(matchSegment.templateSegment, matchSegment.inputSegment, matchParams);
                matchSegment = matchSegment.parentMatch;
            }
            match.params = matchParams;
        }
        return match;
    }

    private void extractSegmentParams(Segment extractSegment, Segment inputSegment, MatchParams params) {
        String paramName;
        if (extractSegment != null && inputSegment != null && (paramName = extractSegment.getParamName()).length() > 0) {
            for (Segment.Value value : inputSegment.getValues()) {
                params.insertValue(paramName, value.getEffectivePattern());
            }
        }
    }

    private class Node {
        Template template;
        V value;

        private Node(Template template, V value) {
            this.template = template;
            this.value = value;
        }
    }

    private class QueryNode
    extends Node {
        private QueryNode(Template template, V value) {
            super(template, value);
        }
    }

    private class PathNode
    extends Node {
        int depth;
        Segment segment;
        Map<Segment, PathNode> children;
        Set<QueryNode> queries;

        private PathNode(PathNode parent, Segment segment) {
            super(null, null);
            this.depth = parent == null ? 0 : parent.depth + 1;
            this.segment = segment;
            this.children = null;
            this.queries = null;
        }

        private PathNode addPath(Segment path) {
            if (this.children == null) {
                this.children = new LinkedHashMap<Segment, PathNode>();
            }
            PathNode child = new PathNode(this, path);
            this.children.put(path, child);
            return child;
        }

        private QueryNode addQuery(Template template, V value) {
            if (this.queries == null) {
                this.queries = new LinkedHashSet<QueryNode>();
            }
            QueryNode query = new QueryNode(template, value);
            this.queries.add(query);
            return query;
        }

        private int getType() {
            int type;
            block1: {
                Segment.Value value;
                int vType;
                type = 6;
                if (this.segment == null) break block1;
                Iterator<Segment.Value> i$ = this.segment.getValues().iterator();
                while (i$.hasNext() && (type = type < (vType = (value = i$.next()).getType()) ? type : vType) != 1) {
                }
            }
            return type;
        }

        private boolean hasGlob() {
            boolean is = false;
            if (this.segment != null) {
                for (Segment.Value value : this.segment.getValues()) {
                    if (5 != value.getType()) continue;
                    is = true;
                }
            }
            return is;
        }

        private boolean hasQueries() {
            return this.queries != null && this.queries.size() > 0;
        }

        private boolean matches(Segment segment) {
            return this.segment.matches(segment);
        }
    }

    public class Match {
        private Template template;
        private V value;
        private Params params;

        private Match(Template template, V value) {
            this.template = template;
            this.value = value;
        }

        public Template getTemplate() {
            return this.template;
        }

        public V getValue() {
            return this.value;
        }

        public Params getParams() {
            return this.params;
        }
    }

    private class MatchParams
    implements Params {
        private Map<String, List<String>> map = new HashMap<String, List<String>>();

        private MatchParams() {
        }

        @Override
        public Set<String> getNames() {
            return this.map.keySet();
        }

        private List<String> getOrAddValues(String name) {
            List<String> values = this.resolve(name);
            if (values == null) {
                values = new ArrayList<String>(1);
                this.map.put(name, values);
            }
            return values;
        }

        public void addValue(String name, String value) {
            List<String> values = this.getOrAddValues(name);
            values.add(value);
        }

        public void insertValue(String name, String value) {
            List<String> values = this.getOrAddValues(name);
            values.add(0, value);
        }

        @Override
        public List<String> resolve(String name) {
            return this.map.get(name);
        }
    }

    private class MatchSegment {
        private MatchSegment parentMatch;
        private PathNode pathNode;
        private Segment templateSegment;
        private Segment inputSegment;

        private MatchSegment(MatchSegment parent, PathNode node, Segment templateSegment, Segment inputSegment) {
            this.parentMatch = parent;
            this.pathNode = node;
            this.templateSegment = templateSegment;
            this.inputSegment = inputSegment;
        }
    }

    private class Status {
        List<MatchSegment> candidates = new ArrayList<MatchSegment>();
        List<MatchSegment> matches = new ArrayList<MatchSegment>();
        List<MatchSegment> temp;

        private Status() {
        }

        private void swapMatchesToCandidates() {
            this.temp = this.candidates;
            this.candidates = this.matches;
            this.matches = this.temp;
            this.matches.clear();
        }

        private boolean hasCandidates() {
            return !this.candidates.isEmpty();
        }
    }
}

