/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.util.urltemplate;

import java.net.URISyntaxException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.gateway.i18n.resources.ResourcesFactory;
import org.apache.hadoop.gateway.util.urltemplate.Builder;
import org.apache.hadoop.gateway.util.urltemplate.Path;
import org.apache.hadoop.gateway.util.urltemplate.Resources;
import org.apache.hadoop.gateway.util.urltemplate.Scheme;
import org.apache.hadoop.gateway.util.urltemplate.Template;
import org.apache.hadoop.gateway.util.urltemplate.Token;

public class Parser {
    private static final Resources RES = (Resources)ResourcesFactory.get(Resources.class);
    public static final char TEMPLATE_OPEN_MARKUP = '{';
    public static final char TEMPLATE_CLOSE_MARKUP = '}';
    public static final char NAME_PATTERN_SEPARATOR = '=';
    private static final int MATCH_GROUP_SCHEME = 1;
    private static final int MATCH_GROUP_SCHEME_NAKED = 2;
    private static final int MATCH_GROUP_AUTHORITY = 3;
    private static final int MATCH_GROUP_AUTHORITY_NAKED = 4;
    private static final int MATCH_GROUP_PATH = 5;
    private static final int MATCH_GROUP_QUERY = 6;
    private static final int MATCH_GROUP_QUERY_NAKED = 7;
    private static final int MATCH_GROUP_FRAGMENT = 8;
    private static final int MATCH_GROUP_FRAGMENT_NAKED = 9;
    private static Pattern PATTERN = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private String template;
    private Builder builder;

    public static Template parse(String template) throws URISyntaxException {
        return new Parser().parseTemplate(template);
    }

    public Template parseTemplate(String template) throws URISyntaxException {
        this.template = template;
        this.builder = new Builder(template);
        this.builder.setHasScheme(false);
        this.builder.setHasAuthority(false);
        this.builder.setIsAuthorityOnly(false);
        this.builder.setIsAbsolute(false);
        this.builder.setIsDirectory(false);
        this.builder.setHasQuery(false);
        this.builder.setHasFragment(false);
        Matcher match = PATTERN.matcher(template);
        if (!match.matches()) {
            throw new URISyntaxException(template, RES.parseTemplateFailureReason(template));
        }
        this.consumeSchemeMatch(match);
        this.consumeAuthorityMatch(match);
        this.consumePathMatch(match);
        this.consumeQueryMatch(match);
        this.consumeFragmentMatch(match);
        this.fixNakedAuthority();
        return this.builder.build();
    }

    private void fixNakedAuthority() {
        if (!(!this.builder.getHashScheme() || this.builder.getHasAuthority() || this.builder.getIsAbsolute() || this.builder.getIsDirectory() || this.builder.getPath().size() != 1 || this.builder.getHasQuery() || this.builder.getHasFragment())) {
            Scheme scheme = this.builder.getScheme();
            this.builder.setHasScheme(false);
            this.builder.setHost(this.makeTokenSingular(scheme.getToken()));
            Path path = this.builder.getPath().remove(0);
            this.builder.setPort(this.makeTokenSingular(path.getToken()));
            this.builder.setIsAuthorityOnly(true);
        }
    }

    private Token makeTokenSingular(Token token) {
        String effectivePattern = token.getEffectivePattern();
        if ("**".equals(effectivePattern)) {
            token = new Token(token.getParameterName(), token.getOriginalPattern(), "*");
        }
        return token;
    }

    private void consumeSchemeMatch(Matcher match) {
        if (match.group(1) != null) {
            this.builder.setHasScheme(true);
            this.consumeSchemeToken(match.group(2));
        }
    }

    private void consumeSchemeToken(String token) {
        if (token != null) {
            Token t = Parser.parseTemplateToken(token, "*");
            this.builder.setScheme(t);
        }
    }

    private void consumeAuthorityMatch(Matcher match) {
        if (match.group(3) != null) {
            this.builder.setHasAuthority(true);
            this.consumeAuthorityToken(match.group(4));
        }
    }

    private void consumeAuthorityToken(String token) {
        if (token != null) {
            Token paramPattern;
            String[] hostPort;
            String[] usernamePassword = null;
            String[] userAddr = Parser.split(token, '@');
            if (userAddr.length == 1) {
                hostPort = Parser.split(userAddr[0], ':');
            } else {
                usernamePassword = Parser.split(userAddr[0], ':');
                hostPort = Parser.split(userAddr[1], ':');
            }
            if (usernamePassword != null) {
                if (usernamePassword[0].length() > 0) {
                    paramPattern = this.makeTokenSingular(Parser.parseTemplateToken(usernamePassword[0], "*"));
                    this.builder.setUsername(paramPattern);
                }
                if (usernamePassword.length > 1 && usernamePassword[1].length() > 0) {
                    paramPattern = this.makeTokenSingular(Parser.parseTemplateToken(usernamePassword[1], "*"));
                    this.builder.setPassword(paramPattern);
                }
            }
            if (hostPort[0].length() > 0) {
                paramPattern = this.makeTokenSingular(Parser.parseTemplateToken(hostPort[0], "*"));
                this.builder.setHost(paramPattern);
            }
            if (hostPort.length > 1 && hostPort[1].length() > 0) {
                paramPattern = this.makeTokenSingular(Parser.parseTemplateToken(hostPort[1], "*"));
                this.builder.setPort(paramPattern);
            }
        }
    }

    private void consumePathMatch(Matcher match) {
        String path = match.group(5);
        if (path != null) {
            this.builder.setIsAbsolute(path.startsWith("/"));
            this.builder.setIsDirectory(path.endsWith("/"));
            this.consumePathToken(path);
        }
    }

    private void consumePathToken(String token) {
        if (token != null) {
            StringTokenizer tokenizer = new StringTokenizer(token, "/");
            while (tokenizer.hasMoreTokens()) {
                this.consumePathSegment(tokenizer.nextToken());
            }
        }
    }

    private void consumePathSegment(String token) {
        if (token != null) {
            Token t = Parser.parseTemplateToken(token, "**");
            this.builder.addPath(t);
        }
    }

    private void consumeQueryMatch(Matcher match) {
        if (match.group(6) != null) {
            this.builder.setHasQuery(true);
            this.consumeQueryToken(match.group(7));
        }
    }

    private void consumeQueryToken(String token) {
        if (token != null) {
            StringTokenizer tokenizer = new StringTokenizer(token, "?&");
            while (tokenizer.hasMoreTokens()) {
                this.consumeQuerySegment(tokenizer.nextToken());
            }
        }
    }

    private void consumeQuerySegment(String token) {
        if (token != null && token.length() > 0) {
            if ('{' == token.charAt(0)) {
                Token paramPattern = Parser.parseTemplateToken(token, "**");
                String paramName = paramPattern.parameterName;
                if (paramPattern.originalPattern == null) {
                    this.builder.addQuery(paramName, new Token(paramName, null, "**"));
                } else {
                    this.builder.addQuery(paramName, new Token(paramName, paramPattern.originalPattern));
                }
            } else {
                String[] nameValue = Parser.split(token, '=');
                if (nameValue.length == 1) {
                    String queryName = nameValue[0];
                    this.builder.addQuery(queryName, new Token("", null));
                } else {
                    String queryName = nameValue[0];
                    Token paramPattern = Parser.parseTemplateToken(nameValue[1], "**");
                    this.builder.addQuery(queryName, paramPattern);
                }
            }
        }
    }

    private void consumeFragmentMatch(Matcher match) {
        if (match.group(8) != null) {
            this.builder.setHasFragment(true);
            this.consumeFragmentToken(match.group(9));
        }
    }

    private void consumeFragmentToken(String token) {
        if (token != null && token.length() > 0) {
            Token t = Parser.parseTemplateToken(token, "*");
            this.builder.setFragment(t);
        }
    }

    static Token parseTemplateToken(String s, String defaultEffectivePattern) {
        String effectivePattern;
        String actualPattern;
        String paramName;
        int l = s.length();
        if (l > 0) {
            int e;
            int b = s.charAt(0) == '{' ? 1 : -1;
            int n = e = s.charAt(l - 1) == '}' ? l - 1 : -1;
            if (b > 0 && e > 0 && e > b) {
                int i = s.indexOf(61, b);
                if (i < 0) {
                    paramName = s.substring(b, e);
                    actualPattern = null;
                    effectivePattern = "**".equals(paramName) ? "**" : defaultEffectivePattern;
                } else {
                    paramName = s.substring(b, i);
                    effectivePattern = actualPattern = s.substring(i + 1, e);
                }
            } else {
                paramName = "";
                effectivePattern = actualPattern = s;
            }
        } else {
            paramName = "";
            effectivePattern = actualPattern = null;
        }
        Token token = new Token(paramName, actualPattern, effectivePattern);
        return token;
    }

    private static String[] split(String s, char d) {
        int i = s.indexOf(d);
        String[] a = i < 0 ? new String[]{s} : new String[]{s.substring(0, i), s.substring(i + 1)};
        return a;
    }
}

