/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.analysis.ko.util.TokenInfoDictionaryWriter;
import org.apache.lucene.analysis.util.CSVUtil;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTCompiler;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;

class TokenInfoDictionaryBuilder {
    private int offset = 0;
    private String encoding;
    private Normalizer.Form normalForm;

    TokenInfoDictionaryBuilder(String encoding, boolean normalizeEntries) {
        this.encoding = encoding;
        this.normalForm = normalizeEntries ? Normalizer.Form.NFKC : null;
    }

    public TokenInfoDictionaryWriter build(Path dir) throws IOException {
        try (Stream<Path> files = Files.list(dir);){
            List<Path> csvFiles = files.filter(path -> path.getFileName().toString().endsWith(".csv")).sorted().collect(Collectors.toList());
            TokenInfoDictionaryWriter tokenInfoDictionaryWriter = this.buildDictionary(csvFiles);
            return tokenInfoDictionaryWriter;
        }
    }

    private TokenInfoDictionaryWriter buildDictionary(List<Path> csvFiles) throws IOException {
        TokenInfoDictionaryWriter dictionary = new TokenInfoDictionaryWriter(0xA00000);
        ArrayList<String[]> lines = new ArrayList<String[]>(400000);
        for (Path path : csvFiles) {
            BufferedReader reader = Files.newBufferedReader(path, Charset.forName(this.encoding));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] entry = CSVUtil.parse((String)line);
                    if (entry.length < 12) {
                        throw new IllegalArgumentException("Entry in CSV is not valid (12 field values expected): " + line);
                    }
                    if (this.normalForm != null) {
                        String[] normalizedEntry = new String[entry.length];
                        for (int i = 0; i < entry.length; ++i) {
                            normalizedEntry[i] = Normalizer.normalize(entry[i], this.normalForm);
                        }
                        lines.add(normalizedEntry);
                        continue;
                    }
                    lines.add(entry);
                }
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
        lines.sort(Comparator.comparing(left -> left[0]));
        PositiveIntOutputs fstOutput = PositiveIntOutputs.getSingleton();
        FSTCompiler fstCompiler = new FSTCompiler.Builder(FST.INPUT_TYPE.BYTE2, (Outputs)fstOutput).build();
        IntsRefBuilder scratch = new IntsRefBuilder();
        long ord = -1L;
        String lastValue = null;
        for (Object[] objectArray : lines) {
            String surfaceForm = objectArray[0].trim();
            if (surfaceForm.isEmpty()) continue;
            int next = dictionary.put((String[])objectArray);
            if (next == this.offset) {
                throw new IllegalStateException("Failed to process line: " + Arrays.toString(objectArray));
            }
            if (!surfaceForm.equals(lastValue)) {
                ++ord;
                lastValue = surfaceForm;
                scratch.grow(surfaceForm.length());
                scratch.setLength(surfaceForm.length());
                for (int i = 0; i < surfaceForm.length(); ++i) {
                    scratch.setIntAt(i, (int)surfaceForm.charAt(i));
                }
                fstCompiler.add(scratch.get(), (Object)ord);
            }
            dictionary.addMapping((int)ord, this.offset);
            this.offset = next;
        }
        dictionary.setFST((FST<Long>)fstCompiler.compile());
        return dictionary;
    }
}

