/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.Collection;
import java.util.List;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.Node;
import org.apache.maven.api.Project;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.DependencyCollector;
import org.apache.maven.api.services.DependencyCollectorException;
import org.apache.maven.api.services.DependencyCollectorRequest;
import org.apache.maven.api.services.DependencyCollectorResult;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;

@Named
@Singleton
public class DefaultDependencyCollector
implements DependencyCollector {
    @Nonnull
    public DependencyCollectorResult collect(final @Nonnull DependencyCollectorRequest request) throws DependencyCollectorException, IllegalArgumentException {
        List remoteRepositories;
        Collection managedDependencies;
        Collection dependencies;
        DependencyCoordinate root;
        Artifact rootArtifact;
        Utils.nonNull(request, "request");
        final InternalSession session = InternalSession.from(request.getSession());
        if (request.getProject().isPresent()) {
            Project project = (Project)request.getProject().get();
            rootArtifact = project.getPomArtifact();
            root = null;
            dependencies = project.getDependencies();
            managedDependencies = project.getManagedDependencies();
            remoteRepositories = ((ProjectManager)session.getService(ProjectManager.class)).getRemoteProjectRepositories(project);
        } else {
            rootArtifact = request.getRootArtifact().orElse(null);
            root = request.getRoot().orElse(null);
            dependencies = request.getDependencies();
            managedDependencies = request.getManagedDependencies();
            remoteRepositories = session.getRemoteRepositories();
        }
        CollectRequest collectRequest = new CollectRequest().setRootArtifact(rootArtifact != null ? session.toArtifact(rootArtifact) : null).setRoot(root != null ? session.toDependency(root, false) : null).setDependencies(session.toDependencies(dependencies, false)).setManagedDependencies(session.toDependencies(managedDependencies, true)).setRepositories(session.toRepositories(remoteRepositories));
        RepositorySystemSession systemSession = session.getSession();
        if (request.getVerbose()) {
            systemSession = new DefaultRepositorySystemSession(systemSession).setConfigProperty("aether.conflictResolver.verbose", (Object)true).setConfigProperty("aether.dependencyManager.verbose", (Object)true);
        }
        try {
            final CollectResult result = session.getRepositorySystem().collectDependencies(systemSession, collectRequest);
            return new DependencyCollectorResult(){

                public List<Exception> getExceptions() {
                    return result.getExceptions();
                }

                public Node getRoot() {
                    return session.getNode(result.getRoot(), request.getVerbose());
                }
            };
        }
        catch (DependencyCollectionException e) {
            throw new DependencyCollectorException("Unable to collect dependencies", (Throwable)e);
        }
    }
}

