/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.Session;
import org.apache.maven.api.VersionRange;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.feature.Features;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.ActivationFile;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.Exclusion;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.InputSource;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginManagement;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelBuilder;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelBuilderResult;
import org.apache.maven.api.services.ModelCache;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.ModelRepositoryHolder;
import org.apache.maven.api.services.ModelResolver;
import org.apache.maven.api.services.ModelResolverException;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.ModelTransformer;
import org.apache.maven.api.services.ModelTransformerContext;
import org.apache.maven.api.services.ModelTransformerContextBuilder;
import org.apache.maven.api.services.ModelTransformerException;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.SuperPomProvider;
import org.apache.maven.api.services.VersionParserException;
import org.apache.maven.api.services.model.DependencyManagementImporter;
import org.apache.maven.api.services.model.DependencyManagementInjector;
import org.apache.maven.api.services.model.InheritanceAssembler;
import org.apache.maven.api.services.model.LifecycleBindingsInjector;
import org.apache.maven.api.services.model.ModelBuildingEvent;
import org.apache.maven.api.services.model.ModelBuildingListener;
import org.apache.maven.api.services.model.ModelInterpolator;
import org.apache.maven.api.services.model.ModelNormalizer;
import org.apache.maven.api.services.model.ModelPathTranslator;
import org.apache.maven.api.services.model.ModelProcessor;
import org.apache.maven.api.services.model.ModelUrlNormalizer;
import org.apache.maven.api.services.model.ModelValidator;
import org.apache.maven.api.services.model.ModelVersionParser;
import org.apache.maven.api.services.model.PluginConfigurationExpander;
import org.apache.maven.api.services.model.PluginManagementInjector;
import org.apache.maven.api.services.model.ProfileInjector;
import org.apache.maven.api.services.model.ProfileSelector;
import org.apache.maven.api.services.model.WorkspaceModelResolver;
import org.apache.maven.api.services.xml.XmlReaderException;
import org.apache.maven.api.services.xml.XmlReaderRequest;
import org.apache.maven.internal.impl.model.DefaultModelBuilderResult;
import org.apache.maven.internal.impl.model.DefaultModelBuildingEvent;
import org.apache.maven.internal.impl.model.DefaultModelProblemCollector;
import org.apache.maven.internal.impl.model.DefaultModelTransformerContextBuilder;
import org.apache.maven.internal.impl.model.DefaultProfileActivationContext;
import org.apache.maven.internal.impl.model.ModelData;
import org.apache.maven.internal.impl.model.ModelProblemUtils;
import org.apache.maven.internal.impl.model.ProfileActivationFilePathInterpolator;
import org.apache.maven.internal.impl.model.Result;
import org.apache.maven.internal.impl.resolver.DefaultModelCache;
import org.apache.maven.internal.impl.resolver.DefaultModelRepositoryHolder;
import org.apache.maven.internal.impl.resolver.DefaultModelResolver;
import org.apache.maven.model.v4.MavenTransformer;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultModelBuilder
implements ModelBuilder {
    private static final String RAW = "raw";
    private static final String FILE = "file";
    private static final String IMPORT = "import";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ModelProcessor modelProcessor;
    private final ModelValidator modelValidator;
    private final ModelNormalizer modelNormalizer;
    private final ModelInterpolator modelInterpolator;
    private final ModelPathTranslator modelPathTranslator;
    private final ModelUrlNormalizer modelUrlNormalizer;
    private final SuperPomProvider superPomProvider;
    private final InheritanceAssembler inheritanceAssembler;
    private final ProfileSelector profileSelector;
    private final ProfileInjector profileInjector;
    private final PluginManagementInjector pluginManagementInjector;
    private final DependencyManagementInjector dependencyManagementInjector;
    private final DependencyManagementImporter dependencyManagementImporter;
    private final LifecycleBindingsInjector lifecycleBindingsInjector;
    private final PluginConfigurationExpander pluginConfigurationExpander;
    private final ProfileActivationFilePathInterpolator profileActivationFilePathInterpolator;
    private final ModelTransformer transformer;
    private final ModelVersionParser versionParser;

    @Inject
    public DefaultModelBuilder(ModelProcessor modelProcessor, ModelValidator modelValidator, ModelNormalizer modelNormalizer, ModelInterpolator modelInterpolator, ModelPathTranslator modelPathTranslator, ModelUrlNormalizer modelUrlNormalizer, SuperPomProvider superPomProvider, InheritanceAssembler inheritanceAssembler, ProfileSelector profileSelector, ProfileInjector profileInjector, PluginManagementInjector pluginManagementInjector, DependencyManagementInjector dependencyManagementInjector, DependencyManagementImporter dependencyManagementImporter, @Nullable LifecycleBindingsInjector lifecycleBindingsInjector, PluginConfigurationExpander pluginConfigurationExpander, ProfileActivationFilePathInterpolator profileActivationFilePathInterpolator, ModelTransformer transformer, ModelVersionParser versionParser) {
        this.modelProcessor = modelProcessor;
        this.modelValidator = modelValidator;
        this.modelNormalizer = modelNormalizer;
        this.modelInterpolator = modelInterpolator;
        this.modelPathTranslator = modelPathTranslator;
        this.modelUrlNormalizer = modelUrlNormalizer;
        this.superPomProvider = superPomProvider;
        this.inheritanceAssembler = inheritanceAssembler;
        this.profileSelector = profileSelector;
        this.profileInjector = profileInjector;
        this.pluginManagementInjector = pluginManagementInjector;
        this.dependencyManagementInjector = dependencyManagementInjector;
        this.dependencyManagementImporter = dependencyManagementImporter;
        this.lifecycleBindingsInjector = lifecycleBindingsInjector;
        this.pluginConfigurationExpander = pluginConfigurationExpander;
        this.profileActivationFilePathInterpolator = profileActivationFilePathInterpolator;
        this.transformer = transformer;
        this.versionParser = versionParser;
    }

    public ModelTransformerContextBuilder newTransformerContextBuilder() {
        return new DefaultModelTransformerContextBuilder(this);
    }

    public ModelBuilderResult build(ModelBuilderRequest request) throws ModelBuilderException {
        if ((request = DefaultModelBuilder.fillRequestDefaults(request)).getInterimResult() != null) {
            return this.build(request, request.getInterimResult(), new LinkedHashSet<String>());
        }
        return this.build(request, new LinkedHashSet<String>());
    }

    private static ModelBuilderRequest fillRequestDefaults(ModelBuilderRequest request) {
        ModelBuilderRequest.ModelBuilderRequestBuilder builder = ModelBuilderRequest.builder((ModelBuilderRequest)request);
        if (request.getModelCache() == null) {
            builder.modelCache((ModelCache)new DefaultModelCache());
        }
        if (request.getModelRepositoryHolder() == null) {
            builder.modelRepositoryHolder((ModelRepositoryHolder)new DefaultModelRepositoryHolder(request.getSession(), DefaultModelRepositoryHolder.RepositoryMerging.POM_DOMINANT, request.getSession().getRemoteRepositories()));
        }
        if (request.getModelResolver() == null) {
            builder.modelResolver((ModelResolver)new DefaultModelResolver());
        }
        return builder.build();
    }

    protected ModelBuilderResult build(ModelBuilderRequest request, Collection<String> importIds) throws ModelBuilderException {
        DefaultModelBuilderResult result = new DefaultModelBuilderResult();
        DefaultModelProblemCollector problems = new DefaultModelProblemCollector(result);
        Model fileModel = this.readFileModel(request, problems);
        result.setFileModel(fileModel);
        Model activatedFileModel = this.activateFileModel(fileModel, request, result, problems);
        result.setActivatedFileModel(activatedFileModel);
        if (!request.isTwoPhaseBuilding()) {
            return this.build(request, result, importIds);
        }
        if (this.hasModelErrors(problems)) {
            throw problems.newModelBuilderException();
        }
        return result;
    }

    private Model activateFileModel(Model inputModel, ModelBuilderRequest request, DefaultModelBuilderResult result, DefaultModelProblemCollector problems) throws ModelBuilderException {
        problems.setRootModel(inputModel);
        DefaultProfileActivationContext profileActivationContext = this.getProfileActivationContext(request, inputModel);
        problems.setSource("(external profiles)");
        List<Profile> activeExternalProfiles = this.profileSelector.getActiveProfiles(request.getProfiles(), profileActivationContext, problems);
        result.setActiveExternalProfiles(activeExternalProfiles);
        if (!activeExternalProfiles.isEmpty()) {
            Properties profileProps = new Properties();
            for (Profile profile : activeExternalProfiles) {
                profileProps.putAll((Map<?, ?>)profile.getProperties());
            }
            profileProps.putAll(profileActivationContext.getUserProperties());
            profileActivationContext.setUserProperties(profileProps);
        }
        profileActivationContext.setProjectProperties(inputModel.getProperties());
        problems.setSource(inputModel);
        List<Profile> activePomProfiles = this.profileSelector.getActiveProfiles(inputModel.getProfiles(), profileActivationContext, problems);
        problems.setSource(inputModel);
        inputModel = this.modelNormalizer.mergeDuplicates(inputModel, request, problems);
        Map<String, Activation> interpolatedActivations = this.getProfileActivations(inputModel);
        inputModel = this.injectProfileActivations(inputModel, interpolatedActivations);
        inputModel = this.profileInjector.injectProfiles(inputModel, activePomProfiles, request, problems);
        inputModel = this.profileInjector.injectProfiles(inputModel, activeExternalProfiles, request, problems);
        return inputModel;
    }

    private Model readEffectiveModel(ModelBuilderRequest request, DefaultModelBuilderResult result, DefaultModelProblemCollector problems) throws ModelBuilderException {
        String superModelVersion;
        Model inputModel = this.readRawModel(request, problems);
        if (problems.hasFatalErrors()) {
            throw problems.newModelBuilderException();
        }
        inputModel = this.activateFileModel(inputModel, request, result, problems);
        problems.setRootModel(inputModel);
        ModelData resultData = new ModelData(request.getSource(), inputModel);
        String string = superModelVersion = inputModel.getModelVersion() != null ? inputModel.getModelVersion() : "4.0.0";
        if (!VALID_MODEL_VERSIONS.contains(superModelVersion)) {
            superModelVersion = "4.0.0";
        }
        ModelData superData = new ModelData(null, this.getSuperModel(superModelVersion));
        DefaultProfileActivationContext profileActivationContext = this.getProfileActivationContext(request, inputModel);
        List<Profile> activeExternalProfiles = result.getActiveExternalProfiles();
        if (!activeExternalProfiles.isEmpty()) {
            Properties profileProps = new Properties();
            for (Profile profile : activeExternalProfiles) {
                profileProps.putAll((Map<?, ?>)profile.getProperties());
            }
            profileProps.putAll(profileActivationContext.getUserProperties());
            profileActivationContext.setUserProperties(profileProps);
        }
        LinkedHashSet<String> parentIds = new LinkedHashSet<String>();
        ArrayList<Model> lineage = new ArrayList<Model>();
        ModelData currentData = resultData;
        while (true) {
            ModelData parentData;
            String modelId = currentData.id();
            result.addModelId(modelId);
            Model model = currentData.model();
            result.setRawModel(modelId, model);
            problems.setSource(model);
            model = this.modelNormalizer.mergeDuplicates(model, request, problems);
            profileActivationContext.setProjectProperties(model.getProperties());
            List<Profile> interpolatedProfiles = this.interpolateActivations(model.getProfiles(), profileActivationContext, problems);
            List<Profile> activePomProfiles = this.profileSelector.getActiveProfiles(interpolatedProfiles, profileActivationContext, problems);
            result.setActivePomProfiles(modelId, activePomProfiles);
            model = this.profileInjector.injectProfiles(model, activePomProfiles, request, problems);
            if (currentData == resultData) {
                model = this.profileInjector.injectProfiles(model, activeExternalProfiles, request, problems);
            }
            lineage.add(model);
            if (currentData == superData) break;
            if (!model.getRepositories().isEmpty()) {
                List<String> oldRepos = request.getModelRepositoryHolder().getRepositories().stream().map(Object::toString).toList();
                request.getModelRepositoryHolder().merge(model.getRepositories(), false);
                List<String> newRepos = request.getModelRepositoryHolder().getRepositories().stream().map(Object::toString).toList();
                if (!Objects.equals(oldRepos, newRepos)) {
                    this.logger.debug("Merging repositories from " + model.getId() + "\n" + newRepos.stream().map(s -> "    " + s).collect(Collectors.joining("\n")));
                }
            }
            if ((parentData = this.readParent(model, currentData.source(), request, problems)) == null) {
                currentData = superData;
                continue;
            }
            if (!parentIds.add(parentData.id())) {
                StringBuilder message = new StringBuilder("The parents form a cycle: ");
                for (String parentId : parentIds) {
                    message.append(parentId).append(" -> ");
                }
                message.append(parentData.id());
                problems.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, message.toString());
                throw problems.newModelBuilderException();
            }
            currentData = parentData;
        }
        Model tmpModel = (Model)lineage.get(0);
        List<Profile> interpolated = this.interpolateActivations(tmpModel.getProfiles(), profileActivationContext, problems);
        if (interpolated != tmpModel.getProfiles()) {
            tmpModel = tmpModel.withProfiles(interpolated);
        }
        tmpModel = this.profileInjector.injectProfiles(tmpModel, activeExternalProfiles, request, problems);
        lineage.set(0, tmpModel);
        this.checkPluginVersions(lineage, request, problems);
        Model resultModel = this.assembleInheritance(lineage, request, problems);
        problems.setSource(resultModel);
        problems.setRootModel(resultModel);
        resultModel = this.interpolateModel(resultModel, request, problems);
        resultModel = this.modelUrlNormalizer.normalize(resultModel, request);
        result.setEffectiveModel(resultModel);
        if (!resultModel.getRepositories().isEmpty()) {
            List<String> oldRepos = request.getModelRepositoryHolder().getRepositories().stream().map(Object::toString).toList();
            request.getModelRepositoryHolder().merge(resultModel.getRepositories(), true);
            List<String> newRepos = request.getModelRepositoryHolder().getRepositories().stream().map(Object::toString).toList();
            if (!Objects.equals(oldRepos, newRepos)) {
                this.logger.debug("Replacing repositories from " + resultModel.getId() + "\n" + newRepos.stream().map(s -> "    " + s).collect(Collectors.joining("\n")));
            }
        }
        return resultModel;
    }

    private List<Profile> interpolateActivations(List<Profile> profiles, DefaultProfileActivationContext context, DefaultModelProblemCollector problems) {
        if (profiles.stream().map(Profile::getActivation).noneMatch(Objects::nonNull)) {
            return profiles;
        }
        RegexBasedInterpolator xform = new RegexBasedInterpolator();
        xform.setCacheAnswers(true);
        Stream.of(context.getUserProperties(), context.getSystemProperties()).map(MapBasedValueSource::new).forEach(arg_0 -> ((Interpolator)xform).addValueSource(arg_0));
        class ProfileInterpolator
        extends MavenTransformer
        implements UnaryOperator<Profile> {
            final /* synthetic */ Interpolator val$xform;
            final /* synthetic */ DefaultModelProblemCollector val$problems;
            final /* synthetic */ DefaultProfileActivationContext val$context;

            ProfileInterpolator() {
                this.val$xform = interpolator;
                this.val$problems = defaultModelProblemCollector;
                this.val$context = defaultProfileActivationContext;
                super(s -> {
                    if (DefaultModelBuilder.isNotEmpty(s)) {
                        try {
                            return interpolator.interpolate(s);
                        }
                        catch (InterpolationException e) {
                            defaultModelProblemCollector.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, e.getMessage(), (Exception)((Object)e));
                        }
                    }
                    return s;
                });
            }

            @Override
            public Profile apply(Profile p) {
                return Profile.newBuilder((Profile)p).activation(this.transformActivation(p.getActivation())).build();
            }

            @Override
            protected ActivationFile.Builder transformActivationFile_Missing(Supplier<? extends ActivationFile.Builder> creator, ActivationFile.Builder builder, ActivationFile target) {
                String path = target.getMissing();
                String xformed = this.transformPath(path, target, "missing");
                return xformed != path ? (builder != null ? builder : creator.get()).missing(xformed) : builder;
            }

            @Override
            protected ActivationFile.Builder transformActivationFile_Exists(Supplier<? extends ActivationFile.Builder> creator, ActivationFile.Builder builder, ActivationFile target) {
                String path = target.getExists();
                String xformed = this.transformPath(path, target, "exists");
                return xformed != path ? (builder != null ? builder : creator.get()).exists(xformed) : builder;
            }

            private String transformPath(String path, ActivationFile target, String locationKey) {
                if (DefaultModelBuilder.isNotEmpty(path)) {
                    try {
                        return DefaultModelBuilder.this.profileActivationFilePathInterpolator.interpolate(path, this.val$context);
                    }
                    catch (InterpolationException e) {
                        DefaultModelBuilder.addInterpolationProblem(this.val$problems, (InputLocationTracker)target, path, e, locationKey);
                    }
                }
                return path;
            }
        }
        return profiles.stream().map(new ProfileInterpolator()).toList();
    }

    private static void addInterpolationProblem(DefaultModelProblemCollector problems, InputLocationTracker target, String path, InterpolationException e, String locationKey) {
        problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Failed to interpolate file location " + path + ": " + e.getMessage(), target.getLocation((Object)locationKey), (Exception)((Object)e));
    }

    private static boolean isNotEmpty(String string) {
        return string != null && !string.isEmpty();
    }

    public ModelBuilderResult build(ModelBuilderRequest request, ModelBuilderResult result) throws ModelBuilderException {
        return this.build(request, result, new LinkedHashSet<String>());
    }

    public Model buildRawModel(ModelBuilderRequest request) throws ModelBuilderException {
        request = DefaultModelBuilder.fillRequestDefaults(request);
        DefaultModelProblemCollector problems = new DefaultModelProblemCollector(new DefaultModelBuilderResult());
        Model model = this.readRawModel(request, problems);
        if (this.hasModelErrors(problems)) {
            throw problems.newModelBuilderException();
        }
        return model;
    }

    private ModelBuilderResult build(ModelBuilderRequest request, ModelBuilderResult phaseOneResult, Collection<String> importIds) throws ModelBuilderException {
        DefaultModelBuilderResult result = this.asDefaultModelBuilderResult(phaseOneResult);
        DefaultModelProblemCollector problems = new DefaultModelProblemCollector(result);
        Model resultModel = this.readEffectiveModel(request, result, problems);
        problems.setSource(resultModel);
        problems.setRootModel(resultModel);
        resultModel = this.modelPathTranslator.alignToBaseDirectory(resultModel, resultModel.getProjectDirectory(), request);
        resultModel = this.pluginManagementInjector.injectManagement(resultModel, request, problems);
        resultModel = this.fireEvent(resultModel, request, problems, ModelBuildingListener::buildExtensionsAssembled);
        if (request.isProcessPlugins()) {
            if (this.lifecycleBindingsInjector == null) {
                throw new IllegalStateException("lifecycle bindings injector is missing");
            }
            resultModel = this.lifecycleBindingsInjector.injectLifecycleBindings(resultModel, request, problems);
        }
        resultModel = this.importDependencyManagement(resultModel, request, problems, importIds);
        resultModel = this.dependencyManagementInjector.injectManagement(resultModel, request, problems);
        resultModel = this.modelNormalizer.injectDefaultValues(resultModel, request, problems);
        if (request.isProcessPlugins()) {
            resultModel = this.pluginConfigurationExpander.expandPluginConfiguration(resultModel, request, problems);
        }
        result.setEffectiveModel(resultModel);
        this.modelValidator.validateEffectiveModel(resultModel, request, problems);
        if (this.hasModelErrors(problems)) {
            throw problems.newModelBuilderException();
        }
        return result;
    }

    private DefaultModelBuilderResult asDefaultModelBuilderResult(ModelBuilderResult phaseOneResult) {
        if (phaseOneResult instanceof DefaultModelBuilderResult) {
            return (DefaultModelBuilderResult)phaseOneResult;
        }
        return new DefaultModelBuilderResult(phaseOneResult);
    }

    public Result<? extends Model> buildRawModel(Path pomFile, int validationLevel, boolean locationTracking) {
        return this.buildRawModel(pomFile, validationLevel, locationTracking, null);
    }

    public Result<? extends Model> buildRawModel(Path pomFile, int validationLevel, boolean locationTracking, ModelTransformerContext context) {
        ModelBuilderRequest request = ModelBuilderRequest.builder().validationLevel(validationLevel).locationTracking(locationTracking).source(ModelSource.fromPath((Path)pomFile)).build();
        DefaultModelProblemCollector problems = new DefaultModelProblemCollector(new DefaultModelBuilderResult());
        try {
            Model model = this.readFileModel(request, problems);
            try {
                if (this.transformer != null && context != null) {
                    this.transformer.transform(context, model, pomFile);
                }
            }
            catch (ModelBuilderException e) {
                problems.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.V40, null, (Exception)((Object)e));
            }
            return Result.newResult(model, problems.getProblems());
        }
        catch (ModelBuilderException e) {
            return Result.error(problems.getProblems());
        }
    }

    Model readFileModel(ModelBuilderRequest request, DefaultModelProblemCollector problems) throws ModelBuilderException {
        ModelTransformerContextBuilder modelTransformerContextBuilder;
        ModelSource modelSource = request.getSource();
        Model model = DefaultModelBuilder.cache(DefaultModelBuilder.getModelCache(request), (Source)modelSource, FILE, () -> this.doReadFileModel(modelSource, request, problems));
        if (modelSource.getPath() != null && (modelTransformerContextBuilder = DefaultModelBuilder.getTransformerContextBuilder(request)) instanceof DefaultModelTransformerContextBuilder) {
            DefaultModelTransformerContextBuilder contextBuilder = (DefaultModelTransformerContextBuilder)modelTransformerContextBuilder;
            contextBuilder.putSource(DefaultModelBuilder.getGroupId(model), model.getArtifactId(), modelSource);
        }
        return model;
    }

    private Model doReadFileModel(ModelSource modelSource, ModelBuilderRequest request, DefaultModelProblemCollector problems) throws ModelBuilderException {
        Model model;
        block27: {
            problems.setSource(modelSource.getLocation());
            try {
                InputSource v4src;
                boolean strict = request.getValidationLevel() >= 20;
                try (InputStream is = modelSource.openStream();){
                    model = this.modelProcessor.read(XmlReaderRequest.builder().strict(strict).location(modelSource.getLocation()).path(modelSource.getPath()).inputStream(is).build());
                }
                catch (XmlReaderException e) {
                    if (!strict) {
                        throw e;
                    }
                    try (InputStream is2 = modelSource.openStream();){
                        model = this.modelProcessor.read(XmlReaderRequest.builder().strict(false).location(modelSource.getLocation()).path(modelSource.getPath()).inputStream(is2).build());
                    }
                    catch (XmlReaderException ne) {
                        throw e;
                    }
                    BuilderProblem.Severity severity = request.isProjectBuild() ? BuilderProblem.Severity.ERROR : BuilderProblem.Severity.WARNING;
                    problems.add(severity, ModelProblem.Version.V20, "Malformed POM " + modelSource.getLocation() + ": " + e.getMessage(), (Exception)((Object)e));
                }
                InputLocation loc = model.getLocation((Object)"");
                InputSource inputSource = v4src = loc != null ? loc.getSource() : null;
                if (v4src == null) break block27;
                try {
                    Field field = InputSource.class.getDeclaredField("modelId");
                    field.setAccessible(true);
                    field.set(v4src, ModelProblemUtils.toId(model));
                }
                catch (Throwable t) {
                    throw new IllegalStateException("Unable to set modelId on InputSource", t);
                }
            }
            catch (XmlReaderException e) {
                problems.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, "Non-parseable POM " + modelSource.getLocation() + ": " + e.getMessage(), (Exception)((Object)e));
                throw problems.newModelBuilderException();
            }
            catch (IOException e) {
                String msg = e.getMessage();
                if (msg == null || msg.isEmpty()) {
                    msg = e.getClass().getName().endsWith("MalformedInputException") ? "Some input bytes do not match the file encoding." : e.getClass().getSimpleName();
                }
                problems.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, "Non-readable POM " + modelSource.getLocation() + ": " + msg, e);
                throw problems.newModelBuilderException();
            }
        }
        if (modelSource.getPath() != null) {
            model = model.withPomFile(modelSource.getPath());
        }
        problems.setSource(model);
        this.modelValidator.validateFileModel(model, request, problems);
        if (this.hasFatalErrors(problems)) {
            throw problems.newModelBuilderException();
        }
        return model;
    }

    Model readRawModel(ModelBuilderRequest request, DefaultModelProblemCollector problems) throws ModelBuilderException {
        ModelSource modelSource = request.getSource();
        ModelData modelData = DefaultModelBuilder.cache(DefaultModelBuilder.getModelCache(request), (Source)modelSource, RAW, () -> this.doReadRawModel(modelSource, request, problems));
        return modelData.model();
    }

    private ModelData doReadRawModel(ModelSource modelSource, ModelBuilderRequest request, DefaultModelProblemCollector problems) throws ModelBuilderException {
        Model rawModel = this.readFileModel(request, problems);
        if (Features.buildConsumer((Map)request.getUserProperties()) && modelSource.getPath() != null) {
            Path pomFile = modelSource.getPath();
            try {
                ModelTransformerContextBuilder transformerContextBuilder = DefaultModelBuilder.getTransformerContextBuilder(request);
                if (transformerContextBuilder != null) {
                    ModelTransformerContext context = transformerContextBuilder.initialize(request, (ModelProblemCollector)problems);
                    rawModel = this.transformer.transform(context, rawModel, pomFile);
                }
            }
            catch (ModelTransformerException e) {
                problems.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.V40, null, (Exception)((Object)e));
            }
        }
        this.modelValidator.validateRawModel(rawModel, request, problems);
        if (this.hasFatalErrors(problems)) {
            throw problems.newModelBuilderException();
        }
        return new ModelData(modelSource, rawModel);
    }

    static String getGroupId(Model model) {
        String groupId = model.getGroupId();
        if (groupId == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        return groupId;
    }

    private String getVersion(Model model) {
        String version = model.getVersion();
        if (version == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        return version;
    }

    private DefaultProfileActivationContext getProfileActivationContext(ModelBuilderRequest request, Model model) {
        DefaultProfileActivationContext context = new DefaultProfileActivationContext();
        context.setActiveProfileIds(request.getActiveProfileIds());
        context.setInactiveProfileIds(request.getInactiveProfileIds());
        context.setSystemProperties(request.getSystemProperties());
        HashMap<String, String> userProperties = new HashMap<String, String>(request.getUserProperties());
        if (!userProperties.containsKey("packaging")) {
            userProperties.put("packaging", model.getPackaging());
        }
        context.setUserProperties(userProperties);
        context.setProjectDirectory(model.getProjectDirectory());
        return context;
    }

    private void checkPluginVersions(List<Model> lineage, ModelBuilderRequest request, ModelProblemCollector problems) {
        if (request.getValidationLevel() < 20) {
            return;
        }
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
        HashMap<String, String> versions = new HashMap<String, String>();
        HashMap<String, String> managedVersions = new HashMap<String, String>();
        for (int i = lineage.size() - 1; i >= 0; --i) {
            Model model = lineage.get(i);
            Build build = model.getBuild();
            if (build == null) continue;
            for (Plugin plugin : build.getPlugins()) {
                String key = plugin.getKey();
                if (versions.get(key) != null) continue;
                versions.put(key, plugin.getVersion());
                plugins.put(key, plugin);
            }
            PluginManagement mgmt = build.getPluginManagement();
            if (mgmt == null) continue;
            for (Plugin plugin : mgmt.getPlugins()) {
                String key = plugin.getKey();
                managedVersions.computeIfAbsent(key, k -> plugin.getVersion());
            }
        }
        for (String key : versions.keySet()) {
            if (versions.get(key) != null || managedVersions.get(key) != null) continue;
            InputLocation location = ((Plugin)plugins.get(key)).getLocation((Object)"");
            problems.add(BuilderProblem.Severity.WARNING, ModelProblem.Version.V20, "'build.plugins.plugin.version' for " + key + " is missing.", location);
        }
    }

    private Model assembleInheritance(List<Model> lineage, ModelBuilderRequest request, ModelProblemCollector problems) {
        Model parent = lineage.get(lineage.size() - 1);
        for (int i = lineage.size() - 2; i >= 0; --i) {
            Model child = lineage.get(i);
            parent = this.inheritanceAssembler.assembleModelInheritance(child, parent, request, problems);
        }
        return parent;
    }

    private Map<String, Activation> getProfileActivations(Model model) {
        return model.getProfiles().stream().filter(p -> p.getActivation() != null).collect(Collectors.toMap(Profile::getId, Profile::getActivation));
    }

    private Model injectProfileActivations(Model model, Map<String, Activation> activations) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        boolean modified = false;
        for (Profile profile : model.getProfiles()) {
            Activation activation = profile.getActivation();
            if (activation != null) {
                profile = profile.withActivation(activations.get(profile.getId()));
                modified = true;
            }
            profiles.add(profile);
        }
        return modified ? model.withProfiles(profiles) : model;
    }

    private Model interpolateModel(Model model, ModelBuilderRequest request, ModelProblemCollector problems) {
        Model interpolatedModel = this.modelInterpolator.interpolateModel(model, model.getProjectDirectory(), request, problems);
        if (interpolatedModel.getParent() != null) {
            StringSearchInterpolator ssi = new StringSearchInterpolator();
            ssi.addValueSource((ValueSource)new MapBasedValueSource(request.getSession().getUserProperties()));
            ssi.addValueSource((ValueSource)new MapBasedValueSource(model.getProperties()));
            ssi.addValueSource((ValueSource)new MapBasedValueSource(request.getSession().getSystemProperties()));
            try {
                String interpolated = ssi.interpolate(interpolatedModel.getParent().getVersion());
                interpolatedModel = interpolatedModel.withParent(interpolatedModel.getParent().withVersion(interpolated));
            }
            catch (Exception e) {
                problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Failed to interpolate field: " + interpolatedModel.getParent().getVersion() + " on class: ", e);
            }
        }
        interpolatedModel = interpolatedModel.withPomFile(model.getPomFile());
        return interpolatedModel;
    }

    private ModelData readParent(Model childModel, ModelSource childSource, ModelBuilderRequest request, DefaultModelProblemCollector problems) throws ModelBuilderException {
        ModelData parentData = null;
        Parent parent = childModel.getParent();
        if (parent != null) {
            Model parentModel;
            parentData = this.readParentLocally(childModel, childSource, request, problems);
            if (parentData == null) {
                parentData = this.readParentExternally(childModel, request, problems);
            }
            if (!"pom".equals((parentModel = parentData.model()).getPackaging())) {
                problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Invalid packaging for parent POM " + ModelProblemUtils.toSourceHint(parentModel) + ", must be \"pom\" but is \"" + parentModel.getPackaging() + "\"", parentModel.getLocation((Object)"packaging"));
            }
        }
        return parentData;
    }

    private ModelData readParentLocally(Model childModel, ModelSource childSource, ModelBuilderRequest request, DefaultModelProblemCollector problems) throws ModelBuilderException {
        Model candidateModel;
        ModelSource candidateSource;
        Parent parent = childModel.getParent();
        WorkspaceModelResolver resolver = DefaultModelBuilder.getWorkspaceModelResolver(request);
        if (resolver == null) {
            candidateSource = this.getParentPomFile(childModel, childSource);
            if (candidateSource == null) {
                return null;
            }
            ModelBuilderRequest candidateBuildRequest = ModelBuilderRequest.build((ModelBuilderRequest)request, (ModelSource)candidateSource);
            candidateModel = this.readRawModel(candidateBuildRequest, problems);
        } else {
            try {
                candidateModel = resolver.resolveRawModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            }
            catch (ModelBuilderException e) {
                problems.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, e.getMessage(), parent.getLocation((Object)""), (Exception)((Object)e));
                throw problems.newModelBuilderException();
            }
            if (candidateModel == null) {
                return null;
            }
            candidateSource = ModelSource.fromPath((Path)candidateModel.getPomFile());
        }
        String groupId = DefaultModelBuilder.getGroupId(candidateModel);
        String artifactId = candidateModel.getArtifactId();
        if (groupId == null || !groupId.equals(parent.getGroupId()) || artifactId == null || !artifactId.equals(parent.getArtifactId())) {
            StringBuilder buffer = new StringBuilder(256);
            buffer.append("'parent.relativePath'");
            if (childModel != problems.getRootModel()) {
                buffer.append(" of POM ").append(ModelProblemUtils.toSourceHint(childModel));
            }
            buffer.append(" points at ").append(groupId).append(':').append(artifactId);
            buffer.append(" instead of ").append(parent.getGroupId()).append(':');
            buffer.append(parent.getArtifactId()).append(", please verify your project structure");
            problems.setSource(childModel);
            problems.add(BuilderProblem.Severity.WARNING, ModelProblem.Version.BASE, buffer.toString(), parent.getLocation((Object)""));
            return null;
        }
        String version = this.getVersion(candidateModel);
        if (version != null && parent.getVersion() != null && !version.equals(parent.getVersion())) {
            try {
                VersionRange parentRange = this.versionParser.parseVersionRange(parent.getVersion());
                if (!parentRange.contains(this.versionParser.parseVersion(version))) {
                    return null;
                }
                String rawChildModelVersion = childModel.getVersion();
                if (rawChildModelVersion == null) {
                    problems.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.V31, "Version must be a constant", childModel.getLocation((Object)""));
                } else if (this.rawChildVersionReferencesParent(rawChildModelVersion)) {
                    problems.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.V31, "Version must be a constant", childModel.getLocation((Object)"version"));
                }
            }
            catch (VersionParserException e) {
                return null;
            }
        }
        return new ModelData(candidateSource, candidateModel);
    }

    private boolean rawChildVersionReferencesParent(String rawChildModelVersion) {
        return rawChildModelVersion.equals("${pom.version}") || rawChildModelVersion.equals("${project.version}") || rawChildModelVersion.equals("${pom.parent.version}") || rawChildModelVersion.equals("${project.parent.version}");
    }

    private ModelSource getParentPomFile(Model childModel, ModelSource source) {
        String parentPath = childModel.getParent().getRelativePath();
        if (parentPath == null || parentPath.isEmpty()) {
            return null;
        }
        return source.resolve(this.modelProcessor::locateExistingPom, parentPath);
    }

    private ModelData readParentExternally(Model childModel, ModelBuilderRequest request, DefaultModelProblemCollector problems) throws ModelBuilderException {
        ModelSource modelSource;
        problems.setSource(childModel);
        Parent parent = childModel.getParent();
        String groupId = parent.getGroupId();
        String artifactId = parent.getArtifactId();
        String version = parent.getVersion();
        ModelResolver modelResolver = DefaultModelBuilder.getModelResolver(request);
        Objects.requireNonNull(modelResolver, String.format("request.modelResolver cannot be null (parent POM %s and POM %s)", ModelProblemUtils.toId(groupId, artifactId, version), ModelProblemUtils.toSourceHint(childModel)));
        try {
            AtomicReference modified = new AtomicReference();
            Session session = request.getSession().withRemoteRepositories(request.getModelRepositoryHolder().getRepositories());
            modelSource = modelResolver.resolveModel(session, parent, modified);
            if (modified.get() != null) {
                parent = (Parent)modified.get();
            }
        }
        catch (ModelResolverException e) {
            StringBuilder buffer = new StringBuilder(256);
            buffer.append("Non-resolvable parent POM");
            if (!this.containsCoordinates(e.getMessage(), groupId, artifactId, version)) {
                buffer.append(' ').append(ModelProblemUtils.toId(groupId, artifactId, version));
            }
            if (childModel != problems.getRootModel()) {
                buffer.append(" for ").append(ModelProblemUtils.toId(childModel));
            }
            buffer.append(": ").append(e.getMessage());
            if (childModel.getProjectDirectory() != null) {
                if (parent.getRelativePath() == null || parent.getRelativePath().isEmpty()) {
                    buffer.append(" and 'parent.relativePath' points at no local POM");
                } else {
                    buffer.append(" and 'parent.relativePath' points at wrong local POM");
                }
            }
            problems.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, buffer.toString(), parent.getLocation((Object)""), (Exception)((Object)e));
            throw problems.newModelBuilderException();
        }
        int validationLevel = Math.min(request.getValidationLevel(), 20);
        ModelBuilderRequest lenientRequest = ModelBuilderRequest.builder((ModelBuilderRequest)request).validationLevel(validationLevel).projectBuild(false).source(modelSource).build();
        Model parentModel = this.readRawModel(lenientRequest, problems);
        if (!parent.getVersion().equals(version)) {
            String rawChildModelVersion = childModel.getVersion();
            if (rawChildModelVersion == null) {
                problems.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.V31, "Version must be a constant", childModel.getLocation((Object)""));
            } else if (this.rawChildVersionReferencesParent(rawChildModelVersion)) {
                problems.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.V31, "Version must be a constant", childModel.getLocation((Object)"version"));
            }
        }
        return new ModelData(modelSource, parentModel);
    }

    private Model getSuperModel(String modelVersion) {
        return this.superPomProvider.getSuperPom(modelVersion);
    }

    private Model importDependencyManagement(Model model, ModelBuilderRequest request, DefaultModelProblemCollector problems, Collection<String> importIds) {
        DependencyManagement depMgmt = model.getDependencyManagement();
        if (depMgmt == null) {
            return model;
        }
        String importing = model.getGroupId() + ":" + model.getArtifactId() + ":" + model.getVersion();
        importIds.add(importing);
        ArrayList<DependencyManagement> importMgmts = null;
        ArrayList deps = new ArrayList(depMgmt.getDependencies());
        Iterator it = deps.iterator();
        while (it.hasNext()) {
            Dependency dependency = (Dependency)it.next();
            if (!"pom".equals(dependency.getType()) || !IMPORT.equals(dependency.getScope()) || "bom".equals(dependency.getType())) continue;
            it.remove();
            DependencyManagement importMgmt = this.loadDependencyManagement(model, request, problems, dependency, importIds);
            if (importMgmt == null) continue;
            if (importMgmts == null) {
                importMgmts = new ArrayList<DependencyManagement>();
            }
            importMgmts.add(importMgmt);
        }
        importIds.remove(importing);
        model = model.withDependencyManagement(model.getDependencyManagement().withDependencies(deps));
        return this.dependencyManagementImporter.importManagement(model, importMgmts, request, problems);
    }

    private DependencyManagement loadDependencyManagement(Model model, ModelBuilderRequest request, DefaultModelProblemCollector problems, Dependency dependency, Collection<String> importIds) {
        DependencyManagement importMgmt;
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        String version = dependency.getVersion();
        if (groupId == null || groupId.isEmpty()) {
            problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "'dependencyManagement.dependencies.dependency.groupId' for " + dependency.getManagementKey() + " is missing.", dependency.getLocation((Object)""));
            return null;
        }
        if (artifactId == null || artifactId.isEmpty()) {
            problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "'dependencyManagement.dependencies.dependency.artifactId' for " + dependency.getManagementKey() + " is missing.", dependency.getLocation((Object)""));
            return null;
        }
        if (version == null || version.isEmpty()) {
            problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "'dependencyManagement.dependencies.dependency.version' for " + dependency.getManagementKey() + " is missing.", dependency.getLocation((Object)""));
            return null;
        }
        String imported = groupId + ":" + artifactId + ":" + version;
        if (importIds.contains(imported)) {
            StringBuilder message = new StringBuilder("The dependencies of type=pom and with scope=import form a cycle: ");
            for (String modelId : importIds) {
                message.append(modelId).append(" -> ");
            }
            message.append(imported);
            problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, message.toString());
            return null;
        }
        Model importModel = DefaultModelBuilder.cache(DefaultModelBuilder.getModelCache(request), groupId, artifactId, version, IMPORT, () -> this.doLoadDependencyManagement(model, request, problems, dependency, groupId, artifactId, version, importIds));
        DependencyManagement dependencyManagement = importMgmt = importModel != null ? importModel.getDependencyManagement() : null;
        if (importMgmt == null) {
            importMgmt = DependencyManagement.newInstance();
        }
        List exclusions = dependency.getExclusions();
        if (importMgmt != null && !exclusions.isEmpty()) {
            List dependencies = importMgmt.getDependencies().stream().filter(candidate -> exclusions.stream().noneMatch(exclusion -> this.match((Exclusion)exclusion, (Dependency)candidate))).map(candidate -> candidate.withExclusions((Collection)exclusions)).collect(Collectors.toList());
            importMgmt = importMgmt.withDependencies(dependencies);
        }
        return importMgmt;
    }

    private boolean match(Exclusion exclusion, Dependency candidate) {
        return this.match(exclusion.getGroupId(), candidate.getGroupId()) && this.match(exclusion.getArtifactId(), candidate.getArtifactId());
    }

    private boolean match(String match, String text) {
        return match.equals("*") || match.equals(text);
    }

    private Model doLoadDependencyManagement(Model model, ModelBuilderRequest request, DefaultModelProblemCollector problems, Dependency dependency, String groupId, String artifactId, String version, Collection<String> importIds) {
        WorkspaceModelResolver workspaceResolver = DefaultModelBuilder.getWorkspaceModelResolver(request);
        ModelResolver modelResolver = DefaultModelBuilder.getModelResolver(request);
        if (workspaceResolver == null && modelResolver == null) {
            throw new NullPointerException(String.format("request.workspaceModelResolver and request.modelResolver cannot be null (parent POM %s and POM %s)", ModelProblemUtils.toId(groupId, artifactId, version), ModelProblemUtils.toSourceHint(model)));
        }
        Model importModel = null;
        if (workspaceResolver != null) {
            try {
                importModel = workspaceResolver.resolveEffectiveModel(groupId, artifactId, version);
            }
            catch (ModelBuilderException e) {
                problems.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, null, (Exception)((Object)e));
                return null;
            }
        }
        if (importModel == null) {
            ModelBuilderResult importResult;
            Path sourcePath;
            Path rootDirectory;
            ModelSource importSource;
            try {
                Session session = request.getSession().withRemoteRepositories(request.getModelRepositoryHolder().getRepositories());
                importSource = modelResolver.resolveModel(session, dependency, new AtomicReference());
            }
            catch (ModelBuilderException e) {
                StringBuilder buffer = new StringBuilder(256);
                buffer.append("Non-resolvable import POM");
                if (!this.containsCoordinates(e.getMessage(), groupId, artifactId, version)) {
                    buffer.append(' ').append(ModelProblemUtils.toId(groupId, artifactId, version));
                }
                buffer.append(": ").append(e.getMessage());
                problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, buffer.toString(), dependency.getLocation((Object)""), (Exception)((Object)e));
                return null;
            }
            try {
                rootDirectory = request.getSession().getRootDirectory();
            }
            catch (IllegalStateException e) {
                rootDirectory = null;
            }
            if (importSource.getPath() != null && rootDirectory != null && (sourcePath = importSource.getPath()).startsWith(rootDirectory)) {
                problems.add(BuilderProblem.Severity.WARNING, ModelProblem.Version.BASE, "BOM imports from within reactor should be avoided", dependency.getLocation((Object)""));
            }
            try {
                ModelBuilderRequest importRequest = ModelBuilderRequest.builder().session(request.getSession().withRemoteRepositories(request.getModelRepositoryHolder().getRepositories())).validationLevel(0).systemProperties(request.getSystemProperties()).userProperties(request.getUserProperties()).source(importSource).modelResolver(modelResolver).modelCache(request.getModelCache()).modelRepositoryHolder(request.getModelRepositoryHolder().copy()).twoPhaseBuilding(false).build();
                importResult = this.build(importRequest, importIds);
            }
            catch (ModelBuilderException e) {
                e.getResult().getProblems().forEach(problems::add);
                return null;
            }
            importResult.getProblems().forEach(problems::add);
            importModel = importResult.getEffectiveModel();
        }
        return importModel;
    }

    private static <T> T cache(ModelCache cache, String groupId, String artifactId, String version, String tag, Callable<T> supplier) {
        Supplier<T> s = DefaultModelBuilder.asSupplier(supplier);
        if (cache == null) {
            return s.get();
        }
        return (T)cache.computeIfAbsent(groupId, artifactId, version, tag, s);
    }

    private static <T> T cache(ModelCache cache, Source source, String tag, Callable<T> supplier) {
        Supplier<T> s = DefaultModelBuilder.asSupplier(supplier);
        if (cache == null) {
            return s.get();
        }
        return (T)cache.computeIfAbsent(source, tag, s);
    }

    private static <T> Supplier<T> asSupplier(Callable<T> supplier) {
        return () -> {
            try {
                return supplier.call();
            }
            catch (Exception e) {
                DefaultModelBuilder.uncheckedThrow(e);
                return null;
            }
        };
    }

    static <T extends Throwable> void uncheckedThrow(Throwable t) throws T {
        throw t;
    }

    private Model fireEvent(Model model, ModelBuilderRequest request, ModelProblemCollector problems, BiConsumer<ModelBuildingListener, ModelBuildingEvent> catapult) {
        ModelBuildingListener listener = DefaultModelBuilder.getModelBuildingListener(request);
        if (listener != null) {
            AtomicReference<Model> m = new AtomicReference<Model>(model);
            DefaultModelBuildingEvent event = new DefaultModelBuildingEvent(model, m::set, request, problems);
            catapult.accept(listener, event);
            return m.get();
        }
        return model;
    }

    private boolean containsCoordinates(String message, String groupId, String artifactId, String version) {
        return !(message == null || groupId != null && !message.contains(groupId) || artifactId != null && !message.contains(artifactId) || version != null && !message.contains(version));
    }

    protected boolean hasModelErrors(ModelProblemCollector problems) {
        return problems.hasErrors();
    }

    protected boolean hasFatalErrors(ModelProblemCollector problems) {
        return problems.hasFatalErrors();
    }

    ModelProcessor getModelProcessor() {
        return this.modelProcessor;
    }

    private static ModelCache getModelCache(ModelBuilderRequest request) {
        return request.getModelCache();
    }

    private static ModelBuildingListener getModelBuildingListener(ModelBuilderRequest request) {
        return (ModelBuildingListener)request.getListener();
    }

    private static WorkspaceModelResolver getWorkspaceModelResolver(ModelBuilderRequest request) {
        return null;
    }

    private static ModelResolver getModelResolver(ModelBuilderRequest request) {
        return request.getModelResolver();
    }

    private static ModelTransformerContextBuilder getTransformerContextBuilder(ModelBuilderRequest request) {
        return request.getTransformerContextBuilder();
    }
}

