/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.internal.impl.resolver.RemoteSnapshotMetadata;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.impl.MetadataGenerator;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.util.ConfigUtils;

class RemoteSnapshotMetadataGenerator
implements MetadataGenerator {
    private final Map<Object, RemoteSnapshotMetadata> snapshots;
    private final Date timestamp;
    private final Integer buildNumber;

    RemoteSnapshotMetadataGenerator(RepositorySystemSession session, DeployRequest request) {
        this.timestamp = (Date)ConfigUtils.getObject((RepositorySystemSession)session, (Object)new Date(), (String[])new String[]{"maven.startTime"});
        Object bn = ConfigUtils.getObject((RepositorySystemSession)session, null, (String[])new String[]{"maven.buildNumber"});
        this.buildNumber = bn instanceof Integer ? (Integer)bn : (bn instanceof String ? Integer.valueOf((String)bn) : null);
        this.snapshots = new LinkedHashMap<Object, RemoteSnapshotMetadata>();
        for (Metadata metadata : request.getMetadata()) {
            if (!(metadata instanceof RemoteSnapshotMetadata)) continue;
            RemoteSnapshotMetadata snapshotMetadata = (RemoteSnapshotMetadata)metadata;
            this.snapshots.put(snapshotMetadata.getKey(), snapshotMetadata);
        }
    }

    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (!artifact.isSnapshot()) continue;
            Object key = RemoteSnapshotMetadata.getKey(artifact);
            RemoteSnapshotMetadata snapshotMetadata = this.snapshots.get(key);
            if (snapshotMetadata == null) {
                snapshotMetadata = new RemoteSnapshotMetadata(artifact, this.timestamp, this.buildNumber);
                this.snapshots.put(key, snapshotMetadata);
            }
            snapshotMetadata.bind(artifact);
        }
        return this.snapshots.values();
    }

    public Artifact transformArtifact(Artifact artifact) {
        Object key;
        RemoteSnapshotMetadata snapshotMetadata;
        if (artifact.isSnapshot() && artifact.getVersion().equals(artifact.getBaseVersion()) && (snapshotMetadata = this.snapshots.get(key = RemoteSnapshotMetadata.getKey(artifact))) != null) {
            artifact = artifact.setVersion(snapshotMetadata.getExpandedVersion(artifact));
        }
        return artifact;
    }

    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        return Collections.emptyList();
    }
}

