/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.resolver;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.api.metadata.Metadata;
import org.apache.maven.api.metadata.Versioning;
import org.apache.maven.internal.impl.resolver.MavenMetadata;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;

final class VersionsMetadata
extends MavenMetadata {
    private final Artifact artifact;

    VersionsMetadata(Artifact artifact, Date timestamp) {
        super(VersionsMetadata.createRepositoryMetadata(artifact), (Path)null, timestamp);
        this.artifact = artifact;
    }

    VersionsMetadata(Artifact artifact, Path path, Date timestamp) {
        super(VersionsMetadata.createRepositoryMetadata(artifact), path, timestamp);
        this.artifact = artifact;
    }

    private static Metadata createRepositoryMetadata(Artifact artifact) {
        Metadata.Builder metadata = Metadata.newBuilder();
        metadata.groupId(artifact.getGroupId());
        metadata.artifactId(artifact.getArtifactId());
        Versioning.Builder versioning = Versioning.newBuilder();
        versioning.versions(List.of(artifact.getBaseVersion()));
        if (!artifact.isSnapshot()) {
            versioning.release(artifact.getBaseVersion());
        }
        if ("maven-plugin".equals(artifact.getProperty("type", ""))) {
            versioning.latest(artifact.getBaseVersion());
        }
        metadata.versioning(versioning.build());
        return metadata.build();
    }

    @Override
    protected void merge(Metadata recessive) {
        Versioning original = this.metadata.getVersioning();
        Versioning.Builder versioning = Versioning.newBuilder((Versioning)original);
        versioning.lastUpdated(fmt.format(this.timestamp));
        if (recessive.getVersioning() != null) {
            if (original.getLatest() == null) {
                versioning.latest(recessive.getVersioning().getLatest());
            }
            if (original.getRelease() == null) {
                versioning.release(recessive.getVersioning().getRelease());
            }
            LinkedHashSet versions = new LinkedHashSet(recessive.getVersioning().getVersions());
            versions.addAll(original.getVersions());
            versioning.versions(new ArrayList(versions));
        }
        this.metadata = this.metadata.withVersioning(versioning.build());
        if (recessive.getPlugins() != null && !recessive.getPlugins().isEmpty()) {
            this.metadata = this.metadata.withPlugins(new ArrayList(recessive.getPlugins()));
        }
    }

    public Object getKey() {
        return this.getGroupId() + ":" + this.getArtifactId();
    }

    public static Object getKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    @Deprecated
    public MavenMetadata setFile(File file) {
        return new VersionsMetadata(this.artifact, file.toPath(), this.timestamp);
    }

    public MavenMetadata setPath(Path path) {
        return new VersionsMetadata(this.artifact, path, this.timestamp);
    }

    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    public String getVersion() {
        return "";
    }

    public Metadata.Nature getNature() {
        return this.artifact.isSnapshot() ? Metadata.Nature.RELEASE_OR_SNAPSHOT : Metadata.Nature.RELEASE;
    }
}

