/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.Objects;
import org.apache.maven.api.DependencyScope;
import org.apache.maven.api.Type;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.internal.impl.InternalSession;
import org.eclipse.aether.graph.Dependency;

abstract class AetherDependencyWrapper {
    final InternalSession session;
    final Dependency dependency;

    AetherDependencyWrapper(@Nonnull InternalSession session, @Nonnull Dependency dependency) {
        this.session = Objects.requireNonNull(session, "session");
        this.dependency = Objects.requireNonNull(dependency, "dependency");
    }

    public String getGroupId() {
        return this.dependency.getArtifact().getGroupId();
    }

    public String getArtifactId() {
        return this.dependency.getArtifact().getArtifactId();
    }

    public String getExtension() {
        return this.dependency.getArtifact().getExtension();
    }

    public Type getType() {
        String type = this.dependency.getArtifact().getProperty("type", this.getExtension());
        return this.session.requireType(type);
    }

    @Nonnull
    public String getClassifier() {
        String classifier = this.dependency.getArtifact().getClassifier();
        if (classifier.isEmpty() && (classifier = this.getType().getClassifier()) == null) {
            classifier = "";
        }
        return classifier;
    }

    @Nonnull
    public DependencyScope getScope() {
        return this.session.requireDependencyScope(this.dependency.getScope());
    }

    public String toString() {
        return this.dependency.toString();
    }
}

