/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.ChecksumAlgorithmService;
import org.apache.maven.api.services.ChecksumAlgorithmServiceException;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithm;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;

@Named
@Singleton
public class DefaultChecksumAlgorithmService
implements ChecksumAlgorithmService {
    private final ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector;

    @Inject
    public DefaultChecksumAlgorithmService(ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector) {
        this.checksumAlgorithmFactorySelector = Utils.nonNull(checksumAlgorithmFactorySelector, "checksumAlgorithmFactorySelector");
    }

    public Collection<String> getChecksumAlgorithmNames() {
        return this.checksumAlgorithmFactorySelector.getChecksumAlgorithmFactories().stream().map(ChecksumAlgorithmFactory::getName).collect(Collectors.toList());
    }

    public ChecksumAlgorithmService.ChecksumAlgorithm select(String algorithmName) {
        Utils.nonNull(algorithmName, "algorithmName");
        try {
            return new DefaultChecksumAlgorithm(this.checksumAlgorithmFactorySelector.select(algorithmName));
        }
        catch (IllegalArgumentException e) {
            throw new ChecksumAlgorithmServiceException("unsupported algorithm", (Throwable)e);
        }
    }

    public Collection<ChecksumAlgorithmService.ChecksumAlgorithm> select(Collection<String> algorithmNames) {
        Utils.nonNull(algorithmNames, "algorithmNames");
        try {
            return this.checksumAlgorithmFactorySelector.selectList(new ArrayList<String>(algorithmNames)).stream().map(DefaultChecksumAlgorithm::new).collect(Collectors.toList());
        }
        catch (IllegalArgumentException e) {
            throw new ChecksumAlgorithmServiceException("unsupported algorithm", (Throwable)e);
        }
    }

    public Map<ChecksumAlgorithmService.ChecksumAlgorithm, String> calculate(byte[] data, Collection<ChecksumAlgorithmService.ChecksumAlgorithm> algorithms) {
        Utils.nonNull(data, "data");
        Utils.nonNull(algorithms, "algorithms");
        try {
            return this.calculate(new ByteArrayInputStream(data), algorithms);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Map<ChecksumAlgorithmService.ChecksumAlgorithm, String> calculate(ByteBuffer data, Collection<ChecksumAlgorithmService.ChecksumAlgorithm> algorithms) {
        Utils.nonNull(data, "data");
        Utils.nonNull(algorithms, "algorithms");
        LinkedHashMap<ChecksumAlgorithmService.ChecksumAlgorithm, ChecksumAlgorithmService.ChecksumCalculator> algMap = new LinkedHashMap<ChecksumAlgorithmService.ChecksumAlgorithm, ChecksumAlgorithmService.ChecksumCalculator>();
        algorithms.forEach(f -> algMap.put((ChecksumAlgorithmService.ChecksumAlgorithm)f, f.getCalculator()));
        data.mark();
        for (ChecksumAlgorithmService.ChecksumCalculator checksumCalculator : algMap.values()) {
            checksumCalculator.update(data);
            data.reset();
        }
        LinkedHashMap<ChecksumAlgorithmService.ChecksumAlgorithm, String> result = new LinkedHashMap<ChecksumAlgorithmService.ChecksumAlgorithm, String>();
        algMap.forEach((k, v) -> result.put((ChecksumAlgorithmService.ChecksumAlgorithm)k, v.checksum()));
        return result;
    }

    public Map<ChecksumAlgorithmService.ChecksumAlgorithm, String> calculate(Path file, Collection<ChecksumAlgorithmService.ChecksumAlgorithm> algorithms) throws IOException {
        Utils.nonNull(file, "file");
        Utils.nonNull(algorithms, "algorithms");
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));){
            Map<ChecksumAlgorithmService.ChecksumAlgorithm, String> map = this.calculate(inputStream, algorithms);
            return map;
        }
    }

    public Map<ChecksumAlgorithmService.ChecksumAlgorithm, String> calculate(InputStream stream, Collection<ChecksumAlgorithmService.ChecksumAlgorithm> algorithms) throws IOException {
        int read;
        Utils.nonNull(stream, "stream");
        Utils.nonNull(algorithms, "algorithms");
        LinkedHashMap<ChecksumAlgorithmService.ChecksumAlgorithm, ChecksumAlgorithmService.ChecksumCalculator> algMap = new LinkedHashMap<ChecksumAlgorithmService.ChecksumAlgorithm, ChecksumAlgorithmService.ChecksumCalculator>();
        algorithms.forEach(f -> algMap.put((ChecksumAlgorithmService.ChecksumAlgorithm)f, f.getCalculator()));
        byte[] buffer = new byte[32768];
        while ((read = stream.read(buffer)) >= 0) {
            for (ChecksumAlgorithmService.ChecksumCalculator checksumCalculator : algMap.values()) {
                checksumCalculator.update(ByteBuffer.wrap(buffer, 0, read));
            }
        }
        LinkedHashMap<ChecksumAlgorithmService.ChecksumAlgorithm, String> result = new LinkedHashMap<ChecksumAlgorithmService.ChecksumAlgorithm, String>();
        algMap.forEach((k, v) -> result.put((ChecksumAlgorithmService.ChecksumAlgorithm)k, v.checksum()));
        return result;
    }

    private static class DefaultChecksumAlgorithm
    implements ChecksumAlgorithmService.ChecksumAlgorithm {
        private final ChecksumAlgorithmFactory factory;

        DefaultChecksumAlgorithm(ChecksumAlgorithmFactory factory) {
            this.factory = factory;
        }

        public String getName() {
            return this.factory.getName();
        }

        public String getFileExtension() {
            return this.factory.getFileExtension();
        }

        public ChecksumAlgorithmService.ChecksumCalculator getCalculator() {
            return new DefaultChecksumCalculator(this.factory.getAlgorithm());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultChecksumAlgorithm that = (DefaultChecksumAlgorithm)o;
            return Objects.equals(this.factory.getName(), that.factory.getName());
        }

        public int hashCode() {
            return Objects.hash(this.factory.getName());
        }
    }

    private static class DefaultChecksumCalculator
    implements ChecksumAlgorithmService.ChecksumCalculator {
        private final ChecksumAlgorithm algorithm;

        DefaultChecksumCalculator(ChecksumAlgorithm algorithm) {
            this.algorithm = algorithm;
        }

        public void update(ByteBuffer input) {
            this.algorithm.update(input);
        }

        public String checksum() {
            return this.algorithm.checksum();
        }
    }
}

