/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.Exclusion;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputSource;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.model.DependencyManagementImporter;

@Named
@Singleton
public class DefaultDependencyManagementImporter
implements DependencyManagementImporter {
    @Override
    public Model importManagement(Model target, List<? extends DependencyManagement> sources, ModelBuilderRequest request, ModelProblemCollector problems) {
        if (sources != null && !sources.isEmpty()) {
            LinkedHashMap<String, Dependency> dependencies = new LinkedHashMap<String, Dependency>();
            DependencyManagement depMgmt = target.getDependencyManagement();
            if (depMgmt != null) {
                for (Dependency dependency : depMgmt.getDependencies()) {
                    dependencies.put(dependency.getManagementKey(), dependency);
                }
            } else {
                depMgmt = DependencyManagement.newInstance();
            }
            HashSet directDependencies = new HashSet(dependencies.keySet());
            for (DependencyManagement dependencyManagement : sources) {
                for (Dependency dependency : dependencyManagement.getDependencies()) {
                    String key = dependency.getManagementKey();
                    Dependency present = dependencies.putIfAbsent(key, dependency);
                    if (present != null && !this.equals(dependency, present) && !directDependencies.contains(key)) {
                        problems.add(BuilderProblem.Severity.WARNING, ModelProblem.Version.V40, "Ignored POM import for: " + this.toString(dependency) + " as already imported " + this.toString(present) + ". Add the conflicting managed dependency directly to the dependencyManagement section of the POM.");
                    }
                    if (present != null || !request.isLocationTracking()) continue;
                    Dependency updatedDependency = DefaultDependencyManagementImporter.updateWithImportedFrom(dependency, dependencyManagement);
                    dependencies.put(key, updatedDependency);
                }
            }
            return target.withDependencyManagement(depMgmt.withDependencies(dependencies.values()));
        }
        return target;
    }

    private String toString(Dependency dependency) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(dependency.getGroupId()).append(":").append(dependency.getArtifactId()).append(":").append(dependency.getType());
        if (dependency.getClassifier() != null && !dependency.getClassifier().isEmpty()) {
            stringBuilder.append(":").append(dependency.getClassifier());
        }
        stringBuilder.append(":").append(dependency.getVersion()).append("@").append(dependency.getScope() == null ? "compile" : dependency.getScope());
        if (dependency.isOptional()) {
            stringBuilder.append("[optional]");
        }
        if (!dependency.getExclusions().isEmpty()) {
            stringBuilder.append("[").append(dependency.getExclusions().size()).append(" exclusions]");
        }
        return stringBuilder.toString();
    }

    private boolean equals(Dependency d1, Dependency d2) {
        return Objects.equals(d1.getGroupId(), d2.getGroupId()) && Objects.equals(d1.getArtifactId(), d2.getArtifactId()) && Objects.equals(d1.getVersion(), d2.getVersion()) && Objects.equals(d1.getType(), d2.getType()) && Objects.equals(d1.getClassifier(), d2.getClassifier()) && Objects.equals(d1.getScope(), d2.getScope()) && Objects.equals(d1.getSystemPath(), d2.getSystemPath()) && Objects.equals(d1.getOptional(), d2.getOptional()) && this.equals(d1.getExclusions(), d2.getExclusions());
    }

    private boolean equals(Collection<Exclusion> ce1, Collection<Exclusion> ce2) {
        if (ce1.size() == ce2.size()) {
            Iterator<Exclusion> i1 = ce1.iterator();
            Iterator<Exclusion> i2 = ce2.iterator();
            while (i1.hasNext() && i2.hasNext()) {
                if (this.equals(i1.next(), i2.next())) continue;
                return false;
            }
            return !i1.hasNext() && !i2.hasNext();
        }
        return false;
    }

    private boolean equals(Exclusion e1, Exclusion e2) {
        return Objects.equals(e1.getGroupId(), e2.getGroupId()) && Objects.equals(e1.getArtifactId(), e2.getArtifactId());
    }

    static Dependency updateWithImportedFrom(Dependency dependency, DependencyManagement bom) {
        InputLocation dependencyLocation = dependency.getLocation((Object)"");
        InputLocation bomLocation = bom.getLocation((Object)"");
        if (dependencyLocation == null || bomLocation == null) {
            return dependency;
        }
        InputSource dependencySource = dependencyLocation.getSource();
        InputSource bomSource = bomLocation.getSource();
        if (dependencySource == null || bomSource == null || Objects.equals(dependencySource.getModelId(), bomSource.getModelId())) {
            return Dependency.newBuilder((Dependency)dependency, (boolean)true).importedFrom(bomLocation).build();
        }
        while (dependencySource.getImportedFrom() != null) {
            InputLocation importedFrom = dependencySource.getImportedFrom();
            if (Objects.equals(importedFrom.getSource().getModelId(), bomSource.getModelId())) {
                return dependency;
            }
            dependencySource = importedFrom.getSource();
        }
        return Dependency.newBuilder((Dependency)dependency, (boolean)true).importedFrom(new InputLocation(bomLocation)).build();
    }
}

