/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model.profile;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.VersionParser;
import org.apache.maven.api.services.model.ProfileActivationContext;
import org.apache.maven.api.services.model.ProfileActivator;
import org.apache.maven.internal.impl.model.DefaultInterpolator;
import org.apache.maven.internal.impl.model.profile.ConditionFunctions;
import org.apache.maven.internal.impl.model.profile.ConditionParser;

@Named(value="condition")
@Singleton
public class ConditionProfileActivator
implements ProfileActivator {
    private final VersionParser versionParser;

    @Inject
    public ConditionProfileActivator(VersionParser versionParser) {
        this.versionParser = versionParser;
    }

    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        if (profile.getActivation() == null || profile.getActivation().getCondition() == null) {
            return false;
        }
        String condition = profile.getActivation().getCondition();
        try {
            Map<String, ConditionParser.ExpressionFunction> functions = ConditionProfileActivator.registerFunctions(context, this.versionParser);
            Function<String, String> propertyResolver = s -> ConditionProfileActivator.property(context, s);
            return ConditionParser.toBoolean(new ConditionParser(functions, propertyResolver).parse(condition));
        }
        catch (Exception e) {
            problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.V41, "Error parsing profile activation condition: " + e.getMessage(), e);
            return false;
        }
    }

    @Override
    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        return activation.getCondition() != null && !activation.getCondition().isBlank();
    }

    public static Map<String, ConditionParser.ExpressionFunction> registerFunctions(ProfileActivationContext context, VersionParser versionParser) {
        HashMap<String, ConditionParser.ExpressionFunction> functions = new HashMap<String, ConditionParser.ExpressionFunction>();
        ConditionFunctions conditionFunctions = new ConditionFunctions(context, versionParser);
        for (Method method : ConditionFunctions.class.getDeclaredMethods()) {
            String methodName = method.getName();
            if (methodName.endsWith("_")) {
                methodName = methodName.substring(0, methodName.length() - 1);
            }
            String finalMethodName = methodName;
            functions.put(finalMethodName, args -> {
                try {
                    return method.invoke((Object)conditionFunctions, args);
                }
                catch (Exception e) {
                    StringBuilder causeChain = new StringBuilder();
                    for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                        if (!causeChain.isEmpty()) {
                            causeChain.append(" Caused by: ");
                        }
                        causeChain.append(cause.toString());
                    }
                    throw new RuntimeException("Error invoking function '" + finalMethodName + "': " + e + ". Cause chain: " + causeChain, e);
                }
            });
        }
        return functions;
    }

    static String property(ProfileActivationContext context, String name) {
        String value = ConditionProfileActivator.doGetProperty(context, name);
        return new DefaultInterpolator().interpolate(value, s -> ConditionProfileActivator.doGetProperty(context, s));
    }

    static String doGetProperty(ProfileActivationContext context, String name) {
        if ("project.basedir".equals(name)) {
            return context.getModelBaseDirectory();
        }
        if ("project.rootDirectory".equals(name)) {
            return context.getModelRootDirectory();
        }
        if ("project.artifactId".equals(name)) {
            return context.getModelArtifactId();
        }
        if ("project.packaging".equals(name)) {
            return context.getModelPackaging();
        }
        String v = context.getUserProperty(name);
        if (v == null) {
            v = context.getModelProperty(name);
        }
        if (v == null) {
            v = context.getSystemProperty(name);
        }
        return v;
    }
}

