/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.api.ArtifactCoordinates;
import org.apache.maven.api.DownloadedArtifact;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.Version;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.services.ArtifactResolverException;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.VersionRangeResolverException;
import org.apache.maven.api.services.model.ModelResolver;
import org.apache.maven.api.services.model.ModelResolverException;

@Named
@Singleton
public class DefaultModelResolver
implements ModelResolver {
    @Override
    @Nonnull
    public ModelSource resolveModel(@Nonnull Session session, @Nullable List<RemoteRepository> repositories, @Nonnull Parent parent, @Nonnull AtomicReference<Parent> modified) throws ModelResolverException {
        return this.resolveModel(session, repositories, parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), "parent", null, parent.getLocation((Object)"version"), version -> modified.set(parent.withVersion(version)));
    }

    @Override
    @Nonnull
    public ModelSource resolveModel(@Nonnull Session session, @Nullable List<RemoteRepository> repositories, @Nonnull Dependency dependency, @Nonnull AtomicReference<Dependency> modified) throws ModelResolverException {
        return this.resolveModel(session, repositories, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), "dependency", dependency.getClassifier(), dependency.getLocation((Object)"version"), version -> modified.set(dependency.withVersion(version)));
    }

    @Override
    public ModelSource resolveModel(@Nonnull Session session, @Nullable List<RemoteRepository> repositories, @Nonnull String groupId, @Nonnull String artifactId, @Nonnull String version, @Nullable String classifier, @Nonnull Consumer<String> resolvedVersion) throws ModelResolverException {
        return this.resolveModel(session, repositories, groupId, artifactId, version, null, classifier, null, resolvedVersion);
    }

    public ModelSource resolveModel(Session session, List<RemoteRepository> repositories, String groupId, String artifactId, String version, String type, String classifier, InputLocation location, Consumer<String> resolvedVersion) throws ModelResolverException {
        try {
            ArtifactCoordinates coords = session.createArtifactCoordinates(groupId, artifactId, version, classifier, "pom", null);
            if (coords.getVersionConstraint().getVersionRange() != null && coords.getVersionConstraint().getVersionRange().getUpperBoundary() == null) {
                throw new ModelResolverException("The requested " + (String)(type != null ? type + " " : "") + "version range '" + version + "'" + (String)(location != null ? " (at " + location + ")" : "") + " does not specify an upper bound", groupId, artifactId, version);
            }
            List versions = session.resolveVersionRange(coords, repositories);
            if (versions.isEmpty()) {
                throw new ModelResolverException("No versions matched the requested " + (String)(type != null ? type + " " : "") + "version range '" + version + "'", groupId, artifactId, version);
            }
            String newVersion = ((Version)versions.get(versions.size() - 1)).asString();
            if (!version.equals(newVersion)) {
                resolvedVersion.accept(newVersion);
            }
            Path path = this.getPath(session, repositories, groupId, artifactId, newVersion, classifier);
            return new ResolverModelSource(path, groupId + ":" + artifactId + ":" + newVersion);
        }
        catch (ArtifactResolverException | VersionRangeResolverException e) {
            throw new ModelResolverException(e.getMessage() + " (remote repositories: " + (repositories != null ? repositories : session.getRemoteRepositories()).stream().map(Object::toString).collect(Collectors.joining(", ")) + ")", groupId, artifactId, version, e);
        }
    }

    protected Path getPath(Session session, List<RemoteRepository> repositories, String groupId, String artifactId, String version, String classifier) {
        DownloadedArtifact resolved = session.resolveArtifact(session.createArtifactCoordinates(groupId, artifactId, version, classifier, "pom", null), repositories);
        return resolved.getPath();
    }

    protected static class ResolverModelSource
    implements ModelSource {
        private final Path path;
        private final String location;

        ResolverModelSource(Path path, String location) {
            this.path = path;
            this.location = location;
        }

        public ModelSource resolve(ModelSource.ModelLocator modelLocator, String relative) {
            return null;
        }

        public Path getPath() {
            return null;
        }

        public InputStream openStream() throws IOException {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }

        public String getLocation() {
            return this.location;
        }

        public Source resolve(String relative) {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolverModelSource that = (ResolverModelSource)o;
            return Objects.equals(this.path, that.path) && Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.location);
        }
    }
}

