/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.resolver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.metadata.v4.MetadataStaxReader;
import org.apache.maven.metadata.v4.MetadataStaxWriter;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.metadata.AbstractMetadata;
import org.eclipse.aether.metadata.MergeableMetadata;
import org.eclipse.aether.metadata.Metadata;

abstract class MavenMetadata
extends AbstractMetadata
implements MergeableMetadata {
    static final String MAVEN_METADATA_XML = "maven-metadata.xml";
    static DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC);
    protected org.apache.maven.api.metadata.Metadata metadata;
    private final Path path;
    protected final Instant timestamp;
    private boolean merged;

    @Deprecated
    protected MavenMetadata(org.apache.maven.api.metadata.Metadata metadata, File file, Instant timestamp) {
        this(metadata, file != null ? file.toPath() : null, timestamp);
    }

    protected MavenMetadata(org.apache.maven.api.metadata.Metadata metadata, Path path, Instant timestamp) {
        this.metadata = metadata;
        this.path = path;
        this.timestamp = timestamp;
    }

    public String getType() {
        return MAVEN_METADATA_XML;
    }

    @Deprecated
    public File getFile() {
        return this.path != null ? this.path.toFile() : null;
    }

    public Path getPath() {
        return this.path;
    }

    @Deprecated
    public void merge(File existing, File result) throws RepositoryException {
        this.merge(existing != null ? existing.toPath() : null, result != null ? result.toPath() : null);
    }

    public void merge(Path existing, Path result) throws RepositoryException {
        org.apache.maven.api.metadata.Metadata recessive = MavenMetadata.read(existing);
        this.merge(recessive);
        this.write(result, this.metadata);
        this.merged = true;
    }

    public boolean isMerged() {
        return this.merged;
    }

    protected abstract void merge(org.apache.maven.api.metadata.Metadata var1);

    static org.apache.maven.api.metadata.Metadata read(Path metadataPath) throws RepositoryException {
        org.apache.maven.api.metadata.Metadata metadata;
        block9: {
            if (!Files.exists(metadataPath, new LinkOption[0])) {
                return org.apache.maven.api.metadata.Metadata.newInstance();
            }
            InputStream input = Files.newInputStream(metadataPath, new OpenOption[0]);
            try {
                metadata = new MetadataStaxReader().read(input, false);
                if (input == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XMLStreamException e) {
                    throw new RepositoryException("Could not parse metadata " + metadataPath + ": " + e.getMessage(), (Throwable)e);
                }
            }
            input.close();
        }
        return metadata;
    }

    private void write(Path metadataPath, org.apache.maven.api.metadata.Metadata metadata) throws RepositoryException {
        try {
            Files.createDirectories(metadataPath.getParent(), new FileAttribute[0]);
            try (OutputStream output = Files.newOutputStream(metadataPath, new OpenOption[0]);){
                new MetadataStaxWriter().write(output, metadata);
            }
        }
        catch (IOException | XMLStreamException e) {
            throw new RepositoryException("Could not write metadata " + metadataPath + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    public Metadata setProperties(Map<String, String> properties) {
        return this;
    }
}

