/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.resolver.scopes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.eclipse.aether.impl.scope.BuildPath;
import org.eclipse.aether.impl.scope.BuildScope;
import org.eclipse.aether.impl.scope.BuildScopeMatrixSource;
import org.eclipse.aether.impl.scope.BuildScopeQuery;
import org.eclipse.aether.impl.scope.BuildScopeSource;
import org.eclipse.aether.impl.scope.CommonBuilds;
import org.eclipse.aether.impl.scope.InternalScopeManager;
import org.eclipse.aether.impl.scope.ProjectPath;
import org.eclipse.aether.impl.scope.ScopeManagerConfiguration;
import org.eclipse.aether.internal.impl.scope.ScopeManagerDump;
import org.eclipse.aether.scope.DependencyScope;
import org.eclipse.aether.scope.ResolutionScope;

public final class Maven3ScopeManagerConfiguration
implements ScopeManagerConfiguration {
    public static final Maven3ScopeManagerConfiguration INSTANCE = new Maven3ScopeManagerConfiguration();
    public static final String DS_COMPILE = "compile";
    public static final String DS_RUNTIME = "runtime";
    public static final String DS_PROVIDED = "provided";
    public static final String DS_SYSTEM = "system";
    public static final String DS_TEST = "test";
    public static final String RS_NONE = "none";
    public static final String RS_MAIN_COMPILE = "main-compile";
    public static final String RS_MAIN_COMPILE_PLUS_RUNTIME = "main-compilePlusRuntime";
    public static final String RS_MAIN_RUNTIME = "main-runtime";
    public static final String RS_MAIN_RUNTIME_PLUS_SYSTEM = "main-runtimePlusSystem";
    public static final String RS_TEST_COMPILE = "test-compile";
    public static final String RS_TEST_RUNTIME = "test-runtime";

    private Maven3ScopeManagerConfiguration() {
    }

    public String getId() {
        return "Maven3";
    }

    public boolean isStrictDependencyScopes() {
        return false;
    }

    public boolean isStrictResolutionScopes() {
        return false;
    }

    public BuildScopeSource getBuildScopeSource() {
        return new BuildScopeMatrixSource(Collections.singletonList(CommonBuilds.PROJECT_PATH_MAIN), Arrays.asList(CommonBuilds.BUILD_PATH_COMPILE, CommonBuilds.BUILD_PATH_RUNTIME), new BuildScope[]{CommonBuilds.MAVEN_TEST_BUILD_SCOPE});
    }

    public Collection<DependencyScope> buildDependencyScopes(InternalScopeManager internalScopeManager) {
        ArrayList<DependencyScope> result = new ArrayList<DependencyScope>();
        result.add(internalScopeManager.createDependencyScope(DS_COMPILE, true, BuildScopeQuery.all()));
        result.add(internalScopeManager.createDependencyScope(DS_RUNTIME, true, BuildScopeQuery.byBuildPath((BuildPath)CommonBuilds.BUILD_PATH_RUNTIME)));
        result.add(internalScopeManager.createDependencyScope(DS_PROVIDED, false, BuildScopeQuery.union((Collection[])new Collection[]{BuildScopeQuery.byBuildPath((BuildPath)CommonBuilds.BUILD_PATH_COMPILE), BuildScopeQuery.select((ProjectPath)CommonBuilds.PROJECT_PATH_TEST, (BuildPath)CommonBuilds.BUILD_PATH_RUNTIME)})));
        result.add(internalScopeManager.createDependencyScope(DS_TEST, false, BuildScopeQuery.byProjectPath((ProjectPath)CommonBuilds.PROJECT_PATH_TEST)));
        result.add((DependencyScope)internalScopeManager.createSystemDependencyScope(DS_SYSTEM, false, BuildScopeQuery.all(), "localPath"));
        return result;
    }

    public Collection<ResolutionScope> buildResolutionScopes(InternalScopeManager internalScopeManager) {
        Collection allDependencyScopes = internalScopeManager.getDependencyScopeUniverse();
        Collection nonTransitiveDependencyScopes = allDependencyScopes.stream().filter(s -> !s.isTransitive()).collect(Collectors.toSet());
        DependencyScope system = internalScopeManager.getDependencyScope(DS_SYSTEM).orElse(null);
        ArrayList<ResolutionScope> result = new ArrayList<ResolutionScope>();
        result.add(internalScopeManager.createResolutionScope(RS_NONE, InternalScopeManager.Mode.REMOVE, Collections.emptySet(), Collections.emptySet(), allDependencyScopes));
        result.add(internalScopeManager.createResolutionScope(RS_MAIN_COMPILE, InternalScopeManager.Mode.ELIMINATE, BuildScopeQuery.singleton((ProjectPath)CommonBuilds.PROJECT_PATH_MAIN, (BuildPath)CommonBuilds.BUILD_PATH_COMPILE), Collections.singletonList(system), nonTransitiveDependencyScopes));
        result.add(internalScopeManager.createResolutionScope(RS_MAIN_COMPILE_PLUS_RUNTIME, InternalScopeManager.Mode.ELIMINATE, BuildScopeQuery.byProjectPath((ProjectPath)CommonBuilds.PROJECT_PATH_MAIN), Collections.singletonList(system), nonTransitiveDependencyScopes));
        result.add(internalScopeManager.createResolutionScope(RS_MAIN_RUNTIME, InternalScopeManager.Mode.ELIMINATE, BuildScopeQuery.singleton((ProjectPath)CommonBuilds.PROJECT_PATH_MAIN, (BuildPath)CommonBuilds.BUILD_PATH_RUNTIME), Collections.emptySet(), nonTransitiveDependencyScopes));
        result.add(internalScopeManager.createResolutionScope(RS_MAIN_RUNTIME_PLUS_SYSTEM, InternalScopeManager.Mode.ELIMINATE, BuildScopeQuery.singleton((ProjectPath)CommonBuilds.PROJECT_PATH_MAIN, (BuildPath)CommonBuilds.BUILD_PATH_RUNTIME), Collections.singletonList(system), nonTransitiveDependencyScopes));
        result.add(internalScopeManager.createResolutionScope(RS_TEST_COMPILE, InternalScopeManager.Mode.ELIMINATE, BuildScopeQuery.select((ProjectPath)CommonBuilds.PROJECT_PATH_TEST, (BuildPath)CommonBuilds.BUILD_PATH_COMPILE), Collections.singletonList(system), nonTransitiveDependencyScopes));
        result.add(internalScopeManager.createResolutionScope(RS_TEST_RUNTIME, InternalScopeManager.Mode.ELIMINATE, BuildScopeQuery.select((ProjectPath)CommonBuilds.PROJECT_PATH_TEST, (BuildPath)CommonBuilds.BUILD_PATH_RUNTIME), Collections.singletonList(system), nonTransitiveDependencyScopes));
        return result;
    }

    public static void main(String ... args) {
        ScopeManagerDump.dump((ScopeManagerConfiguration)INSTANCE);
    }
}

