/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class CiManagement implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field system
     */
    private String system;

    /**
     * Field url
     */
    private String url;

    /**
     * Field notifiers
     */
    private java.util.List notifiers;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addNotifier
     * 
     * @param notifier
     */
    public void addNotifier(Notifier notifier)
    {
        getNotifiers().add( notifier );
    } //-- void addNotifier(Notifier) 

    /**
     * Method getNotifiers
     */
    public java.util.List getNotifiers()
    {
        if ( this.notifiers == null )
        {
            this.notifiers = new java.util.ArrayList();
        }
        
        return this.notifiers;
    } //-- java.util.List getNotifiers() 

    /**
     * Get The name of the continuous integration system i.e.
     * Bugzilla
     */
    public String getSystem()
    {
        return this.system;
    } //-- String getSystem() 

    /**
     * Get Url for the continuous integration system used by the
     * project.
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Method removeNotifier
     * 
     * @param notifier
     */
    public void removeNotifier(Notifier notifier)
    {
        getNotifiers().remove( notifier );
    } //-- void removeNotifier(Notifier) 

    /**
     * Set 
     *             Configuration for notifying developers/users
     * when a build is 
     *             unsuccessful, including user information and
     * notification mode.
     *           
     * 
     * @param notifiers
     */
    public void setNotifiers(java.util.List notifiers)
    {
        this.notifiers = notifiers;
    } //-- void setNotifiers(java.util.List) 

    /**
     * Set The name of the continuous integration system i.e.
     * Bugzilla
     * 
     * @param system
     */
    public void setSystem(String system)
    {
        this.system = system;
    } //-- void setSystem(String) 

    /**
     * Set Url for the continuous integration system used by the
     * project.
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
