/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * This activation allows users to specify their own custom trigger
 * for a profile.
 * 
 * @version $Revision$ $Date$
 */
public class ActivationCustom implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The specification for triggering the profile according to
     * the rules of the
     *             custom activation type.
     */
    private Object configuration;

    /**
     * The type (role-hint) of activation which is to be used to
     * activate the
     *             profile.
     */
    private String type;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get the specification for triggering the profile according
     * to the rules of the
     *             custom activation type.
     * 
     * @return Object
     */
    public Object getConfiguration()
    {
        return this.configuration;
    } //-- Object getConfiguration() 

    /**
     * Get the type (role-hint) of activation which is to be used
     * to activate the
     *             profile.
     * 
     * @return String
     */
    public String getType()
    {
        return this.type;
    } //-- String getType() 

    /**
     * Set the specification for triggering the profile according
     * to the rules of the
     *             custom activation type.
     * 
     * @param configuration
     */
    public void setConfiguration( Object configuration )
    {
        this.configuration = configuration;
    } //-- void setConfiguration( Object ) 

    /**
     * Set the type (role-hint) of activation which is to be used
     * to activate the
     *             profile.
     * 
     * @param type
     */
    public void setType( String type )
    {
        this.type = type;
    } //-- void setType( String ) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
