/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Contains the configuration information of the container like
 * Plugin.
 * 
 * @version $Revision$ $Date$
 */
public class ConfigurationContainer implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Whether any configuration should be propagated to child POMs.
     */
    private String inherited;

    /**
     * The configuration as DOM object.
     */
    private Object configuration;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get the configuration as DOM object.
     * 
     * @return Object
     */
    public Object getConfiguration()
    {
        return this.configuration;
    } //-- Object getConfiguration() 

    /**
     * Get whether any configuration should be propagated to child
     * POMs.
     * 
     * @return String
     */
    public String getInherited()
    {
        return this.inherited;
    } //-- String getInherited() 

    /**
     * Set the configuration as DOM object.
     * 
     * @param configuration
     */
    public void setConfiguration( Object configuration )
    {
        this.configuration = configuration;
    } //-- void setConfiguration( Object ) 

    /**
     * Set whether any configuration should be propagated to child
     * POMs.
     * 
     * @param inherited
     */
    public void setInherited( String inherited )
    {
        this.inherited = inherited;
    } //-- void setInherited( String ) 


            
    private boolean inheritanceApplied = true;

    public void unsetInheritanceApplied()
    {
        this.inheritanceApplied = false;
    }

    public boolean isInheritanceApplied()
    {
        return inheritanceApplied;
    }
            
          
    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
