/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.couchdb;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.util.CollectionUtils;
import org.ektorp.DbAccessException;

final class CouchDbUtils {
    CouchDbUtils() {
    }

    public static boolean safeHasNext(Iterator<?> rowIterator) {
        try {
            return rowIterator.hasNext();
        }
        catch (DbAccessException e) {
            return false;
        }
    }

    public static Row jsonNodeToMetaModelRow(JsonNode node, DataSetHeader header) {
        Map<String, ?> map = CouchDbUtils.jsonNodeToMap(node);
        int size = header.size();
        Object[] values = new Object[size];
        for (int i = 0; i < size; ++i) {
            Object value;
            String key = header.getSelectItem(i).getColumn().getName();
            values[i] = value = CollectionUtils.find(map, (String)key);
        }
        DefaultRow finalRow = new DefaultRow(header, values);
        return finalRow;
    }

    public static Map<String, ?> jsonNodeToMap(JsonNode valueNode) {
        if (valueNode == null) {
            return null;
        }
        try {
            ObjectReader reader = new ObjectMapper().reader(Map.class);
            return (Map)reader.readValue(valueNode);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Object jsonNodeToList(JsonNode valueNode) {
        if (valueNode == null) {
            return null;
        }
        try {
            ObjectReader reader = new ObjectMapper().reader(List.class);
            return reader.readValue(valueNode);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

