/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.couchdb;

import java.net.MalformedURLException;
import org.apache.metamodel.ConnectionException;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.couchdb.CouchDbDataContext;
import org.apache.metamodel.factory.AbstractDataContextFactory;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.factory.UnsupportedDataContextPropertiesException;
import org.apache.metamodel.util.SimpleTableDef;
import org.ektorp.CouchDbInstance;
import org.ektorp.http.HttpClient;
import org.ektorp.http.StdHttpClient;
import org.ektorp.impl.StdCouchDbInstance;

public class CouchDbDataContextFactory
extends AbstractDataContextFactory {
    protected String getType() {
        return "couchdb";
    }

    public DataContext create(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) throws UnsupportedDataContextPropertiesException, ConnectionException {
        StdHttpClient.Builder httpClientBuilder = new StdHttpClient.Builder();
        String url = properties.getUrl();
        if (url != null && !url.isEmpty()) {
            try {
                httpClientBuilder.url(url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(url, e);
            }
        } else {
            httpClientBuilder.host(properties.getHostname());
            httpClientBuilder.port(this.getInt(properties.getPort(), 5984));
            httpClientBuilder.enableSSL(this.getBoolean(properties.toMap().get("ssl"), false));
        }
        httpClientBuilder.username(properties.getUsername());
        httpClientBuilder.password(properties.getPassword());
        HttpClient httpClient = httpClientBuilder.build();
        SimpleTableDef[] tableDefs = properties.getTableDefs();
        if (tableDefs != null && tableDefs.length > 0) {
            return new CouchDbDataContext(httpClient, tableDefs);
        }
        String databaseNames = properties.getDatabaseName();
        if (databaseNames != null && !databaseNames.isEmpty()) {
            return new CouchDbDataContext((CouchDbInstance)new StdCouchDbInstance(httpClient), databaseNames.split(","));
        }
        return new CouchDbDataContext(httpClient);
    }
}

