/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.excel;

import java.io.Serializable;
import java.util.List;
import org.apache.metamodel.schema.naming.ColumnNamingStrategies;
import org.apache.metamodel.schema.naming.ColumnNamingStrategy;
import org.apache.metamodel.util.BaseObject;

public final class ExcelConfiguration
extends BaseObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int NO_COLUMN_NAME_LINE = 0;
    public static final int DEFAULT_COLUMN_NAME_LINE = 1;
    public static final int DEFAULT_NUMBERS_OF_LINES_TO_SCAN = 10;
    private final int columnNameLineNumber;
    private final ColumnNamingStrategy columnNamingStrategy;
    private final boolean skipEmptyLines;
    private final boolean skipEmptyColumns;
    private final boolean detectColumnTypes;
    private final int numberOfLinesToScan;

    public ExcelConfiguration() {
        this(1, true, false);
    }

    public ExcelConfiguration(int columnNameLineNumber, boolean skipEmptyLines, boolean skipEmptyColumns) {
        this(columnNameLineNumber, null, skipEmptyLines, skipEmptyColumns);
    }

    public ExcelConfiguration(int columnNameLineNumber, ColumnNamingStrategy columnNamingStrategy, boolean skipEmptyLines, boolean skipEmptyColumns) {
        this(columnNameLineNumber, columnNamingStrategy, skipEmptyLines, skipEmptyColumns, false, 10);
    }

    public ExcelConfiguration(int columnNameLineNumber, ColumnNamingStrategy columnNamingStrategy, boolean skipEmptyLines, boolean skipEmptyColumns, boolean detectColumnTypes, int numberOfLinesToScan) {
        this.columnNameLineNumber = columnNameLineNumber;
        this.skipEmptyLines = skipEmptyLines;
        this.skipEmptyColumns = skipEmptyColumns;
        this.columnNamingStrategy = columnNamingStrategy;
        this.detectColumnTypes = detectColumnTypes;
        this.numberOfLinesToScan = numberOfLinesToScan;
    }

    public ColumnNamingStrategy getColumnNamingStrategy() {
        if (this.columnNamingStrategy == null) {
            return ColumnNamingStrategies.defaultStrategy();
        }
        return this.columnNamingStrategy;
    }

    public int getColumnNameLineNumber() {
        return this.columnNameLineNumber;
    }

    public boolean isSkipEmptyLines() {
        return this.skipEmptyLines;
    }

    public boolean isSkipEmptyColumns() {
        return this.skipEmptyColumns;
    }

    public boolean isDetectColumnTypes() {
        return this.detectColumnTypes;
    }

    public int getNumberOfLinesToScan() {
        return this.numberOfLinesToScan;
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this.columnNameLineNumber);
        identifiers.add(this.skipEmptyLines);
        identifiers.add(this.skipEmptyColumns);
        identifiers.add(this.detectColumnTypes);
        identifiers.add(this.numberOfLinesToScan);
    }

    public String toString() {
        return String.format("ExcelConfiguration[columnNameLineNumber=%s, skipEmptyLines=%s, skipEmptyColumns=%s, detectColumnTypes=%s, numbersOfLinesToScan=%s]", this.columnNameLineNumber, this.skipEmptyLines, this.skipEmptyColumns, this.detectColumnTypes, this.numberOfLinesToScan);
    }
}

