/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.neo4j;

import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.query.SelectItem;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class Neo4jDataSet
extends AbstractDataSet {
    private JSONObject _resultJSONObject;
    private int _currentRowIndex;
    private Row _row;

    public Neo4jDataSet(SelectItem[] selectItems, JSONObject resultJSONObject) {
        super(selectItems);
        this._resultJSONObject = resultJSONObject;
        this._currentRowIndex = 0;
    }

    public boolean next() {
        block5: {
            try {
                JSONArray resultsArray = this._resultJSONObject.getJSONArray("results");
                if (resultsArray.length() > 0) {
                    JSONObject results = resultsArray.getJSONObject(0);
                    JSONArray data = results.getJSONArray("data");
                    if (this._currentRowIndex < data.length()) {
                        JSONObject row = data.getJSONObject(this._currentRowIndex);
                        JSONArray jsonValues = row.getJSONArray("row");
                        Object[] objectValues = new Object[jsonValues.length()];
                        for (int i = 0; i < jsonValues.length(); ++i) {
                            objectValues[i] = jsonValues.getString(i);
                        }
                        this._row = new DefaultRow((DataSetHeader)new SimpleDataSetHeader(this.getSelectItems()), objectValues);
                        ++this._currentRowIndex;
                        return true;
                    }
                    break block5;
                }
                JSONArray errorArray = this._resultJSONObject.getJSONArray("errors");
                JSONObject error = errorArray.getJSONObject(0);
                throw new IllegalStateException(error.toString());
            }
            catch (JSONException e) {
                throw new IllegalStateException(e);
            }
        }
        return false;
    }

    public Row getRow() {
        return this._row;
    }
}

