/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.neo4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.metamodel.schema.ColumnType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ColumnTypeResolver {
    private static final Logger logger = LoggerFactory.getLogger(ColumnTypeResolver.class);
    private final JSONObject _jsonObject;
    private final List<String> _columnNames = new ArrayList<String>();

    public ColumnTypeResolver(JSONObject jsonObject, String[] columnNamesArray) {
        this._jsonObject = jsonObject;
        this._columnNames.addAll(Arrays.asList(columnNamesArray));
    }

    public ColumnType[] getColumnTypes() {
        ArrayList<ColumnType> columnTypes = new ArrayList<ColumnType>();
        try {
            columnTypes.addAll(this.getColumnTypesFromMetadata());
            columnTypes.addAll(this.getColumnTypesFromData());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        columnTypes.addAll(this.getColumnTypesFromRemainingColumns());
        return columnTypes.toArray(new ColumnType[columnTypes.size()]);
    }

    private List<ColumnType> getColumnTypesFromData() throws JSONException {
        ArrayList<ColumnType> columnTypes = new ArrayList<ColumnType>();
        if (this._jsonObject.has("data")) {
            JSONObject data = this._jsonObject.getJSONObject("data");
            Iterator keysIterator = data.keys();
            while (keysIterator.hasNext()) {
                String key = (String)keysIterator.next();
                ColumnType type = this.getTypeFromValue(data, key);
                columnTypes.add(type);
                this.removeIfAvailable(this._columnNames, key);
            }
        }
        return columnTypes;
    }

    private List<ColumnType> getColumnTypesFromMetadata() throws JSONException {
        JSONObject metadata;
        ArrayList<ColumnType> columnTypes = new ArrayList<ColumnType>();
        if (this._jsonObject.has("metadata") && (metadata = this._jsonObject.getJSONObject("metadata")).has("id")) {
            columnTypes.add(ColumnType.BIGINT);
            this.removeIfAvailable(this._columnNames, "_id");
        }
        return columnTypes;
    }

    private List<ColumnType> getColumnTypesFromRemainingColumns() {
        ArrayList<ColumnType> columnTypes = new ArrayList<ColumnType>();
        for (String remainingColumnName : this._columnNames) {
            if (remainingColumnName.contains("rel_")) {
                if (remainingColumnName.contains("#")) {
                    columnTypes.add(ColumnType.LIST);
                    continue;
                }
                columnTypes.add(ColumnType.BIGINT);
                continue;
            }
            columnTypes.add(ColumnType.STRING);
        }
        return columnTypes;
    }

    private void removeIfAvailable(List<String> list, String key) {
        if (list.contains(key)) {
            list.remove(key);
        }
    }

    private ColumnType getTypeFromValue(JSONObject data, String key) {
        try {
            Class<?> keyClass = data.get(key).getClass();
            if (keyClass.equals(Boolean.class)) {
                return ColumnType.BOOLEAN;
            }
            if (keyClass.equals(Integer.class)) {
                return ColumnType.INTEGER;
            }
            if (keyClass.equals(Long.class)) {
                return ColumnType.BIGINT;
            }
            if (keyClass.equals(Double.class)) {
                return ColumnType.DOUBLE;
            }
            if (keyClass.equals(JSONArray.class)) {
                return ColumnType.LIST;
            }
        }
        catch (JSONException e) {
            logger.error("JSON object does not contain required key '{}'. {}", (Object)key, (Object)e.getMessage());
        }
        return ColumnType.STRING;
    }
}

