/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.apr;

import java.net.InetSocketAddress;
import org.apache.mina.core.filterchain.DefaultIoFilterChain;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.session.AbstractIoSession;
import org.apache.tomcat.jni.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AprSession
extends AbstractIoSession {
    private long descriptor;
    private final IoProcessor<AprSession> processor;
    private final IoFilterChain filterChain = new DefaultIoFilterChain((AbstractIoSession)this);
    private final InetSocketAddress remoteAddress;
    private final InetSocketAddress localAddress;
    private boolean readable = true;
    private boolean writable = true;
    private boolean interestedInRead;
    private boolean interestedInWrite;

    AprSession(IoService service, IoProcessor<AprSession> processor, long descriptor) throws Exception {
        super(service);
        this.processor = processor;
        this.descriptor = descriptor;
        long ra = Address.get((int)1, (long)descriptor);
        long la = Address.get((int)0, (long)descriptor);
        this.remoteAddress = new InetSocketAddress(Address.getip((long)ra), Address.getInfo((long)ra).port);
        this.localAddress = new InetSocketAddress(Address.getip((long)la), Address.getInfo((long)la).port);
    }

    AprSession(IoService service, IoProcessor<AprSession> processor, long descriptor, InetSocketAddress remoteAddress) throws Exception {
        super(service);
        this.processor = processor;
        this.descriptor = descriptor;
        long la = Address.get((int)0, (long)descriptor);
        this.remoteAddress = remoteAddress;
        this.localAddress = new InetSocketAddress(Address.getip((long)la), Address.getInfo((long)la).port);
    }

    long getDescriptor() {
        return this.descriptor;
    }

    void setDescriptor(long desc) {
        this.descriptor = desc;
    }

    public IoProcessor<AprSession> getProcessor() {
        return this.processor;
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    public InetSocketAddress getServiceAddress() {
        return (InetSocketAddress)super.getServiceAddress();
    }

    boolean isReadable() {
        return this.readable;
    }

    void setReadable(boolean readable) {
        this.readable = readable;
    }

    boolean isWritable() {
        return this.writable;
    }

    void setWritable(boolean writable) {
        this.writable = writable;
    }

    boolean isInterestedInRead() {
        return this.interestedInRead;
    }

    void setInterestedInRead(boolean isOpRead) {
        this.interestedInRead = isOpRead;
    }

    boolean isInterestedInWrite() {
        return this.interestedInWrite;
    }

    void setInterestedInWrite(boolean isOpWrite) {
        this.interestedInWrite = isOpWrite;
    }
}

