/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlType;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;

@XmlType(name="snippet")
public class SnippetDTO {
    private String id;
    private String uri;
    private String parentGroupId;
    private Boolean linked;
    private Set<String> processGroups = new HashSet<String>();
    private Set<String> remoteProcessGroups = new HashSet<String>();
    private Set<String> processors = new HashSet<String>();
    private Set<String> inputPorts = new HashSet<String>();
    private Set<String> outputPorts = new HashSet<String>();
    private Set<String> connections = new HashSet<String>();
    private Set<String> labels = new HashSet<String>();
    private Set<String> funnels = new HashSet<String>();
    private FlowSnippetDTO contents;

    @ApiModelProperty(value="The id of the snippet.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="The URI of the snippet.")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @ApiModelProperty(value="The group id for the components in the snippet.")
    public String getParentGroupId() {
        return this.parentGroupId;
    }

    public void setParentGroupId(String parentGroupId) {
        this.parentGroupId = parentGroupId;
    }

    @ApiModelProperty(value="Whether or not the snippet is linked to the underlying data flow. For instance if linked was set to true and the snippet was deleted it would also deleted the components in the snippet. If the snippet was not linked, deleting the snippet would only remove the snippet and leave the component intact.")
    public Boolean isLinked() {
        return this.linked;
    }

    public void setLinked(Boolean linked) {
        this.linked = linked;
    }

    @ApiModelProperty(value="The ids of the connections in this snippet. These ids will be populated within each response. They can be specified when creating a snippet. However, once a snippet has been created its contents cannot be modified (these ids are ignored during update requests).")
    public Set<String> getConnections() {
        return this.connections;
    }

    public void setConnections(Set<String> connections) {
        this.connections = connections;
    }

    @ApiModelProperty(value="The ids of the funnels in this snippet. These ids will be populated within each response. They can be specified when creating a snippet. However, once a snippet has been created its contents cannot be modified (these ids are ignored during update requests).")
    public Set<String> getFunnels() {
        return this.funnels;
    }

    public void setFunnels(Set<String> funnels) {
        this.funnels = funnels;
    }

    @ApiModelProperty(value="The ids of the input ports in this snippet. These ids will be populated within each response. They can be specified when creating a snippet. However, once a snippet has been created its contents cannot be modified (these ids are ignored during update requests).")
    public Set<String> getInputPorts() {
        return this.inputPorts;
    }

    public void setInputPorts(Set<String> inputPorts) {
        this.inputPorts = inputPorts;
    }

    @ApiModelProperty(value="The ids of the labels in this snippet. These ids will be populated within each response. They can be specified when creating a snippet. However, once a snippet has been created its contents cannot be modified (these ids are ignored during update requests).")
    public Set<String> getLabels() {
        return this.labels;
    }

    public void setLabels(Set<String> labels) {
        this.labels = labels;
    }

    @ApiModelProperty(value="The ids of the output ports in this snippet. These ids will be populated within each response. They can be specified when creating a snippet. However, once a snippet has been created its contents cannot be modified (these ids are ignored during update requests).")
    public Set<String> getOutputPorts() {
        return this.outputPorts;
    }

    public void setOutputPorts(Set<String> outputPorts) {
        this.outputPorts = outputPorts;
    }

    @ApiModelProperty(value="The ids of the process groups in this snippet. These ids will be populated within each response. They can be specified when creating a snippet. However, once a snippet has been created its contents cannot be modified (these ids are ignored during update requests).")
    public Set<String> getProcessGroups() {
        return this.processGroups;
    }

    public void setProcessGroups(Set<String> processGroups) {
        this.processGroups = processGroups;
    }

    @ApiModelProperty(value="The ids of the processors in this snippet. These ids will be populated within each response. They can be specified when creating a snippet. However, once a snippet has been created its contents cannot be modified (these ids are ignored during update requests).")
    public Set<String> getProcessors() {
        return this.processors;
    }

    public void setProcessors(Set<String> processors) {
        this.processors = processors;
    }

    @ApiModelProperty(value="The ids of the remote process groups in this snippet. These ids will be populated within each response. They can be specified when creating a snippet. However, once a snippet has been created its contents cannot be modified (these ids are ignored during update requests).")
    public Set<String> getRemoteProcessGroups() {
        return this.remoteProcessGroups;
    }

    public void setRemoteProcessGroups(Set<String> remoteProcessGroups) {
        this.remoteProcessGroups = remoteProcessGroups;
    }

    @ApiModelProperty(value="The contents of the configuration for the snippet.")
    public FlowSnippetDTO getContents() {
        return this.contents;
    }

    public void setContents(FlowSnippetDTO contents) {
        this.contents = contents;
    }
}

