/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp;

import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.dbcp.DBCPValidator;
import org.apache.nifi.dbcp.DriverShim;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.kerberos.KerberosCredentialsService;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.security.krb.KerberosAction;
import org.apache.nifi.security.krb.KerberosKeytabUser;
import org.apache.nifi.security.krb.KerberosPasswordUser;
import org.apache.nifi.security.krb.KerberosUser;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;

@Tags(value={"dbcp", "jdbc", "database", "connection", "pooling", "store"})
@CapabilityDescription(value="Provides Database Connection Pooling Service. Connections can be asked from pool and returned after usage.")
@DynamicProperty(name="JDBC property name", value="JDBC property value", expressionLanguageScope=ExpressionLanguageScope.VARIABLE_REGISTRY, description="Specifies a property name and value to be set on the JDBC connection(s). If Expression Language is used, evaluation will be performed upon the controller service being enabled. Note that no flow file input (attributes, e.g.) is available for use in Expression Language constructs for these properties.")
public class DBCPConnectionPool
extends AbstractControllerService
implements DBCPService {
    private static final String DEFAULT_MIN_IDLE = "0";
    private static final String DEFAULT_MAX_IDLE = "8";
    private static final String DEFAULT_MAX_CONN_LIFETIME = "-1";
    private static final String DEFAULT_EVICTION_RUN_PERIOD = String.valueOf(-1L);
    private static final String DEFAULT_MIN_EVICTABLE_IDLE_TIME = "30 mins";
    private static final String DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME = String.valueOf(-1L);
    public static final PropertyDescriptor DATABASE_URL = new PropertyDescriptor.Builder().name("Database Connection URL").description("A database connection URL used to connect to a database. May contain database system name, host, port, database name and some parameters. The exact syntax of a database connection URL is specified by your DBMS.").defaultValue(null).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor DB_DRIVERNAME = new PropertyDescriptor.Builder().name("Database Driver Class Name").description("Database driver class name").defaultValue(null).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor DB_DRIVER_LOCATION = new PropertyDescriptor.Builder().name("database-driver-locations").displayName("Database Driver Location(s)").description("Comma-separated list of files/folders and/or URLs containing the driver JAR and its dependencies (if any). For example '/var/tmp/mariadb-java-client-1.1.7.jar'").defaultValue(null).required(false).addValidator(StandardValidators.createListValidator((boolean)true, (boolean)true, (Validator)StandardValidators.createURLorFileValidator())).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor DB_USER = new PropertyDescriptor.Builder().name("Database User").description("Database user name").defaultValue(null).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor DB_PASSWORD = new PropertyDescriptor.Builder().name("Password").description("The password for the database user").defaultValue(null).required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor MAX_WAIT_TIME = new PropertyDescriptor.Builder().name("Max Wait Time").description("The maximum amount of time that the pool will wait (when there are no available connections)  for a connection to be returned before failing, or -1 to wait indefinitely. ").defaultValue("500 millis").required(true).addValidator(DBCPValidator.CUSTOM_TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).sensitive(false).build();
    public static final PropertyDescriptor MAX_TOTAL_CONNECTIONS = new PropertyDescriptor.Builder().name("Max Total Connections").description("The maximum number of active connections that can be allocated from this pool at the same time,  or negative for no limit.").defaultValue("8").required(true).addValidator(StandardValidators.INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).sensitive(false).build();
    public static final PropertyDescriptor VALIDATION_QUERY = new PropertyDescriptor.Builder().name("Validation-query").displayName("Validation query").description("Validation query used to validate connections before returning them. When connection is invalid, it get's dropped and new valid connection will be returned. Note!! Using validation might have some performance penalty.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor MIN_IDLE = new PropertyDescriptor.Builder().displayName("Minimum Idle Connections").name("dbcp-min-idle-conns").description("The minimum number of connections that can remain idle in the pool, without extra ones being created, or zero to create none.").defaultValue("0").required(false).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor MAX_IDLE = new PropertyDescriptor.Builder().displayName("Max Idle Connections").name("dbcp-max-idle-conns").description("The maximum number of connections that can remain idle in the pool, without extra ones being released, or negative for no limit.").defaultValue("8").required(false).addValidator(StandardValidators.INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor MAX_CONN_LIFETIME = new PropertyDescriptor.Builder().displayName("Max Connection Lifetime").name("dbcp-max-conn-lifetime").description("The maximum lifetime in milliseconds of a connection. After this time is exceeded the connection will fail the next activation, passivation or validation test. A value of zero or less means the connection has an infinite lifetime.").defaultValue("-1").required(false).addValidator(DBCPValidator.CUSTOM_TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor EVICTION_RUN_PERIOD = new PropertyDescriptor.Builder().displayName("Time Between Eviction Runs").name("dbcp-time-between-eviction-runs").description("The number of milliseconds to sleep between runs of the idle connection evictor thread. When non-positive, no idle connection evictor thread will be run.").defaultValue(DEFAULT_EVICTION_RUN_PERIOD).required(false).addValidator(DBCPValidator.CUSTOM_TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor MIN_EVICTABLE_IDLE_TIME = new PropertyDescriptor.Builder().displayName("Minimum Evictable Idle Time").name("dbcp-min-evictable-idle-time").description("The minimum amount of time a connection may sit idle in the pool before it is eligible for eviction.").defaultValue("30 mins").required(false).addValidator(DBCPValidator.CUSTOM_TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor SOFT_MIN_EVICTABLE_IDLE_TIME = new PropertyDescriptor.Builder().displayName("Soft Minimum Evictable Idle Time").name("dbcp-soft-min-evictable-idle-time").description("The minimum amount of time a connection may sit idle in the pool before it is eligible for eviction by the idle connection evictor, with the extra condition that at least a minimum number of idle connections remain in the pool. When the not-soft version of this option is set to a positive value, it is examined first by the idle connection evictor: when idle connections are visited by the evictor, idle time is first compared against it (without considering the number of idle connections in the pool) and then against this soft option, including the minimum idle connections constraint.").defaultValue(DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME).required(false).addValidator(DBCPValidator.CUSTOM_TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor KERBEROS_CREDENTIALS_SERVICE = new PropertyDescriptor.Builder().name("kerberos-credentials-service").displayName("Kerberos Credentials Service").description("Specifies the Kerberos Credentials Controller Service that should be used for authenticating with Kerberos").identifiesControllerService(KerberosCredentialsService.class).required(false).build();
    public static final PropertyDescriptor KERBEROS_PRINCIPAL = new PropertyDescriptor.Builder().name("kerberos-principal").displayName("Kerberos Principal").description("The principal to use when specifying the principal and password directly in the processor for authenticating via Kerberos.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor KERBEROS_PASSWORD = new PropertyDescriptor.Builder().name("kerberos-password").displayName("Kerberos Password").description("The password to use when specifying the principal and password directly in the processor for authenticating via Kerberos.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    private static final List<PropertyDescriptor> properties;
    private volatile BasicDataSource dataSource;
    private volatile KerberosUser kerberosUser;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dynamic(true).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        KerberosCredentialsService kerberosCredentialsService;
        boolean kerberosPasswordProvided;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        boolean kerberosPrincipalProvided = !StringUtils.isBlank((CharSequence)context.getProperty(KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue());
        boolean bl = kerberosPasswordProvided = !StringUtils.isBlank((CharSequence)context.getProperty(KERBEROS_PASSWORD).getValue());
        if (kerberosPrincipalProvided && !kerberosPasswordProvided) {
            results.add(new ValidationResult.Builder().subject(KERBEROS_PASSWORD.getDisplayName()).valid(false).explanation("a password must be provided for the given principal").build());
        }
        if (kerberosPasswordProvided && !kerberosPrincipalProvided) {
            results.add(new ValidationResult.Builder().subject(KERBEROS_PRINCIPAL.getDisplayName()).valid(false).explanation("a principal must be provided for the given password").build());
        }
        if ((kerberosCredentialsService = (KerberosCredentialsService)context.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class)) != null && (kerberosPrincipalProvided || kerberosPasswordProvided)) {
            results.add(new ValidationResult.Builder().subject(KERBEROS_CREDENTIALS_SERVICE.getDisplayName()).valid(false).explanation("kerberos principal/password and kerberos credential service cannot be configured at the same time").build());
        }
        return results;
    }

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        String drv = context.getProperty(DB_DRIVERNAME).evaluateAttributeExpressions().getValue();
        String user = context.getProperty(DB_USER).evaluateAttributeExpressions().getValue();
        String passw = context.getProperty(DB_PASSWORD).evaluateAttributeExpressions().getValue();
        Integer maxTotal = context.getProperty(MAX_TOTAL_CONNECTIONS).evaluateAttributeExpressions().asInteger();
        String validationQuery = context.getProperty(VALIDATION_QUERY).evaluateAttributeExpressions().getValue();
        Long maxWaitMillis = this.extractMillisWithInfinite(context.getProperty(MAX_WAIT_TIME).evaluateAttributeExpressions());
        Integer minIdle = context.getProperty(MIN_IDLE).evaluateAttributeExpressions().asInteger();
        Integer maxIdle = context.getProperty(MAX_IDLE).evaluateAttributeExpressions().asInteger();
        Long maxConnLifetimeMillis = this.extractMillisWithInfinite(context.getProperty(MAX_CONN_LIFETIME).evaluateAttributeExpressions());
        Long timeBetweenEvictionRunsMillis = this.extractMillisWithInfinite(context.getProperty(EVICTION_RUN_PERIOD).evaluateAttributeExpressions());
        Long minEvictableIdleTimeMillis = this.extractMillisWithInfinite(context.getProperty(MIN_EVICTABLE_IDLE_TIME).evaluateAttributeExpressions());
        Long softMinEvictableIdleTimeMillis = this.extractMillisWithInfinite(context.getProperty(SOFT_MIN_EVICTABLE_IDLE_TIME).evaluateAttributeExpressions());
        KerberosCredentialsService kerberosCredentialsService = (KerberosCredentialsService)context.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        String kerberosPrincipal = context.getProperty(KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue();
        String kerberosPassword = context.getProperty(KERBEROS_PASSWORD).getValue();
        if (kerberosCredentialsService != null) {
            this.kerberosUser = new KerberosKeytabUser(kerberosCredentialsService.getPrincipal(), kerberosCredentialsService.getKeytab());
        } else if (!StringUtils.isBlank((CharSequence)kerberosPrincipal) && !StringUtils.isBlank((CharSequence)kerberosPassword)) {
            this.kerberosUser = new KerberosPasswordUser(kerberosPrincipal, kerberosPassword);
        }
        if (this.kerberosUser != null) {
            try {
                this.kerberosUser.login();
            }
            catch (LoginException e) {
                throw new InitializationException("Unable to authenticate Kerberos principal", (Throwable)e);
            }
        }
        this.dataSource = new BasicDataSource();
        this.dataSource.setDriverClassName(drv);
        String urlString = context.getProperty(DB_DRIVER_LOCATION).evaluateAttributeExpressions().getValue();
        this.dataSource.setDriverClassLoader(this.getDriverClassLoader(urlString, drv));
        String dburl = context.getProperty(DATABASE_URL).evaluateAttributeExpressions().getValue();
        this.dataSource.setMaxWaitMillis(maxWaitMillis.longValue());
        this.dataSource.setMaxTotal(maxTotal.intValue());
        this.dataSource.setMinIdle(minIdle.intValue());
        this.dataSource.setMaxIdle(maxIdle.intValue());
        this.dataSource.setMaxConnLifetimeMillis(maxConnLifetimeMillis.longValue());
        this.dataSource.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis.longValue());
        this.dataSource.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis.longValue());
        this.dataSource.setSoftMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis.longValue());
        if (validationQuery != null && !validationQuery.isEmpty()) {
            this.dataSource.setValidationQuery(validationQuery);
            this.dataSource.setTestOnBorrow(true);
        }
        this.dataSource.setUrl(dburl);
        this.dataSource.setUsername(user);
        this.dataSource.setPassword(passw);
        context.getProperties().keySet().stream().filter(PropertyDescriptor::isDynamic).forEach(dynamicPropDescriptor -> this.dataSource.addConnectionProperty(dynamicPropDescriptor.getName(), context.getProperty(dynamicPropDescriptor).evaluateAttributeExpressions().getValue()));
    }

    private Long extractMillisWithInfinite(PropertyValue prop) {
        return DEFAULT_MAX_CONN_LIFETIME.equals(prop.getValue()) ? -1L : prop.asTimePeriod(TimeUnit.MILLISECONDS);
    }

    protected ClassLoader getDriverClassLoader(String locationString, String drvName) throws InitializationException {
        if (locationString != null && locationString.length() > 0) {
            try {
                ClassLoader classLoader = ClassLoaderUtils.getCustomClassLoader((String)locationString, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (dir, name) -> name != null && name.endsWith(".jar"));
                Class<?> clazz = Class.forName(drvName, true, classLoader);
                if (clazz == null) {
                    throw new InitializationException("Can't load Database Driver " + drvName);
                }
                Driver driver = (Driver)clazz.newInstance();
                DriverManager.registerDriver(new DriverShim(driver));
                return classLoader;
            }
            catch (MalformedURLException e) {
                throw new InitializationException("Invalid Database Driver Jar Url", (Throwable)e);
            }
            catch (Exception e) {
                throw new InitializationException("Can't load Database Driver", (Throwable)e);
            }
        }
        return Thread.currentThread().getContextClassLoader();
    }

    @OnDisabled
    public void shutdown() throws SQLException, LoginException {
        try {
            if (this.kerberosUser != null) {
                this.kerberosUser.logout();
            }
        }
        finally {
            this.kerberosUser = null;
            try {
                if (this.dataSource != null) {
                    this.dataSource.close();
                }
            }
            finally {
                this.dataSource = null;
            }
        }
    }

    public Connection getConnection() throws ProcessException {
        try {
            Connection con;
            if (this.kerberosUser != null) {
                KerberosAction kerberosAction = new KerberosAction(this.kerberosUser, () -> this.dataSource.getConnection(), this.getLogger());
                con = (Connection)kerberosAction.execute();
            } else {
                con = this.dataSource.getConnection();
            }
            return con;
        }
        catch (SQLException e) {
            throw new ProcessException((Throwable)e);
        }
    }

    public String toString() {
        return "DBCPConnectionPool[id=" + this.getIdentifier() + "]";
    }

    BasicDataSource getDataSource() {
        return this.dataSource;
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(DATABASE_URL);
        props.add(DB_DRIVERNAME);
        props.add(DB_DRIVER_LOCATION);
        props.add(KERBEROS_CREDENTIALS_SERVICE);
        props.add(KERBEROS_PRINCIPAL);
        props.add(KERBEROS_PASSWORD);
        props.add(DB_USER);
        props.add(DB_PASSWORD);
        props.add(MAX_WAIT_TIME);
        props.add(MAX_TOTAL_CONNECTIONS);
        props.add(VALIDATION_QUERY);
        props.add(MIN_IDLE);
        props.add(MAX_IDLE);
        props.add(MAX_CONN_LIFETIME);
        props.add(EVICTION_RUN_PERIOD);
        props.add(MIN_EVICTABLE_IDLE_TIME);
        props.add(SOFT_MIN_EVICTABLE_IDLE_TIME);
        properties = Collections.unmodifiableList(props);
    }
}

