/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language;

import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.registry.VariableRegistryUtils;

public class StandardAttributeExpression
implements AttributeExpression {
    private final Query query;
    private final VariableRegistry variableRegistry;

    public StandardAttributeExpression(Query query, VariableRegistry variableRegistry) {
        this.query = query;
        this.variableRegistry = variableRegistry;
    }

    public AttributeExpression.ResultType getResultType() {
        return this.query.getResultType();
    }

    public String evaluate() throws ProcessException {
        return this.evaluate((AttributeValueDecorator)null);
    }

    public String evaluate(AttributeValueDecorator decorator) throws ProcessException {
        return this.evaluate(null, decorator);
    }

    public String evaluate(FlowFile flowFile) throws ProcessException {
        return this.evaluate(flowFile, null);
    }

    public String evaluate(FlowFile flowFile, AttributeValueDecorator decorator) throws ProcessException {
        VariableRegistry flowFileRegistry = VariableRegistryUtils.populateRegistry((VariableRegistry)this.variableRegistry, (FlowFile)flowFile, null);
        Object evaluationResult = this.query.evaluate(flowFileRegistry).getValue();
        if (evaluationResult == null) {
            return "";
        }
        String result = evaluationResult.toString();
        if (decorator != null) {
            result = decorator.decorate(result);
        }
        return Query.unescape(result);
    }
}

