/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class ContainsEvaluator
extends BooleanEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> search;

    public ContainsEvaluator(Evaluator<String> subject, Evaluator<String> search) {
        this.subject = subject;
        this.search = search;
    }

    @Override
    public QueryResult<Boolean> evaluate(Map<String, String> attributes) {
        String subjectValue = this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new BooleanQueryResult(false);
        }
        String searchString = this.search.evaluate(attributes).getValue();
        return new BooleanQueryResult(searchString == null ? false : subjectValue.contains(searchString));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

