/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class DivideEvaluator
extends NumberEvaluator {
    private final Evaluator<Long> subject;
    private final Evaluator<Long> divideValue;

    public DivideEvaluator(Evaluator<Long> subject, Evaluator<Long> divideValue) {
        this.subject = subject;
        this.divideValue = divideValue;
    }

    @Override
    public QueryResult<Long> evaluate(Map<String, String> attributes) {
        Long subjectValue = this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new NumberQueryResult(null);
        }
        Long divide = this.divideValue.evaluate(attributes).getValue();
        if (divide == null) {
            return new NumberQueryResult(null);
        }
        long result = subjectValue / divide;
        return new NumberQueryResult(result);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

