/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class IndexOfEvaluator
extends NumberEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> indexEvaluator;

    public IndexOfEvaluator(Evaluator<String> subject, Evaluator<String> indexEvaluator) {
        this.subject = subject;
        this.indexEvaluator = indexEvaluator;
    }

    @Override
    public QueryResult<Long> evaluate(Map<String, String> attributes) {
        String subjectValue = this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new NumberQueryResult(-1L);
        }
        String indexEvalValue = this.indexEvaluator.evaluate(attributes).getValue();
        return new NumberQueryResult(Long.valueOf(subjectValue.indexOf(indexEvalValue)));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

