/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class MultiplyEvaluator
extends NumberEvaluator {
    private final Evaluator<Long> subject;
    private final Evaluator<Long> multiplyValue;

    public MultiplyEvaluator(Evaluator<Long> subject, Evaluator<Long> multiplyValue) {
        this.subject = subject;
        this.multiplyValue = multiplyValue;
    }

    @Override
    public QueryResult<Long> evaluate(Map<String, String> attributes) {
        Long subjectValue = this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new NumberQueryResult(null);
        }
        Long multiply = this.multiplyValue.evaluate(attributes).getValue();
        if (multiply == null) {
            return new NumberQueryResult(null);
        }
        long result = subjectValue * multiply;
        return new NumberQueryResult(result);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

