/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class PlusEvaluator
extends NumberEvaluator {
    private final Evaluator<Long> subject;
    private final Evaluator<Long> plusValue;

    public PlusEvaluator(Evaluator<Long> subject, Evaluator<Long> plusValue) {
        this.subject = subject;
        this.plusValue = plusValue;
    }

    @Override
    public QueryResult<Long> evaluate(Map<String, String> attributes) {
        Long subjectValue = this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new NumberQueryResult(null);
        }
        Long plus = this.plusValue.evaluate(attributes).getValue();
        if (plus == null) {
            return new NumberQueryResult(null);
        }
        long result = subjectValue + plus;
        return new NumberQueryResult(result);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

