/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.processor.exception.ProcessException;

public class StandardPreparedQuery
implements PreparedQuery {
    private final List<String> queryStrings;
    private final Map<String, Tree> trees;

    public StandardPreparedQuery(List<String> queryStrings, Map<String, Tree> trees) {
        this.queryStrings = new ArrayList<String>(queryStrings);
        this.trees = new HashMap<String, Tree>(trees);
    }

    @Override
    public String evaluateExpressions(Map<String, String> valueMap, AttributeValueDecorator decorator) throws ProcessException {
        StringBuilder sb = new StringBuilder();
        for (String val : this.queryStrings) {
            Tree tree = this.trees.get(val);
            if (tree == null) {
                sb.append(val);
                continue;
            }
            String evaluated = Query.evaluateExpression(tree, val, valueMap, decorator);
            if (evaluated == null) continue;
            sb.append(evaluated);
        }
        return sb.toString();
    }
}

