/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.DateEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class FormatEvaluator
extends StringEvaluator {
    private final DateEvaluator subject;
    private final Evaluator<String> format;

    public FormatEvaluator(DateEvaluator subject, Evaluator<String> format) {
        this.subject = subject;
        this.format = format;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        Date subjectValue = (Date)this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new StringQueryResult(null);
        }
        QueryResult<String> formatResult = this.format.evaluate(attributes);
        String format = formatResult.getValue();
        if (format == null) {
            return null;
        }
        return new StringQueryResult(new SimpleDateFormat(format, Locale.US).format(subjectValue));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

