/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.Tree;
import org.apache.nifi.attribute.expression.language.AttributesAndState;
import org.apache.nifi.attribute.expression.language.EmptyPreparedQuery;
import org.apache.nifi.attribute.expression.language.InvalidPreparedQuery;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.StandardPreparedQuery;
import org.apache.nifi.attribute.expression.language.antlr.AttributeExpressionLexer;
import org.apache.nifi.attribute.expression.language.antlr.AttributeExpressionParser;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.DateEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.cast.BooleanCastEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.cast.DateCastEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.cast.DecimalCastEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.cast.NumberCastEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.cast.StringCastEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.cast.WholeNumberCastEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.AndEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.AppendEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.AttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.Base64DecodeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.Base64EncodeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.CharSequenceTranslatorEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ContainsEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.DivideEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.EndsWithEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.EqualsEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.EqualsIgnoreCaseEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.FindEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.FormatEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.FromRadixEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.GetDelimitedFieldEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.GetStateVariableEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.GreaterThanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.GreaterThanOrEqualEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.HostnameEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.IPEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.IfElseEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.InEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.IndexOfEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.IsEmptyEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.IsNullEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.JsonPathEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.LastIndexOfEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.LengthEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.LessThanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.LessThanOrEqualEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.MatchesEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.MathEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.MinusEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ModEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.MultiplyEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.NotEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.NotNullEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.NowEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.NumberToDateEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.OneUpSequenceEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.OrEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.PlusEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.PrependEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.RandomNumberGeneratorEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ReplaceAllEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ReplaceEmptyEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ReplaceEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ReplaceFirstEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ReplaceNullEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.StartsWithEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.StringToDateEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.SubstringAfterEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.SubstringAfterLastEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.SubstringBeforeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.SubstringBeforeLastEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.SubstringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ToLowerEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ToRadixEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ToStringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.ToUpperEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.TrimEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.UrlDecodeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.UrlEncodeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.functions.UuidEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.literals.BooleanLiteralEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.literals.DecimalLiteralEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.literals.StringLiteralEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.literals.ToLiteralEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.literals.WholeNumberLiteralEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.reduce.CountEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.reduce.JoinEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.reduce.ReduceEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.AllAttributesEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.AnyAttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.DelineatedAttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.IteratingEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MappingEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiAttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiMatchAttributeEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiNamedAttributeEvaluator;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageException;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageParsingException;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.exception.ProcessException;

public class Query {
    private final String query;
    private final Tree tree;
    private final Evaluator<?> evaluator;
    private final AtomicBoolean evaluated = new AtomicBoolean(false);

    private Query(String query, Tree tree, Evaluator<?> evaluator) {
        this.query = query;
        this.tree = tree;
        this.evaluator = evaluator;
    }

    public static boolean isValidExpression(String value) {
        try {
            Query.validateExpression(value, false);
            return true;
        }
        catch (AttributeExpressionLanguageParsingException | ProcessException e) {
            return false;
        }
    }

    public static AttributeExpression.ResultType getResultType(String value) throws AttributeExpressionLanguageParsingException {
        return Query.compile(value).getResultType();
    }

    public static List<AttributeExpression.ResultType> extractResultTypes(String value) throws AttributeExpressionLanguageParsingException {
        ArrayList<AttributeExpression.ResultType> types = new ArrayList<AttributeExpression.ResultType>();
        for (Range range : Query.extractExpressionRanges(value)) {
            String text = value.substring(range.getStart(), range.getEnd() + 1);
            types.add(Query.getResultType(text));
        }
        return types;
    }

    public static List<String> extractExpressions(String value) throws AttributeExpressionLanguageParsingException {
        ArrayList<String> expressions = new ArrayList<String>();
        for (Range range : Query.extractExpressionRanges(value)) {
            expressions.add(value.substring(range.getStart(), range.getEnd() + 1));
        }
        return expressions;
    }

    public static List<Range> extractExpressionRanges(String value) throws AttributeExpressionLanguageParsingException {
        ArrayList<Range> ranges = new ArrayList<Range>();
        int lastChar = 0;
        int embeddedCount = 0;
        int expressionStart = -1;
        boolean oddDollarCount = false;
        int backslashCount = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!(expressionStart <= -1 || c != '\'' && c != '\"' || lastChar == 92 && backslashCount % 2 != 0)) {
                int endQuoteIndex = Query.findEndQuoteChar(value, i);
                if (endQuoteIndex < 0) break;
                i = endQuoteIndex;
                continue;
            }
            if (c == '{') {
                if (oddDollarCount && lastChar == 36 && embeddedCount == 0) {
                    expressionStart = i - 1;
                }
                if (expressionStart > -1) {
                    ++embeddedCount;
                }
            } else if (c == '}') {
                if (embeddedCount <= 0) continue;
                if (--embeddedCount == 0) {
                    if (expressionStart > -1) {
                        Range range = new Range(expressionStart, i);
                        ranges.add(range);
                    }
                    expressionStart = -1;
                }
            } else if (c == '$') {
                oddDollarCount = !oddDollarCount;
            } else if (c == '\\') {
                ++backslashCount;
            } else {
                oddDollarCount = false;
            }
            lastChar = c;
        }
        return ranges;
    }

    public static void validateExpression(String value, boolean allowSurroundingCharacters) throws AttributeExpressionLanguageParsingException {
        if (!allowSurroundingCharacters) {
            List<Range> ranges = Query.extractExpressionRanges(value);
            if (ranges.size() > 1) {
                throw new AttributeExpressionLanguageParsingException("Found multiple Expressions but expected only 1");
            }
            if (ranges.isEmpty()) {
                throw new AttributeExpressionLanguageParsingException("No Expressions found");
            }
            Range range = ranges.get(0);
            String expression = value.substring(range.getStart(), range.getEnd() + 1);
            Query.compile(expression);
            if (range.getStart() > 0 || range.getEnd() < value.length() - 1) {
                throw new AttributeExpressionLanguageParsingException("Found characters outside of Expression");
            }
        } else {
            for (Range range : Query.extractExpressionRanges(value)) {
                String expression = value.substring(range.getStart(), range.getEnd() + 1);
                Query.compile(expression);
            }
        }
    }

    static int findEndQuoteChar(String value, int quoteStart) {
        char quoteChar = value.charAt(quoteStart);
        int backslashCount = 0;
        char lastChar = '\u0000';
        for (int i = quoteStart + 1; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                ++backslashCount;
            } else if (c == quoteChar && (backslashCount % 2 == 0 || lastChar != '\\')) {
                return i;
            }
            lastChar = c;
        }
        return -1;
    }

    static String evaluateExpression(Tree tree, String queryText, Map<String, String> valueMap, AttributeValueDecorator decorator, Map<String, String> stateVariables) throws ProcessException {
        Object evaluated = Query.fromTree(tree, queryText).evaluate(valueMap, stateVariables).getValue();
        if (evaluated == null) {
            return null;
        }
        String value = evaluated.toString();
        String escaped = value.replace("$$", "$");
        return decorator == null ? escaped : decorator.decorate(escaped);
    }

    static String evaluateExpressions(String rawValue, Map<String, String> expressionMap, AttributeValueDecorator decorator, Map<String, String> stateVariables) throws ProcessException {
        return Query.prepare(rawValue).evaluateExpressions(expressionMap, decorator, stateVariables);
    }

    static String evaluateExpressions(String rawValue, Map<String, String> valueLookup) throws ProcessException {
        return Query.evaluateExpressions(rawValue, valueLookup, null);
    }

    static String evaluateExpressions(String rawValue, Map<String, String> valueLookup, AttributeValueDecorator decorator) throws ProcessException {
        return Query.prepare(rawValue).evaluateExpressions(valueLookup, decorator);
    }

    private static Evaluator<?> getRootSubjectEvaluator(Evaluator<?> evaluator) {
        if (evaluator == null) {
            return null;
        }
        Evaluator<?> subject = evaluator.getSubjectEvaluator();
        if (subject == null) {
            return evaluator;
        }
        return Query.getRootSubjectEvaluator(subject);
    }

    public static String unescape(String value) {
        return value.replaceAll("\\$\\$(?=\\$*\\{.*?\\})", "\\$");
    }

    public static Query fromTree(Tree tree, String text) {
        return new Query(text, tree, Query.buildEvaluator(tree));
    }

    public static Tree compileTree(String query) throws AttributeExpressionLanguageParsingException {
        try {
            CommonTokenStream lexerTokenStream = Query.createTokenStream(query);
            AttributeExpressionParser parser = new AttributeExpressionParser((TokenStream)lexerTokenStream);
            Tree ast = (Tree)parser.query().getTree();
            Tree tree = ast.getChild(0);
            Evaluator<?> evaluator = Query.buildEvaluator(tree);
            Query.verifyMappingEvaluatorReduced(evaluator);
            return tree;
        }
        catch (AttributeExpressionLanguageParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AttributeExpressionLanguageParsingException(e);
        }
    }

    public static PreparedQuery prepare(String query) throws AttributeExpressionLanguageParsingException {
        if (query == null) {
            return new EmptyPreparedQuery(null);
        }
        List<Range> ranges = Query.extractExpressionRanges(query);
        if (ranges.isEmpty()) {
            return new EmptyPreparedQuery(query.replace("$$", "$"));
        }
        try {
            ArrayList<String> substrings = new ArrayList<String>();
            HashMap<String, Tree> trees = new HashMap<String, Tree>();
            int lastIndex = 0;
            for (Range range : ranges) {
                if (range.getStart() > lastIndex) {
                    substrings.add(query.substring(lastIndex, range.getStart()).replace("$$", "$"));
                    lastIndex = range.getEnd() + 1;
                }
                String treeText = query.substring(range.getStart(), range.getEnd() + 1).replace("$$", "$");
                substrings.add(treeText);
                trees.put(treeText, Query.compileTree(treeText));
                lastIndex = range.getEnd() + 1;
            }
            Range lastRange = ranges.get(ranges.size() - 1);
            if (lastRange.getEnd() + 1 < query.length()) {
                String treeText = query.substring(lastRange.getEnd() + 1).replace("$$", "$");
                substrings.add(treeText);
            }
            return new StandardPreparedQuery(substrings, trees);
        }
        catch (AttributeExpressionLanguageParsingException e) {
            return new InvalidPreparedQuery(query, e.getMessage());
        }
    }

    public static Query compile(String query) throws AttributeExpressionLanguageParsingException {
        try {
            CommonTokenStream lexerTokenStream = Query.createTokenStream(query);
            AttributeExpressionParser parser = new AttributeExpressionParser((TokenStream)lexerTokenStream);
            Tree ast = (Tree)parser.query().getTree();
            Tree tree = ast.getChild(0);
            Evaluator<?> evaluator = Query.buildEvaluator(tree);
            Query.verifyMappingEvaluatorReduced(evaluator);
            return new Query(query, tree, evaluator);
        }
        catch (AttributeExpressionLanguageParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AttributeExpressionLanguageParsingException(e);
        }
    }

    private static void verifyMappingEvaluatorReduced(Evaluator<?> evaluator) {
        Evaluator<?> rightMostEvaluator = evaluator instanceof IteratingEvaluator ? ((IteratingEvaluator)evaluator).getLogicEvaluator() : evaluator;
        Evaluator<?> lastEval = rightMostEvaluator;
        for (Evaluator<?> eval = rightMostEvaluator.getSubjectEvaluator(); eval != null; eval = eval.getSubjectEvaluator()) {
            if (eval instanceof ReduceEvaluator) {
                throw new AttributeExpressionLanguageParsingException("Expression attempts to call function '" + lastEval.getToken() + "' on the result of '" + eval.getToken() + "'. This is not allowed. Instead, use \"${literal( ${<embedded expression>} ):" + lastEval.getToken() + "(...)}\"");
            }
            lastEval = eval;
        }
        AttributeExpression.ResultType resultType = evaluator.getResultType();
        if (resultType == AttributeExpression.ResultType.BOOLEAN) {
            return;
        }
        Evaluator<?> rootEvaluator = Query.getRootSubjectEvaluator(evaluator);
        if (rootEvaluator != null && rootEvaluator instanceof MultiAttributeEvaluator) {
            MultiAttributeEvaluator multiAttrEval = (MultiAttributeEvaluator)rootEvaluator;
            switch (multiAttrEval.getEvaluationType()) {
                case 4: 
                case 5: 
                case 6: {
                    if (evaluator instanceof ReduceEvaluator) break;
                    throw new AttributeExpressionLanguageParsingException("Cannot evaluate expression because it attempts to reference multiple attributes but does not use a reducing function");
                }
                default: {
                    throw new AttributeExpressionLanguageParsingException("Cannot evaluate expression because it attempts to reference multiple attributes but does not use a reducing function");
                }
            }
        }
    }

    private static CommonTokenStream createTokenStream(String expression) throws AttributeExpressionLanguageParsingException {
        ANTLRStringStream input = new ANTLRStringStream(expression);
        AttributeExpressionLexer lexer = new AttributeExpressionLexer((CharStream)input);
        return new CommonTokenStream((TokenSource)lexer);
    }

    public AttributeExpression.ResultType getResultType() {
        return this.evaluator.getResultType();
    }

    QueryResult<?> evaluate(Map<String, String> map) {
        return this.evaluate(map, null);
    }

    QueryResult<?> evaluate(Map<String, String> attributes, Map<String, String> stateMap) {
        if (this.evaluated.getAndSet(true)) {
            throw new IllegalStateException("A Query cannot be evaluated more than once");
        }
        if (stateMap != null) {
            AttributesAndState attributesAndState = new AttributesAndState(attributes, stateMap);
            return this.evaluator.evaluate(attributesAndState);
        }
        return this.evaluator.evaluate(attributes);
    }

    Tree getTree() {
        return this.tree;
    }

    public String toString() {
        return "Query [" + this.query + "]";
    }

    private static Evaluator<String> newStringLiteralEvaluator(String literalValue) {
        if (literalValue == null || literalValue.length() < 2) {
            return new StringLiteralEvaluator(literalValue);
        }
        List<Range> ranges = Query.extractExpressionRanges(literalValue);
        if (ranges.isEmpty()) {
            return new StringLiteralEvaluator(literalValue);
        }
        ArrayList evaluators = new ArrayList();
        int lastIndex = 0;
        for (Range range : ranges) {
            if (range.getStart() > lastIndex) {
                evaluators.add(Query.newStringLiteralEvaluator(literalValue.substring(lastIndex, range.getStart())));
            }
            String treeText = literalValue.substring(range.getStart(), range.getEnd() + 1);
            evaluators.add(Query.buildEvaluator(Query.compileTree(treeText)));
            lastIndex = range.getEnd() + 1;
        }
        Range lastRange = ranges.get(ranges.size() - 1);
        if (lastRange.getEnd() + 1 < literalValue.length()) {
            String treeText = literalValue.substring(lastRange.getEnd() + 1);
            evaluators.add(Query.newStringLiteralEvaluator(treeText));
        }
        if (evaluators.size() == 1) {
            return Query.toStringEvaluator((Evaluator)evaluators.get(0));
        }
        AppendEvaluator lastEvaluator = Query.toStringEvaluator((Evaluator)evaluators.get(0));
        for (int i = 1; i < evaluators.size(); ++i) {
            lastEvaluator = new AppendEvaluator(lastEvaluator, Query.toStringEvaluator((Evaluator)evaluators.get(i)));
        }
        return lastEvaluator;
    }

    private static Evaluator<?> buildEvaluator(Tree tree) {
        switch (tree.getType()) {
            case 108: {
                return Query.buildExpressionEvaluator(tree);
            }
            case 106: {
                Evaluator<?> childEvaluator = Query.buildEvaluator(tree.getChild(0));
                if (childEvaluator instanceof MultiAttributeEvaluator) {
                    return childEvaluator;
                }
                return new AttributeEvaluator(Query.toStringEvaluator(childEvaluator));
            }
            case 110: {
                Tree functionTypeTree = tree.getChild(0);
                int multiAttrType = functionTypeTree.getType();
                if (multiAttrType == 9 || multiAttrType == 5) {
                    Evaluator<String> delineatedValueEvaluator = Query.toStringEvaluator(Query.buildEvaluator(tree.getChild(1)));
                    Evaluator<String> delimiterEvaluator = Query.toStringEvaluator(Query.buildEvaluator(tree.getChild(2)));
                    return new DelineatedAttributeEvaluator(delineatedValueEvaluator, delimiterEvaluator, multiAttrType);
                }
                ArrayList<String> attributeNames = new ArrayList<String>();
                for (int i = 1; i < tree.getChildCount(); ++i) {
                    attributeNames.add(Query.newStringLiteralEvaluator(tree.getChild(i).getText()).evaluate(null).getValue());
                }
                switch (multiAttrType) {
                    case 4: {
                        for (String attributeName : attributeNames) {
                            try {
                                FlowFile.KeyValidator.validateKey((String)attributeName);
                            }
                            catch (IllegalArgumentException iae) {
                                throw new AttributeExpressionLanguageParsingException("Invalid Attribute Name: " + attributeName + ". " + iae.getMessage());
                            }
                        }
                        return new MultiNamedAttributeEvaluator(attributeNames, 4);
                    }
                    case 6: {
                        return new MultiMatchAttributeEvaluator(attributeNames, 6);
                    }
                    case 8: {
                        for (String attributeName : attributeNames) {
                            try {
                                FlowFile.KeyValidator.validateKey((String)attributeName);
                            }
                            catch (IllegalArgumentException iae) {
                                throw new AttributeExpressionLanguageParsingException("Invalid Attribute Name: " + attributeName + ". " + iae.getMessage());
                            }
                        }
                        return new MultiNamedAttributeEvaluator(attributeNames, 8);
                    }
                    case 10: {
                        return new MultiMatchAttributeEvaluator(attributeNames, 10);
                    }
                }
                throw new AssertionError((Object)("Illegal Multi-Attribute Reference: " + functionTypeTree.toString()));
            }
            case 107: {
                return Query.newStringLiteralEvaluator(tree.getChild(0).getText());
            }
            case 105: {
                return new WholeNumberLiteralEvaluator(tree.getText());
            }
            case 80: {
                return Query.newStringLiteralEvaluator(tree.getText());
            }
            case 20: {
                return new DecimalLiteralEvaluator(tree.getText());
            }
            case 34: 
            case 95: {
                return Query.buildBooleanEvaluator(tree);
            }
            case 103: {
                return new UuidEvaluator();
            }
            case 65: {
                return new NowEvaluator();
            }
            case 88: {
                Evaluator<?> argEvaluator = Query.buildEvaluator(tree.getChild(0));
                return new ToLiteralEvaluator(argEvaluator);
            }
            case 46: {
                try {
                    return new IPEvaluator();
                }
                catch (UnknownHostException e) {
                    throw new AttributeExpressionLanguageException(e);
                }
            }
            case 42: {
                if (tree.getChildCount() == 0) {
                    try {
                        return new HostnameEvaluator(false);
                    }
                    catch (UnknownHostException e) {
                        throw new AttributeExpressionLanguageException(e);
                    }
                }
                if (tree.getChildCount() == 1) {
                    Tree childTree = tree.getChild(0);
                    try {
                        switch (childTree.getType()) {
                            case 95: {
                                return new HostnameEvaluator(true);
                            }
                            case 34: {
                                return new HostnameEvaluator(false);
                            }
                        }
                        throw new AttributeExpressionLanguageParsingException("Call to hostname() must take 0 or 1 (boolean) parameter");
                    }
                    catch (UnknownHostException e) {
                        throw new AttributeExpressionLanguageException(e);
                    }
                }
                throw new AttributeExpressionLanguageParsingException("Call to hostname() must take 0 or 1 (boolean) parameter");
            }
            case 62: {
                return new OneUpSequenceEvaluator();
            }
            case 70: {
                return new RandomNumberGeneratorEvaluator();
            }
            case 58: {
                if (tree.getChildCount() == 1) {
                    return Query.addToken(new MathEvaluator(null, Query.toStringEvaluator(Query.buildEvaluator(tree.getChild(0))), null), "math");
                }
                throw new AttributeExpressionLanguageParsingException("Call to math() as the subject must take exactly 1 parameter");
            }
            case 39: {
                Tree childTree = tree.getChild(0);
                Evaluator<?> argEvaluator = Query.buildEvaluator(childTree);
                Evaluator<String> stringEvaluator = Query.toStringEvaluator(argEvaluator);
                return new GetStateVariableEvaluator(stringEvaluator);
            }
        }
        throw new AttributeExpressionLanguageParsingException("Unexpected token: " + tree.toString());
    }

    private static <T> Evaluator<T> addToken(Evaluator<T> evaluator, String token) {
        evaluator.setToken(token);
        return evaluator;
    }

    private static Evaluator<Boolean> buildBooleanEvaluator(Tree tree) {
        switch (tree.getType()) {
            case 95: {
                return Query.addToken(new BooleanLiteralEvaluator(true), "true");
            }
            case 34: {
                return Query.addToken(new BooleanLiteralEvaluator(false), "true");
            }
        }
        throw new AttributeExpressionLanguageParsingException("Cannot build Boolean evaluator from tree " + tree.toString());
    }

    private static Evaluator<?> buildExpressionEvaluator(Tree tree) {
        if (tree.getChildCount() == 0) {
            throw new AttributeExpressionLanguageParsingException("EXPRESSION tree node has no children");
        }
        Evaluator<Boolean> evaluator = tree.getChildCount() == 1 ? Query.buildEvaluator(tree.getChild(0)) : Query.buildFunctionExpressionEvaluator(tree, 0);
        Evaluator<Boolean> chosenEvaluator = evaluator;
        Evaluator<?> rootEvaluator = Query.getRootSubjectEvaluator(evaluator);
        if (rootEvaluator != null && rootEvaluator instanceof MultiAttributeEvaluator) {
            MultiAttributeEvaluator multiAttrEval = (MultiAttributeEvaluator)rootEvaluator;
            switch (multiAttrEval.getEvaluationType()) {
                case 8: 
                case 9: 
                case 10: {
                    chosenEvaluator = new AnyAttributeEvaluator((BooleanEvaluator)evaluator, multiAttrEval);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    AttributeExpression.ResultType resultType = evaluator.getResultType();
                    if (resultType == AttributeExpression.ResultType.BOOLEAN) {
                        chosenEvaluator = new AllAttributesEvaluator((BooleanEvaluator)evaluator, multiAttrEval);
                        break;
                    }
                    if (evaluator instanceof ReduceEvaluator) {
                        chosenEvaluator = new MappingEvaluator((ReduceEvaluator)evaluator, multiAttrEval);
                        break;
                    }
                    throw new AttributeExpressionLanguageException("Cannot evaluate Expression because it attempts to reference multiple attributes but does not use a reducing function");
                }
            }
            switch (multiAttrEval.getEvaluationType()) {
                case 8: {
                    chosenEvaluator.setToken("anyAttribute");
                    break;
                }
                case 10: {
                    chosenEvaluator.setToken("anyMatchingAttribute");
                    break;
                }
                case 9: {
                    chosenEvaluator.setToken("anyDelineatedValue");
                    break;
                }
                case 4: {
                    chosenEvaluator.setToken("allAttributes");
                    break;
                }
                case 6: {
                    chosenEvaluator.setToken("allMatchingAttributes");
                    break;
                }
                case 5: {
                    chosenEvaluator.setToken("allDelineatedValues");
                }
            }
        }
        return chosenEvaluator;
    }

    private static Evaluator<?> buildFunctionExpressionEvaluator(Tree tree, int offset) {
        if (tree.getChildCount() == 0) {
            throw new AttributeExpressionLanguageParsingException("EXPRESSION tree node has no children");
        }
        int firstChildIndex = tree.getChildCount() - offset - 1;
        if (firstChildIndex == 0) {
            return Query.buildEvaluator(tree.getChild(0));
        }
        Tree functionTree = tree.getChild(firstChildIndex);
        Evaluator<?> subjectEvaluator = Query.buildFunctionExpressionEvaluator(tree, offset + 1);
        Tree functionNameTree = functionTree.getChild(0);
        ArrayList argEvaluators = new ArrayList();
        for (int i = 1; i < functionTree.getChildCount(); ++i) {
            argEvaluators.add(Query.buildEvaluator(functionTree.getChild(i)));
        }
        return Query.buildFunctionEvaluator(functionNameTree, subjectEvaluator, argEvaluators);
    }

    private static List<Evaluator<?>> verifyArgCount(List<Evaluator<?>> args, int count, String functionName) {
        if (args.size() != count) {
            throw new AttributeExpressionLanguageParsingException(functionName + "() function takes " + count + " arguments");
        }
        return args;
    }

    private static Evaluator<String> toStringEvaluator(Evaluator<?> evaluator) {
        return Query.toStringEvaluator(evaluator, null);
    }

    private static Evaluator<String> toStringEvaluator(Evaluator<?> evaluator, String location) {
        if (evaluator.getResultType() == AttributeExpression.ResultType.STRING) {
            return (StringEvaluator)evaluator;
        }
        return Query.addToken(new StringCastEvaluator(evaluator), evaluator.getToken());
    }

    private static Evaluator<Boolean> toBooleanEvaluator(Evaluator<?> evaluator, String location) {
        switch (evaluator.getResultType()) {
            case BOOLEAN: {
                return evaluator;
            }
            case STRING: {
                return Query.addToken(new BooleanCastEvaluator((StringEvaluator)evaluator), evaluator.getToken());
            }
        }
        throw new AttributeExpressionLanguageParsingException("Cannot implicitly convert Data Type " + evaluator.getResultType() + " to " + AttributeExpression.ResultType.BOOLEAN + (location == null ? "" : " at location [" + location + "]"));
    }

    private static Evaluator<Boolean> toBooleanEvaluator(Evaluator<?> evaluator) {
        return Query.toBooleanEvaluator(evaluator, null);
    }

    private static Evaluator<Long> toWholeNumberEvaluator(Evaluator<?> evaluator) {
        return Query.toWholeNumberEvaluator(evaluator, null);
    }

    private static Evaluator<Long> toWholeNumberEvaluator(Evaluator<?> evaluator, String location) {
        switch (evaluator.getResultType()) {
            case WHOLE_NUMBER: {
                return evaluator;
            }
            case STRING: 
            case DATE: 
            case DECIMAL: 
            case NUMBER: {
                return Query.addToken(new WholeNumberCastEvaluator(evaluator), evaluator.getToken());
            }
        }
        throw new AttributeExpressionLanguageParsingException("Cannot implicitly convert Data Type " + evaluator.getResultType() + " to " + AttributeExpression.ResultType.WHOLE_NUMBER + (location == null ? "" : " at location [" + location + "]"));
    }

    private static Evaluator<Double> toDecimalEvaluator(Evaluator<?> evaluator) {
        return Query.toDecimalEvaluator(evaluator, null);
    }

    private static Evaluator<Double> toDecimalEvaluator(Evaluator<?> evaluator, String location) {
        switch (evaluator.getResultType()) {
            case DECIMAL: {
                return evaluator;
            }
            case STRING: 
            case WHOLE_NUMBER: 
            case DATE: 
            case NUMBER: {
                return Query.addToken(new DecimalCastEvaluator(evaluator), evaluator.getToken());
            }
        }
        throw new AttributeExpressionLanguageParsingException("Cannot implicitly convert Data Type " + evaluator.getResultType() + " to " + AttributeExpression.ResultType.DECIMAL + (location == null ? "" : " at location [" + location + "]"));
    }

    private static Evaluator<Number> toNumberEvaluator(Evaluator<?> evaluator) {
        return Query.toNumberEvaluator(evaluator, null);
    }

    private static Evaluator<Number> toNumberEvaluator(Evaluator<?> evaluator, String location) {
        switch (evaluator.getResultType()) {
            case NUMBER: {
                return evaluator;
            }
            case STRING: 
            case WHOLE_NUMBER: 
            case DATE: 
            case DECIMAL: {
                return Query.addToken(new NumberCastEvaluator(evaluator), evaluator.getToken());
            }
        }
        throw new AttributeExpressionLanguageParsingException("Cannot implicitly convert Data Type " + evaluator.getResultType() + " to " + AttributeExpression.ResultType.WHOLE_NUMBER + (location == null ? "" : " at location [" + location + "]"));
    }

    private static DateEvaluator toDateEvaluator(Evaluator<?> evaluator) {
        return Query.toDateEvaluator(evaluator, null);
    }

    private static DateEvaluator toDateEvaluator(Evaluator<?> evaluator, String location) {
        if (evaluator.getResultType() == AttributeExpression.ResultType.DATE) {
            return (DateEvaluator)evaluator;
        }
        return new DateCastEvaluator(evaluator);
    }

    private static Evaluator<?> buildFunctionEvaluator(Tree tree, Evaluator<?> subjectEvaluator, List<Evaluator<?>> argEvaluators) {
        switch (tree.getType()) {
            case 94: {
                Query.verifyArgCount(argEvaluators, 0, "trim");
                return Query.addToken(new TrimEvaluator(Query.toStringEvaluator(subjectEvaluator)), "trim");
            }
            case 92: {
                Query.verifyArgCount(argEvaluators, 0, "toString");
                return Query.addToken(new ToStringEvaluator(subjectEvaluator), "toString");
            }
            case 89: {
                Query.verifyArgCount(argEvaluators, 0, "toLower");
                return Query.addToken(new ToLowerEvaluator(Query.toStringEvaluator(subjectEvaluator)), "toLower");
            }
            case 93: {
                Query.verifyArgCount(argEvaluators, 0, "toUpper");
                return Query.addToken(new ToUpperEvaluator(Query.toStringEvaluator(subjectEvaluator)), "toUpper");
            }
            case 102: {
                Query.verifyArgCount(argEvaluators, 0, "urlEncode");
                return Query.addToken(new UrlEncodeEvaluator(Query.toStringEvaluator(subjectEvaluator)), "urlEncode");
            }
            case 101: {
                Query.verifyArgCount(argEvaluators, 0, "urlDecode");
                return Query.addToken(new UrlDecodeEvaluator(Query.toStringEvaluator(subjectEvaluator)), "urlDecode");
            }
            case 14: {
                Query.verifyArgCount(argEvaluators, 0, "base64Encode");
                return Query.addToken(new Base64EncodeEvaluator(Query.toStringEvaluator(subjectEvaluator)), "base64Encode");
            }
            case 13: {
                Query.verifyArgCount(argEvaluators, 0, "base64Decode");
                return Query.addToken(new Base64DecodeEvaluator(Query.toStringEvaluator(subjectEvaluator)), "base64Decode");
            }
            case 28: {
                Query.verifyArgCount(argEvaluators, 0, "escapeCsv");
                return Query.addToken(CharSequenceTranslatorEvaluator.csvEscapeEvaluator(Query.toStringEvaluator(subjectEvaluator)), "escapeJson");
            }
            case 29: {
                Query.verifyArgCount(argEvaluators, 0, "escapeHtml3");
                return Query.addToken(CharSequenceTranslatorEvaluator.html3EscapeEvaluator(Query.toStringEvaluator(subjectEvaluator)), "escapeJson");
            }
            case 30: {
                Query.verifyArgCount(argEvaluators, 0, "escapeHtml4");
                return Query.addToken(CharSequenceTranslatorEvaluator.html4EscapeEvaluator(Query.toStringEvaluator(subjectEvaluator)), "escapeJson");
            }
            case 31: {
                Query.verifyArgCount(argEvaluators, 0, "escapeJson");
                return Query.addToken(CharSequenceTranslatorEvaluator.jsonEscapeEvaluator(Query.toStringEvaluator(subjectEvaluator)), "escapeJson");
            }
            case 32: {
                Query.verifyArgCount(argEvaluators, 0, "escapeXml");
                return Query.addToken(CharSequenceTranslatorEvaluator.xmlEscapeEvaluator(Query.toStringEvaluator(subjectEvaluator)), "escapeJson");
            }
            case 96: {
                Query.verifyArgCount(argEvaluators, 0, "unescapeCsv");
                return Query.addToken(CharSequenceTranslatorEvaluator.csvUnescapeEvaluator(Query.toStringEvaluator(subjectEvaluator)), "escapeJson");
            }
            case 97: {
                Query.verifyArgCount(argEvaluators, 0, "unescapeHtml3");
                return Query.addToken(CharSequenceTranslatorEvaluator.html3UnescapeEvaluator(Query.toStringEvaluator(subjectEvaluator)), "escapeJson");
            }
            case 98: {
                Query.verifyArgCount(argEvaluators, 0, "unescapeHtml4");
                return Query.addToken(CharSequenceTranslatorEvaluator.html4UnescapeEvaluator(Query.toStringEvaluator(subjectEvaluator)), "escapeJson");
            }
            case 99: {
                Query.verifyArgCount(argEvaluators, 0, "unescapeJson");
                return Query.addToken(CharSequenceTranslatorEvaluator.jsonUnescapeEvaluator(Query.toStringEvaluator(subjectEvaluator)), "escapeJson");
            }
            case 100: {
                Query.verifyArgCount(argEvaluators, 0, "unescapeXml");
                return Query.addToken(CharSequenceTranslatorEvaluator.xmlUnescapeEvaluator(Query.toStringEvaluator(subjectEvaluator)), "escapeJson");
            }
            case 84: {
                Query.verifyArgCount(argEvaluators, 1, "substringBefore");
                return Query.addToken(new SubstringBeforeEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to substringBefore")), "substringBefore");
            }
            case 85: {
                Query.verifyArgCount(argEvaluators, 1, "substringBeforeLast");
                return Query.addToken(new SubstringBeforeLastEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to substringBeforeLast")), "substringBeforeLast");
            }
            case 82: {
                Query.verifyArgCount(argEvaluators, 1, "substringAfter");
                return Query.addToken(new SubstringAfterEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to substringAfter")), "substringAfter");
            }
            case 83: {
                Query.verifyArgCount(argEvaluators, 1, "substringAfterLast");
                return Query.addToken(new SubstringAfterLastEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to substringAfterLast")), "substringAfterLast");
            }
            case 76: {
                Query.verifyArgCount(argEvaluators, 1, "replaceNull");
                return Query.addToken(new ReplaceNullEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to replaceNull")), "replaceNull");
            }
            case 74: {
                Query.verifyArgCount(argEvaluators, 1, "replaceEmtpy");
                return Query.addToken(new ReplaceEmptyEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to replaceEmpty")), "replaceEmpty");
            }
            case 72: {
                Query.verifyArgCount(argEvaluators, 2, "replace");
                return Query.addToken(new ReplaceEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to replace"), Query.toStringEvaluator(argEvaluators.get(1), "second argument to replace")), "replace");
            }
            case 75: {
                Query.verifyArgCount(argEvaluators, 2, "replaceFirst");
                return Query.addToken(new ReplaceFirstEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to replaceFirst"), Query.toStringEvaluator(argEvaluators.get(1), "second argument to replaceFirst")), "replaceFirst");
            }
            case 73: {
                Query.verifyArgCount(argEvaluators, 2, "replaceAll");
                return Query.addToken(new ReplaceAllEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to replaceAll"), Query.toStringEvaluator(argEvaluators.get(1), "second argument to replaceAll")), "replaceAll");
            }
            case 11: {
                Query.verifyArgCount(argEvaluators, 1, "append");
                return Query.addToken(new AppendEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to append")), "append");
            }
            case 69: {
                Query.verifyArgCount(argEvaluators, 1, "prepend");
                return Query.addToken(new PrependEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to prepend")), "prepend");
            }
            case 81: {
                int numArgs = argEvaluators.size();
                if (numArgs == 1) {
                    return Query.addToken(new SubstringEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toWholeNumberEvaluator(argEvaluators.get(0), "first argument to substring")), "substring");
                }
                if (numArgs == 2) {
                    return Query.addToken(new SubstringEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toWholeNumberEvaluator(argEvaluators.get(0), "first argument to substring"), Query.toWholeNumberEvaluator(argEvaluators.get(1), "second argument to substring")), "substring");
                }
                throw new AttributeExpressionLanguageParsingException("substring() function can take either 1 or 2 arguments but cannot take " + numArgs + " arguments");
            }
            case 49: {
                Query.verifyArgCount(argEvaluators, 1, "join");
                return Query.addToken(new JoinEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0))), "join");
            }
            case 19: {
                Query.verifyArgCount(argEvaluators, 0, "count");
                return Query.addToken(new CountEvaluator(subjectEvaluator), "count");
            }
            case 48: {
                Query.verifyArgCount(argEvaluators, 0, "isNull");
                return Query.addToken(new IsNullEvaluator(Query.toStringEvaluator(subjectEvaluator)), "isNull");
            }
            case 47: {
                Query.verifyArgCount(argEvaluators, 0, "isEmpty");
                return Query.addToken(new IsEmptyEvaluator(Query.toStringEvaluator(subjectEvaluator)), "isEmpty");
            }
            case 64: {
                Query.verifyArgCount(argEvaluators, 0, "notNull");
                return Query.addToken(new NotNullEvaluator(Query.toStringEvaluator(subjectEvaluator)), "notNull");
            }
            case 79: {
                Query.verifyArgCount(argEvaluators, 1, "startsWith");
                return Query.addToken(new StartsWithEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to startsWith")), "startsWith");
            }
            case 24: {
                Query.verifyArgCount(argEvaluators, 1, "endsWith");
                return Query.addToken(new EndsWithEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to endsWith")), "endsWith");
            }
            case 18: {
                Query.verifyArgCount(argEvaluators, 1, "contains");
                return Query.addToken(new ContainsEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to contains")), "contains");
            }
            case 44: {
                ArrayList<Evaluator<String>> list = new ArrayList<Evaluator<String>>();
                for (int i = 0; i < argEvaluators.size(); ++i) {
                    list.add(Query.toStringEvaluator(argEvaluators.get(i), i + "th argument to in"));
                }
                return Query.addToken(new InEvaluator(Query.toStringEvaluator(subjectEvaluator), list), "in");
            }
            case 35: {
                Query.verifyArgCount(argEvaluators, 1, "find");
                return Query.addToken(new FindEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to find")), "find");
            }
            case 57: {
                Query.verifyArgCount(argEvaluators, 1, "matches");
                return Query.addToken(new MatchesEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to matches")), "matches");
            }
            case 25: {
                Query.verifyArgCount(argEvaluators, 1, "equals");
                return Query.addToken(new EqualsEvaluator(subjectEvaluator, argEvaluators.get(0)), "equals");
            }
            case 26: {
                Query.verifyArgCount(argEvaluators, 1, "equalsIgnoreCase");
                return Query.addToken(new EqualsIgnoreCaseEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to equalsIgnoreCase")), "equalsIgnoreCase");
            }
            case 40: {
                Query.verifyArgCount(argEvaluators, 1, "gt");
                return Query.addToken(new GreaterThanEvaluator(Query.toNumberEvaluator(subjectEvaluator), Query.toNumberEvaluator(argEvaluators.get(0), "first argument to gt")), "gt");
            }
            case 41: {
                Query.verifyArgCount(argEvaluators, 1, "ge");
                return Query.addToken(new GreaterThanOrEqualEvaluator(Query.toNumberEvaluator(subjectEvaluator), Query.toNumberEvaluator(argEvaluators.get(0), "first argument to ge")), "ge");
            }
            case 54: {
                Query.verifyArgCount(argEvaluators, 1, "lt");
                return Query.addToken(new LessThanEvaluator(Query.toNumberEvaluator(subjectEvaluator), Query.toNumberEvaluator(argEvaluators.get(0), "first argument to lt")), "lt");
            }
            case 55: {
                Query.verifyArgCount(argEvaluators, 1, "le");
                return Query.addToken(new LessThanOrEqualEvaluator(Query.toNumberEvaluator(subjectEvaluator), Query.toNumberEvaluator(argEvaluators.get(0), "first argument to le")), "le");
            }
            case 53: {
                Query.verifyArgCount(argEvaluators, 0, "length");
                return Query.addToken(new LengthEvaluator(Query.toStringEvaluator(subjectEvaluator)), "length");
            }
            case 86: {
                if (argEvaluators.isEmpty()) {
                    return Query.addToken(new NumberToDateEvaluator(Query.toWholeNumberEvaluator(subjectEvaluator)), "toDate");
                }
                if (subjectEvaluator.getResultType() == AttributeExpression.ResultType.STRING && argEvaluators.size() == 1) {
                    return Query.addToken(new StringToDateEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0)), null), "toDate");
                }
                if (subjectEvaluator.getResultType() == AttributeExpression.ResultType.STRING && argEvaluators.size() == 2) {
                    return Query.addToken(new StringToDateEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0)), Query.toStringEvaluator(argEvaluators.get(1))), "toDate");
                }
                return Query.addToken(new NumberToDateEvaluator(Query.toWholeNumberEvaluator(subjectEvaluator)), "toDate");
            }
            case 90: {
                Query.verifyArgCount(argEvaluators, 0, "toNumber");
                switch (subjectEvaluator.getResultType()) {
                    case STRING: 
                    case WHOLE_NUMBER: 
                    case DATE: 
                    case DECIMAL: 
                    case NUMBER: {
                        return Query.addToken(Query.toWholeNumberEvaluator(subjectEvaluator), "toNumber");
                    }
                }
                throw new AttributeExpressionLanguageParsingException(subjectEvaluator + " returns type " + subjectEvaluator.getResultType() + " but expected to get " + AttributeExpression.ResultType.STRING + ", " + AttributeExpression.ResultType.DECIMAL + ", or " + AttributeExpression.ResultType.DATE);
            }
            case 87: {
                Query.verifyArgCount(argEvaluators, 0, "toDecimal");
                switch (subjectEvaluator.getResultType()) {
                    case STRING: 
                    case WHOLE_NUMBER: 
                    case DATE: 
                    case DECIMAL: 
                    case NUMBER: {
                        return Query.addToken(Query.toDecimalEvaluator(subjectEvaluator), "toDecimal");
                    }
                }
                throw new AttributeExpressionLanguageParsingException(subjectEvaluator + " returns type " + subjectEvaluator.getResultType() + " but expected to get " + AttributeExpression.ResultType.STRING + ", " + AttributeExpression.ResultType.WHOLE_NUMBER + ", or " + AttributeExpression.ResultType.DATE);
            }
            case 91: {
                if (argEvaluators.size() == 1) {
                    return Query.addToken(new ToRadixEvaluator(Query.toWholeNumberEvaluator(subjectEvaluator), Query.toWholeNumberEvaluator(argEvaluators.get(0))), "toRadix");
                }
                return Query.addToken(new ToRadixEvaluator(Query.toWholeNumberEvaluator(subjectEvaluator), Query.toWholeNumberEvaluator(argEvaluators.get(0)), Query.toWholeNumberEvaluator(argEvaluators.get(1))), "toRadix");
            }
            case 37: {
                return Query.addToken(new FromRadixEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toWholeNumberEvaluator(argEvaluators.get(0))), "fromRadix");
            }
            case 60: {
                return Query.addToken(new ModEvaluator(Query.toNumberEvaluator(subjectEvaluator), Query.toNumberEvaluator(argEvaluators.get(0))), "mod");
            }
            case 68: {
                return Query.addToken(new PlusEvaluator(Query.toNumberEvaluator(subjectEvaluator), Query.toNumberEvaluator(argEvaluators.get(0))), "plus");
            }
            case 59: {
                return Query.addToken(new MinusEvaluator(Query.toNumberEvaluator(subjectEvaluator), Query.toNumberEvaluator(argEvaluators.get(0))), "minus");
            }
            case 61: {
                return Query.addToken(new MultiplyEvaluator(Query.toNumberEvaluator(subjectEvaluator), Query.toNumberEvaluator(argEvaluators.get(0))), "multiply");
            }
            case 21: {
                return Query.addToken(new DivideEvaluator(Query.toNumberEvaluator(subjectEvaluator), Query.toNumberEvaluator(argEvaluators.get(0))), "divide");
            }
            case 58: {
                if (argEvaluators.size() == 1) {
                    return Query.addToken(new MathEvaluator(Query.toNumberEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0)), null), "math");
                }
                if (argEvaluators.size() == 2) {
                    return Query.addToken(new MathEvaluator(Query.toNumberEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0)), Query.toNumberEvaluator(argEvaluators.get(1))), "math");
                }
                throw new AttributeExpressionLanguageParsingException("math() function takes 1 or 2 arguments");
            }
            case 70: {
                return Query.addToken(new RandomNumberGeneratorEvaluator(), "random");
            }
            case 45: {
                Query.verifyArgCount(argEvaluators, 1, "indexOf");
                return Query.addToken(new IndexOfEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to indexOf")), "indexOf");
            }
            case 51: {
                Query.verifyArgCount(argEvaluators, 1, "lastIndexOf");
                return Query.addToken(new LastIndexOfEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to lastIndexOf")), "lastIndexOf");
            }
            case 36: {
                if (argEvaluators.size() == 1) {
                    return Query.addToken(new FormatEvaluator(Query.toDateEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument of format"), null), "format");
                }
                if (argEvaluators.size() == 2) {
                    return Query.addToken(new FormatEvaluator(Query.toDateEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0)), Query.toStringEvaluator(argEvaluators.get(1))), "format");
                }
                throw new AttributeExpressionLanguageParsingException("format() function takes 1 or 2 arguments");
            }
            case 67: {
                return Query.addToken(new OrEvaluator(Query.toBooleanEvaluator(subjectEvaluator), Query.toBooleanEvaluator(argEvaluators.get(0))), "or");
            }
            case 7: {
                return Query.addToken(new AndEvaluator(Query.toBooleanEvaluator(subjectEvaluator), Query.toBooleanEvaluator(argEvaluators.get(0))), "and");
            }
            case 63: {
                return Query.addToken(new NotEvaluator(Query.toBooleanEvaluator(subjectEvaluator)), "not");
            }
            case 38: {
                if (argEvaluators.size() == 1) {
                    return Query.addToken(new GetDelimitedFieldEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toWholeNumberEvaluator(argEvaluators.get(0), "first argument of getDelimitedField")), "getDelimitedField");
                }
                if (argEvaluators.size() == 2) {
                    return Query.addToken(new GetDelimitedFieldEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toWholeNumberEvaluator(argEvaluators.get(0), "first argument of getDelimitedField"), Query.toStringEvaluator(argEvaluators.get(1), "second argument of getDelimitedField")), "getDelimitedField");
                }
                if (argEvaluators.size() == 3) {
                    return Query.addToken(new GetDelimitedFieldEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toWholeNumberEvaluator(argEvaluators.get(0), "first argument of getDelimitedField"), Query.toStringEvaluator(argEvaluators.get(1), "second argument of getDelimitedField"), Query.toStringEvaluator(argEvaluators.get(2), "third argument of getDelimitedField")), "getDelimitedField");
                }
                if (argEvaluators.size() == 4) {
                    return Query.addToken(new GetDelimitedFieldEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toWholeNumberEvaluator(argEvaluators.get(0), "first argument of getDelimitedField"), Query.toStringEvaluator(argEvaluators.get(1), "second argument of getDelimitedField"), Query.toStringEvaluator(argEvaluators.get(2), "third argument of getDelimitedField"), Query.toStringEvaluator(argEvaluators.get(3), "fourth argument of getDelimitedField")), "getDelimitedField");
                }
                return Query.addToken(new GetDelimitedFieldEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toWholeNumberEvaluator(argEvaluators.get(0), "first argument of getDelimitedField"), Query.toStringEvaluator(argEvaluators.get(1), "second argument of getDelimitedField"), Query.toStringEvaluator(argEvaluators.get(2), "third argument of getDelimitedField"), Query.toStringEvaluator(argEvaluators.get(3), "fourth argument of getDelimitedField"), Query.toBooleanEvaluator(argEvaluators.get(4), "fifth argument of getDelimitedField")), "getDelimitedField");
            }
            case 50: {
                Query.verifyArgCount(argEvaluators, 1, "jsonPath");
                return Query.addToken(new JsonPathEvaluator(Query.toStringEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "first argument to jsonPath")), "jsonPath");
            }
            case 43: {
                Query.verifyArgCount(argEvaluators, 2, "ifElse");
                return Query.addToken(new IfElseEvaluator(Query.toBooleanEvaluator(subjectEvaluator), Query.toStringEvaluator(argEvaluators.get(0), "argument to return if true"), Query.toStringEvaluator(argEvaluators.get(1), "argument to return if false")), "ifElse");
            }
        }
        throw new AttributeExpressionLanguageParsingException("Expected a Function-type expression but got " + tree.toString());
    }

    public static class Range {
        private final int start;
        private final int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String toString() {
            return this.start + " - " + this.end;
        }
    }
}

