/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.literals.StringLiteralEvaluator;

public class MatchesEvaluator
extends BooleanEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> search;
    private final Pattern compiledPattern;

    public MatchesEvaluator(Evaluator<String> subject, Evaluator<String> search) {
        this.subject = subject;
        this.search = search;
        this.compiledPattern = search instanceof StringLiteralEvaluator ? Pattern.compile(search.evaluate(null).getValue()) : null;
    }

    @Override
    public QueryResult<Boolean> evaluate(Map<String, String> attributes) {
        String subjectValue = this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new BooleanQueryResult(false);
        }
        Pattern pattern = this.compiledPattern == null ? Pattern.compile(this.search.evaluate(attributes).getValue()) : this.compiledPattern;
        boolean matches = pattern.matcher(subjectValue).matches();
        return new BooleanQueryResult(matches);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

