/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.flow;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.cluster.coordination.flow.PopularVoteFlowElection;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.encrypt.PropertyEncryptorFactory;
import org.apache.nifi.encrypt.SensitiveValueEncoder;
import org.apache.nifi.encrypt.StandardSensitiveValueEncoder;
import org.apache.nifi.fingerprint.FingerprintFactory;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class PopularVoteFlowElectionFactoryBean
implements FactoryBean<PopularVoteFlowElection> {
    private static final Logger logger = LoggerFactory.getLogger(PopularVoteFlowElectionFactoryBean.class);
    private NiFiProperties properties;
    private ExtensionManager extensionManager;

    public PopularVoteFlowElection getObject() {
        long maxWaitMillis;
        String maxWaitTime = this.properties.getFlowElectionMaxWaitTime();
        try {
            maxWaitMillis = FormatUtils.getTimeDuration((String)maxWaitTime, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.warn("Failed to parse value of property '{}' as a valid time period. Value was '{}'. Ignoring this value and using the default value of '{}'", new Object[]{"nifi.cluster.flow.election.max.wait.time", maxWaitTime, "5 mins"});
            maxWaitMillis = FormatUtils.getTimeDuration((String)"5 mins", (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Integer maxNodes = this.properties.getFlowElectionMaxCandidates();
        PropertyEncryptor encryptor = PropertyEncryptorFactory.getPropertyEncryptor((NiFiProperties)this.properties);
        StandardSensitiveValueEncoder sensitiveValueEncoder = new StandardSensitiveValueEncoder(this.properties);
        FingerprintFactory fingerprintFactory = new FingerprintFactory(encryptor, this.extensionManager, (SensitiveValueEncoder)sensitiveValueEncoder);
        return new PopularVoteFlowElection(maxWaitMillis, TimeUnit.MILLISECONDS, maxNodes, fingerprintFactory);
    }

    public Class<?> getObjectType() {
        return PopularVoteFlowElection.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }
}

