/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.ProcessGroupsEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupsEntity;

public class ProcessGroupsEndpointMerger
implements EndpointResponseMerger {
    public static final Pattern PROCESS_GROUPS_URI_PATTERN = Pattern.compile("/nifi-api/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/process-groups");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && PROCESS_GROUPS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    public final NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + uri + ", HTTP Method " + method);
        }
        ProcessGroupsEntity responseEntity = (ProcessGroupsEntity)clientResponse.getClientResponse().readEntity(ProcessGroupsEntity.class);
        Set processGroupEntities = responseEntity.getProcessGroups();
        HashMap<String, Map<NodeIdentifier, ProcessGroupEntity>> entityMap = new HashMap<String, Map<NodeIdentifier, ProcessGroupEntity>>();
        for (NodeResponse nodeResponse : successfulResponses) {
            ProcessGroupsEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ProcessGroupsEntity)nodeResponse.getClientResponse().readEntity(ProcessGroupsEntity.class);
            Set nodeProcessGroupEntities = nodeResponseEntity.getProcessGroups();
            for (ProcessGroupEntity nodeProcessGroupEntity : nodeProcessGroupEntities) {
                NodeIdentifier nodeId = nodeResponse.getNodeId();
                HashMap<NodeIdentifier, ProcessGroupEntity> innerMap = (HashMap<NodeIdentifier, ProcessGroupEntity>)entityMap.get(nodeId);
                if (innerMap == null) {
                    innerMap = new HashMap<NodeIdentifier, ProcessGroupEntity>();
                    entityMap.put(nodeProcessGroupEntity.getId(), innerMap);
                }
                innerMap.put(nodeResponse.getNodeId(), nodeProcessGroupEntity);
            }
        }
        ProcessGroupsEntityMerger.mergeProcessGroups(processGroupEntities, entityMap);
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

