/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.web.api.dto.provenance.ProvenanceDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceEventDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceRequestDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceResultsDTO;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.ProvenanceEntity;

public class ProvenanceQueryEndpointMerger
implements EndpointResponseMerger {
    public static final String PROVENANCE_URI = "/nifi-api/provenance";
    public static final Pattern PROVENANCE_QUERY_URI = Pattern.compile("/nifi-api/provenance/[a-f0-9\\-]{36}");

    @Override
    public boolean canHandle(URI uri, String method) {
        if ("POST".equalsIgnoreCase(method) && PROVENANCE_URI.equals(uri.getPath())) {
            return true;
        }
        return "GET".equalsIgnoreCase(method) && PROVENANCE_QUERY_URI.matcher(uri.getPath()).matches();
    }

    @Override
    public NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + uri + ", HTTP Method " + method);
        }
        ProvenanceEntity responseEntity = (ProvenanceEntity)clientResponse.getClientResponse().readEntity(ProvenanceEntity.class);
        ProvenanceDTO dto = responseEntity.getProvenance();
        HashMap<NodeIdentifier, ProvenanceDTO> dtoMap = new HashMap<NodeIdentifier, ProvenanceDTO>();
        for (NodeResponse nodeResponse : successfulResponses) {
            ProvenanceEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ProvenanceEntity)nodeResponse.getClientResponse().readEntity(ProvenanceEntity.class);
            ProvenanceDTO nodeDto = nodeResponseEntity.getProvenance();
            dtoMap.put(nodeResponse.getNodeId(), nodeDto);
        }
        this.mergeResponses(dto, dtoMap, successfulResponses, problematicResponses);
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }

    protected void mergeResponses(ProvenanceDTO clientDto, Map<NodeIdentifier, ProvenanceDTO> dtoMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        ProvenanceResultsDTO results = clientDto.getResults();
        ProvenanceRequestDTO request = clientDto.getRequest();
        ArrayList<ProvenanceEventDTO> allResults = new ArrayList<ProvenanceEventDTO>(1024);
        HashSet<String> errors = new HashSet<String>();
        Date oldestEventDate = new Date();
        int percentageComplete = 0;
        boolean finished = true;
        long totalRecords = 0L;
        for (Map.Entry<NodeIdentifier, ProvenanceDTO> entry : dtoMap.entrySet()) {
            NodeIdentifier nodeIdentifier = entry.getKey();
            String nodeAddress = nodeIdentifier.getApiAddress() + ":" + nodeIdentifier.getApiPort();
            ProvenanceDTO nodeDto = entry.getValue();
            ProvenanceResultsDTO nodeResultDto = nodeDto.getResults();
            if (nodeResultDto != null && nodeResultDto.getProvenanceEvents() != null) {
                totalRecords += nodeResultDto.getTotalCount().longValue();
                for (ProvenanceEventDTO eventDto : nodeResultDto.getProvenanceEvents()) {
                    if (eventDto.getClusterNodeId() == null || eventDto.getClusterNodeAddress() == null) {
                        eventDto.setClusterNodeId(nodeIdentifier.getId());
                        eventDto.setClusterNodeAddress(nodeAddress);
                        eventDto.setId(nodeIdentifier.getId() + eventDto.getId());
                    }
                    allResults.add(eventDto);
                }
            }
            if (nodeResultDto.getOldestEvent() != null && nodeResultDto.getOldestEvent().before(oldestEventDate)) {
                oldestEventDate = nodeResultDto.getOldestEvent();
            }
            if (nodeResultDto.getErrors() != null) {
                for (String error : nodeResultDto.getErrors()) {
                    errors.add(nodeAddress + " -- " + error);
                }
            }
            percentageComplete += nodeDto.getPercentCompleted().intValue();
            if (nodeDto.isFinished().booleanValue()) continue;
            finished = false;
        }
        percentageComplete /= dtoMap.size();
        for (NodeResponse problematicResponse : problematicResponses) {
            NodeIdentifier problemNode = problematicResponse.getNodeId();
            String problemNodeAddress = problemNode.getApiAddress() + ":" + problemNode.getApiPort();
            errors.add(String.format("%s -- Request did not complete successfully (Status code: %s)", problemNodeAddress, problematicResponse.getStatus()));
        }
        Collections.sort(allResults, new Comparator<ProvenanceEventDTO>(){

            @Override
            public int compare(ProvenanceEventDTO o1, ProvenanceEventDTO o2) {
                int eventTimeComparison = o1.getEventTime().compareTo(o2.getEventTime());
                if (eventTimeComparison != 0) {
                    return -eventTimeComparison;
                }
                String nodeId1 = o1.getClusterNodeId();
                String nodeId2 = o2.getClusterNodeId();
                int nodeIdComparison = nodeId1 == null && nodeId2 == null ? 0 : (nodeId1 == null ? 1 : (nodeId2 == null ? -1 : -nodeId1.compareTo(nodeId2)));
                if (nodeIdComparison != 0) {
                    return nodeIdComparison;
                }
                return -Long.compare(o1.getEventId(), o2.getEventId());
            }
        });
        int maxResults = request.getMaxResults();
        List<Object> selectedResults = allResults.size() < maxResults ? allResults : allResults.subList(0, maxResults);
        if (errors.size() > 0) {
            results.setErrors(errors);
        }
        if (clientDto.getRequest().getMaxResults() != null && totalRecords >= (long)clientDto.getRequest().getMaxResults().intValue()) {
            results.setTotalCount(Long.valueOf(clientDto.getRequest().getMaxResults().longValue()));
            results.setTotal(FormatUtils.formatCount((long)clientDto.getRequest().getMaxResults().longValue()) + "+");
        } else {
            results.setTotal(FormatUtils.formatCount((long)totalRecords));
            results.setTotalCount(Long.valueOf(totalRecords));
        }
        results.setProvenanceEvents(selectedResults);
        results.setOldestEvent(oldestEventDate);
        results.setGenerated(new Date());
        clientDto.setPercentCompleted(Integer.valueOf(percentageComplete));
        clientDto.setFinished(Boolean.valueOf(finished));
    }
}

