/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.cluster.manager.ComponentEntityMerger;
import org.apache.nifi.cluster.manager.PermissionsDtoMerger;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.diagnostics.ConnectionDiagnosticsDTO;
import org.apache.nifi.web.api.dto.diagnostics.ConnectionDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.diagnostics.ControllerServiceDiagnosticsDTO;
import org.apache.nifi.web.api.dto.diagnostics.JVMDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.diagnostics.LocalQueuePartitionDTO;
import org.apache.nifi.web.api.dto.diagnostics.NodeJVMDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.diagnostics.ProcessorDiagnosticsDTO;
import org.apache.nifi.web.api.dto.diagnostics.RemoteQueuePartitionDTO;
import org.apache.nifi.web.api.dto.diagnostics.ThreadDumpDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ProcessorDiagnosticsEntity;

public class ProcessorDiagnosticsEntityMerger
implements ComponentEntityMerger<ProcessorDiagnosticsEntity> {
    private final long componentStatusSnapshotMillis;

    public ProcessorDiagnosticsEntityMerger(long componentStatusSnapshotMillis) {
        this.componentStatusSnapshotMillis = componentStatusSnapshotMillis;
    }

    @Override
    public void mergeComponents(ProcessorDiagnosticsEntity clientEntity, Map<NodeIdentifier, ProcessorDiagnosticsEntity> entityMap) {
        ProcessorDiagnosticsDTO clientDto = clientEntity.getComponent();
        ArrayList<NodeJVMDiagnosticsSnapshotDTO> nodeJvmDiagnosticsSnapshots = new ArrayList<NodeJVMDiagnosticsSnapshotDTO>(entityMap.size());
        this.mergeConnectionDiagnostics(clientEntity, entityMap, entity -> entity.getComponent().getIncomingConnections());
        this.mergeConnectionDiagnostics(clientEntity, entityMap, entity -> entity.getComponent().getOutgoingConnections());
        for (Map.Entry<NodeIdentifier, ProcessorDiagnosticsEntity> entry : entityMap.entrySet()) {
            NodeIdentifier nodeIdentifier = entry.getKey();
            ProcessorDiagnosticsEntity diagnosticsEntity = entry.getValue();
            ProcessorDiagnosticsDTO diagnosticsDto = diagnosticsEntity.getComponent();
            StatusMerger.merge(clientDto.getProcessorStatus(), (boolean)clientEntity.getPermissions().getCanRead(), diagnosticsDto.getProcessorStatus(), (boolean)diagnosticsEntity.getPermissions().getCanRead(), nodeIdentifier.getId(), nodeIdentifier.getApiAddress(), (Integer)nodeIdentifier.getApiPort());
            NodeJVMDiagnosticsSnapshotDTO nodeJvmDiagnosticsSnapshot = new NodeJVMDiagnosticsSnapshotDTO();
            nodeJvmDiagnosticsSnapshot.setAddress(nodeIdentifier.getApiAddress());
            nodeJvmDiagnosticsSnapshot.setApiPort(Integer.valueOf(nodeIdentifier.getApiPort()));
            nodeJvmDiagnosticsSnapshot.setNodeId(nodeIdentifier.getId());
            nodeJvmDiagnosticsSnapshot.setSnapshot(diagnosticsDto.getJvmDiagnostics().getAggregateSnapshot());
            nodeJvmDiagnosticsSnapshots.add(nodeJvmDiagnosticsSnapshot);
        }
        clientDto.getJvmDiagnostics().setNodeSnapshots(nodeJvmDiagnosticsSnapshots);
        JVMDiagnosticsSnapshotDTO mergedJvmDiagnosticsSnapshot = clientDto.getJvmDiagnostics().getAggregateSnapshot().clone();
        for (Map.Entry<NodeIdentifier, ProcessorDiagnosticsEntity> entry : entityMap.entrySet()) {
            NodeIdentifier nodeId = entry.getKey();
            ProcessorDiagnosticsEntity diagnosticsEntity = entry.getValue();
            if (diagnosticsEntity == clientEntity) {
                for (ThreadDumpDTO threadDump : clientDto.getThreadDumps()) {
                    threadDump.setNodeAddress(nodeId.getApiAddress());
                    threadDump.setApiPort(Integer.valueOf(nodeId.getApiPort()));
                    threadDump.setNodeId(nodeId.getId());
                }
                continue;
            }
            ProcessorDiagnosticsDTO diagnosticsDto = diagnosticsEntity.getComponent();
            JVMDiagnosticsSnapshotDTO snapshot = diagnosticsDto.getJvmDiagnostics().getAggregateSnapshot();
            StatusMerger.merge(mergedJvmDiagnosticsSnapshot, snapshot, this.componentStatusSnapshotMillis);
            List threadDumps = diagnosticsEntity.getComponent().getThreadDumps();
            for (ThreadDumpDTO threadDump : threadDumps) {
                threadDump.setNodeAddress(nodeId.getApiAddress());
                threadDump.setApiPort(Integer.valueOf(nodeId.getApiPort()));
                threadDump.setNodeId(nodeId.getId());
                clientDto.getThreadDumps().add(threadDump);
            }
        }
        clientDto.getJvmDiagnostics().setAggregateSnapshot(mergedJvmDiagnosticsSnapshot);
        Map map = clientDto.getReferencedControllerServices().stream().map(ControllerServiceDiagnosticsDTO::getControllerService).collect(Collectors.toMap(ComponentEntity::getId, Function.identity()));
        for (Map.Entry<NodeIdentifier, ProcessorDiagnosticsEntity> entry : entityMap.entrySet()) {
            ProcessorDiagnosticsEntity procDiagnostics = entry.getValue();
            Set serviceDtos = procDiagnostics.getComponent().getReferencedControllerServices();
            for (ControllerServiceDiagnosticsDTO serviceDto : serviceDtos) {
                ControllerServiceEntity serviceEntity = serviceDto.getControllerService();
                ControllerServiceEntity targetEntity = (ControllerServiceEntity)map.get(serviceEntity.getId());
                if (targetEntity == null) continue;
                PermissionsDtoMerger.mergePermissions(targetEntity.getPermissions(), serviceEntity.getPermissions());
            }
        }
    }

    private void mergeConnectionDiagnostics(ProcessorDiagnosticsEntity clientEntity, Map<NodeIdentifier, ProcessorDiagnosticsEntity> entityMap, Function<ProcessorDiagnosticsEntity, Set<ConnectionDiagnosticsDTO>> extractConnections) {
        HashMap<String, List> snapshotByConnectionId = new HashMap<String, List>();
        HashMap<String, ConnectionDiagnosticsDTO> connectionById = new HashMap<String, ConnectionDiagnosticsDTO>();
        for (Map.Entry<NodeIdentifier, ProcessorDiagnosticsEntity> entry : entityMap.entrySet()) {
            NodeIdentifier nodeId = entry.getKey();
            ProcessorDiagnosticsEntity entity = entry.getValue();
            Set<ConnectionDiagnosticsDTO> connections = extractConnections.apply(entity);
            for (ConnectionDiagnosticsDTO connectionDiagnostics : connections) {
                String connectionId = connectionDiagnostics.getConnection().getId();
                ConnectionDiagnosticsSnapshotDTO snapshot = connectionDiagnostics.getAggregateSnapshot();
                snapshot.setNodeIdentifier(nodeId.getApiAddress() + ":" + nodeId.getApiPort());
                List snapshots = snapshotByConnectionId.computeIfAbsent(connectionId, id -> new ArrayList());
                snapshots.add(snapshot);
                if (entity != clientEntity) continue;
                connectionById.put(connectionId, connectionDiagnostics);
            }
        }
        for (Map.Entry<Object, Object> entry : snapshotByConnectionId.entrySet()) {
            String connectionId = (String)entry.getKey();
            List snapshots = (List)entry.getValue();
            ConnectionDiagnosticsDTO dto = (ConnectionDiagnosticsDTO)connectionById.get(connectionId);
            dto.setNodeSnapshots(snapshots);
            dto.setAggregateSnapshot(this.mergeConnectionSnapshots(snapshots));
        }
    }

    private ConnectionDiagnosticsSnapshotDTO mergeConnectionSnapshots(List<ConnectionDiagnosticsSnapshotDTO> snapshots) {
        ConnectionDiagnosticsSnapshotDTO aggregate = new ConnectionDiagnosticsSnapshotDTO();
        HashMap<String, List> remotePartitionsByNodeId = new HashMap<String, List>();
        LocalQueuePartitionDTO localPartition = new LocalQueuePartitionDTO();
        localPartition.setActiveQueueByteCount(0L);
        localPartition.setActiveQueueFlowFileCount(0);
        localPartition.setAllActiveQueueFlowFilesPenalized(Boolean.valueOf(true));
        localPartition.setAnyActiveQueueFlowFilesPenalized(Boolean.valueOf(false));
        localPartition.setInFlightByteCount(0L);
        localPartition.setInFlightFlowFileCount(0);
        localPartition.setSwapByteCount(0L);
        localPartition.setSwapFiles(0);
        localPartition.setSwapFlowFileCount(0);
        localPartition.setTotalByteCount(0L);
        localPartition.setTotalFlowFileCount(0);
        aggregate.setTotalByteCount(0L);
        aggregate.setTotalFlowFileCount(0);
        aggregate.setLocalQueuePartition(localPartition);
        for (ConnectionDiagnosticsSnapshotDTO snapshot : snapshots) {
            aggregate.setTotalByteCount(aggregate.getTotalByteCount() + snapshot.getTotalByteCount());
            aggregate.setTotalFlowFileCount(aggregate.getTotalFlowFileCount() + snapshot.getTotalFlowFileCount());
            LocalQueuePartitionDTO snapshotLocalPartition = snapshot.getLocalQueuePartition();
            localPartition.setActiveQueueByteCount(localPartition.getActiveQueueByteCount() + snapshotLocalPartition.getActiveQueueByteCount());
            localPartition.setActiveQueueFlowFileCount(localPartition.getActiveQueueFlowFileCount() + snapshotLocalPartition.getActiveQueueFlowFileCount());
            localPartition.setAllActiveQueueFlowFilesPenalized(Boolean.valueOf(localPartition.getAllActiveQueueFlowFilesPenalized() != false && snapshotLocalPartition.getAllActiveQueueFlowFilesPenalized() != false));
            localPartition.setAnyActiveQueueFlowFilesPenalized(Boolean.valueOf(localPartition.getAnyActiveQueueFlowFilesPenalized() != false || snapshotLocalPartition.getAnyActiveQueueFlowFilesPenalized() != false));
            localPartition.setInFlightByteCount(localPartition.getInFlightByteCount() + snapshotLocalPartition.getInFlightByteCount());
            localPartition.setInFlightFlowFileCount(localPartition.getInFlightFlowFileCount() + snapshotLocalPartition.getInFlightFlowFileCount());
            localPartition.setSwapByteCount(localPartition.getSwapByteCount() + snapshotLocalPartition.getSwapByteCount());
            localPartition.setSwapFiles(localPartition.getSwapFiles() + snapshotLocalPartition.getSwapFiles());
            localPartition.setSwapFlowFileCount(localPartition.getSwapFlowFileCount() + snapshotLocalPartition.getSwapFlowFileCount());
            localPartition.setTotalByteCount(localPartition.getTotalByteCount() + snapshotLocalPartition.getTotalByteCount());
            localPartition.setTotalFlowFileCount(localPartition.getTotalFlowFileCount() + snapshotLocalPartition.getTotalFlowFileCount());
            for (RemoteQueuePartitionDTO remoteQueuePartition : snapshot.getRemoteQueuePartitions()) {
                String nodeId = remoteQueuePartition.getNodeIdentifier();
                List partitionsForNodeId = remotePartitionsByNodeId.computeIfAbsent(nodeId, key -> new ArrayList());
                partitionsForNodeId.add(remoteQueuePartition);
            }
        }
        ArrayList<RemoteQueuePartitionDTO> mergedRemoteQueuePartitions = new ArrayList<RemoteQueuePartitionDTO>();
        for (List partitions : remotePartitionsByNodeId.values()) {
            RemoteQueuePartitionDTO merged = this.mergeRemoteQueuePartitions(partitions);
            mergedRemoteQueuePartitions.add(merged);
        }
        aggregate.setRemoteQueuePartitions(mergedRemoteQueuePartitions);
        return aggregate;
    }

    private RemoteQueuePartitionDTO mergeRemoteQueuePartitions(List<RemoteQueuePartitionDTO> partitions) {
        RemoteQueuePartitionDTO merged = new RemoteQueuePartitionDTO();
        merged.setActiveQueueByteCount(0L);
        merged.setActiveQueueFlowFileCount(0);
        merged.setInFlightByteCount(0L);
        merged.setInFlightFlowFileCount(0);
        merged.setSwapByteCount(0L);
        merged.setSwapFiles(0);
        merged.setSwapFlowFileCount(0);
        merged.setTotalByteCount(0L);
        merged.setTotalFlowFileCount(0);
        for (RemoteQueuePartitionDTO partition : partitions) {
            merged.setActiveQueueByteCount(merged.getActiveQueueByteCount() + partition.getActiveQueueByteCount());
            merged.setActiveQueueFlowFileCount(merged.getActiveQueueFlowFileCount() + partition.getActiveQueueFlowFileCount());
            merged.setInFlightByteCount(merged.getInFlightByteCount() + partition.getInFlightByteCount());
            merged.setInFlightFlowFileCount(merged.getInFlightFlowFileCount() + partition.getInFlightFlowFileCount());
            merged.setSwapByteCount(merged.getSwapByteCount() + partition.getSwapByteCount());
            merged.setSwapFiles(merged.getSwapFiles() + partition.getSwapFiles());
            merged.setSwapFlowFileCount(merged.getSwapFlowFileCount() + partition.getSwapFlowFileCount());
            merged.setTotalByteCount(merged.getTotalByteCount() + partition.getTotalByteCount());
            merged.setTotalFlowFileCount(merged.getTotalFlowFileCount() + partition.getTotalFlowFileCount());
            merged.setNodeIdentifier(partition.getNodeIdentifier());
        }
        return merged;
    }
}

