/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.Map;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.registry.flow.VersionedFlowState;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.entity.VersionControlInformationEntity;

public class VersionControlInformationEntityMerger {
    public void merge(VersionControlInformationEntity clientEntity, Map<NodeIdentifier, VersionControlInformationEntity> entityMap) {
        VersionControlInformationDTO clientDto = clientEntity.getVersionControlInformation();
        entityMap.values().stream().filter(entity -> entity != clientEntity).forEach(entity -> {
            VersionControlInformationDTO dto = entity.getVersionControlInformation();
            VersionControlInformationEntityMerger.updateFlowState(clientDto, dto);
        });
    }

    private static boolean isCurrent(VersionedFlowState state) {
        return state == VersionedFlowState.UP_TO_DATE || state == VersionedFlowState.LOCALLY_MODIFIED;
    }

    private static boolean isModified(VersionedFlowState state) {
        return state == VersionedFlowState.LOCALLY_MODIFIED || state == VersionedFlowState.LOCALLY_MODIFIED_AND_STALE;
    }

    public static void updateFlowState(VersionControlInformationDTO clientDto, VersionControlInformationDTO dto) {
        boolean modified;
        VersionedFlowState clientState = VersionedFlowState.valueOf((String)clientDto.getState());
        if (clientState == VersionedFlowState.SYNC_FAILURE) {
            return;
        }
        VersionedFlowState dtoState = VersionedFlowState.valueOf((String)dto.getState());
        if (dtoState == VersionedFlowState.SYNC_FAILURE) {
            clientDto.setState(dto.getState());
            clientDto.setStateExplanation(dto.getStateExplanation());
            return;
        }
        boolean clientCurrent = VersionControlInformationEntityMerger.isCurrent(clientState);
        boolean clientModified = VersionControlInformationEntityMerger.isModified(clientState);
        boolean dtoCurrent = VersionControlInformationEntityMerger.isCurrent(dtoState);
        boolean dtoModified = VersionControlInformationEntityMerger.isModified(dtoState);
        boolean current = clientCurrent && dtoCurrent;
        boolean stale = !current;
        boolean bl = modified = clientModified && dtoModified;
        VersionedFlowState flowState = modified && stale ? VersionedFlowState.LOCALLY_MODIFIED_AND_STALE : (modified ? VersionedFlowState.LOCALLY_MODIFIED : (stale ? VersionedFlowState.STALE : VersionedFlowState.UP_TO_DATE));
        clientDto.setState(flowState.name());
        clientDto.setStateExplanation(flowState.getDescription());
    }
}

