/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.nifi.cluster.manager.ComponentEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.UserDTO;
import org.apache.nifi.web.api.entity.UserEntity;

public class UserEntityMerger
implements ComponentEntityMerger<UserEntity> {
    @Override
    public void merge(UserEntity clientEntity, Map<NodeIdentifier, UserEntity> entityMap) {
        ComponentEntityMerger.super.merge(clientEntity, entityMap);
    }

    @Override
    public void mergeComponents(UserEntity clientEntity, Map<NodeIdentifier, UserEntity> entityMap) {
        UserDTO clientDto = clientEntity.getComponent();
        HashMap<NodeIdentifier, UserDTO> dtoMap = new HashMap<NodeIdentifier, UserDTO>();
        for (Map.Entry<NodeIdentifier, UserEntity> entry : entityMap.entrySet()) {
            UserEntity nodeUserEntity = entry.getValue();
            UserDTO nodeUserDto = nodeUserEntity.getComponent();
            dtoMap.put(entry.getKey(), nodeUserDto);
        }
        UserEntityMerger.mergeDtos(clientDto, dtoMap);
    }

    private static void mergeDtos(UserDTO clientDto, Map<NodeIdentifier, UserDTO> dtoMap) {
        if (clientDto == null) {
            return;
        }
        HashSet accessPolicyEntities = new HashSet(clientDto.getAccessPolicies());
        HashSet tenantEntities = new HashSet(clientDto.getUserGroups());
        for (Map.Entry<NodeIdentifier, UserDTO> nodeEntry : dtoMap.entrySet()) {
            UserDTO nodeUser = nodeEntry.getValue();
            if (nodeUser == null) continue;
            accessPolicyEntities.retainAll(nodeUser.getAccessPolicies());
            tenantEntities.retainAll(nodeUser.getUserGroups());
        }
        clientDto.setAccessPolicies(accessPolicyEntities);
        clientDto.setUserGroups(tenantEntities);
    }
}

