/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleEntityEndpoint;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.NodeReplayLastEventSnapshotDTO;
import org.apache.nifi.web.api.entity.ReplayLastEventResponseEntity;
import org.apache.nifi.web.api.entity.ReplayLastEventSnapshotDTO;

public class ReplayLastEventEndpointMerger
extends AbstractSingleEntityEndpoint<ReplayLastEventResponseEntity>
implements EndpointResponseMerger {
    public static final String REPLAY_URI = "/nifi-api/provenance-events/latest/replays";

    @Override
    public boolean canHandle(URI uri, String method) {
        return "POST".equals(method) && REPLAY_URI.equals(uri.getPath());
    }

    @Override
    protected Class<ReplayLastEventResponseEntity> getEntityClass() {
        return ReplayLastEventResponseEntity.class;
    }

    @Override
    protected void mergeResponses(ReplayLastEventResponseEntity clientEntity, Map<NodeIdentifier, ReplayLastEventResponseEntity> entityMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        HashSet replayedEventIds = new HashSet();
        HashSet<String> failureExplanations = new HashSet<String>();
        boolean eventAvailable = false;
        for (Map.Entry<NodeIdentifier, ReplayLastEventResponseEntity> entry : entityMap.entrySet()) {
            String failureExplanation;
            NodeIdentifier nodeId = entry.getKey();
            ReplayLastEventResponseEntity nodeEntity = entry.getValue();
            ReplayLastEventSnapshotDTO nodeSnapshot = nodeEntity.getAggregateSnapshot();
            NodeReplayLastEventSnapshotDTO nodeResponseDto = new NodeReplayLastEventSnapshotDTO();
            nodeResponseDto.setAddress(nodeId.getApiAddress());
            nodeResponseDto.setApiPort(Integer.valueOf(nodeId.getApiPort()));
            nodeResponseDto.setNodeId(nodeId.getId());
            nodeResponseDto.setSnapshot(nodeSnapshot);
            if (clientEntity.getNodeSnapshots() == null) {
                clientEntity.setNodeSnapshots(new ArrayList());
            }
            clientEntity.getNodeSnapshots().add(nodeResponseDto);
            Collection eventsReplayed = nodeSnapshot.getEventsReplayed();
            if (eventsReplayed != null) {
                replayedEventIds.addAll(eventsReplayed);
            }
            if ((failureExplanation = nodeSnapshot.getFailureExplanation()) != null) {
                failureExplanations.add(nodeId.getApiAddress() + ":" + nodeId.getApiPort() + " - " + failureExplanation);
            }
            eventAvailable = eventAvailable || nodeSnapshot.getEventAvailable() == Boolean.TRUE;
        }
        clientEntity.getAggregateSnapshot().setEventsReplayed(replayedEventIds);
        clientEntity.getAggregateSnapshot().setEventAvailable(Boolean.valueOf(eventAvailable));
        if (failureExplanations.isEmpty()) {
            return;
        }
        if (failureExplanations.size() == 1) {
            clientEntity.getAggregateSnapshot().setFailureExplanation("One node failed to replay the latest event: " + (String)failureExplanations.iterator().next());
        } else {
            clientEntity.getAggregateSnapshot().setFailureExplanation(failureExplanations.size() + " nodes failed to replay the latest events. See logs for more details.");
        }
    }
}

