/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.replication.okhttp;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;

public class JacksonResponse
extends Response {
    private final ObjectMapper codec;
    private final byte[] responseBody;
    private final MultivaluedMap<String, String> responseHeaders;
    private final URI location;
    private final int statusCode;
    private final Runnable closeCallback;
    private final JsonFactory jsonFactory = new JsonFactory();

    public JacksonResponse(ObjectMapper codec, byte[] responseBody, MultivaluedMap<String, String> responseHeaders, URI location, int statusCode, Runnable closeCallback) {
        this.codec = codec;
        this.responseBody = responseBody;
        this.responseHeaders = responseHeaders;
        this.location = location;
        this.statusCode = statusCode;
        this.closeCallback = closeCallback;
    }

    public int getStatus() {
        return this.statusCode;
    }

    public Response.StatusType getStatusInfo() {
        return Response.Status.fromStatusCode((int)this.getStatus());
    }

    public Object getEntity() {
        try {
            JsonParser parser = this.jsonFactory.createParser(this.responseBody);
            parser.setCodec((ObjectCodec)this.codec);
            return parser.readValueAs(Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse response", e);
        }
    }

    public <T> T readEntity(Class<T> entityType) {
        if (InputStream.class.equals(entityType)) {
            return (T)new ByteArrayInputStream(this.responseBody);
        }
        if (String.class.equals(entityType)) {
            return (T)new String(this.responseBody, StandardCharsets.UTF_8);
        }
        try {
            JsonParser parser = this.jsonFactory.createParser(this.responseBody);
            parser.setCodec((ObjectCodec)this.codec);
            return (T)parser.readValueAs(entityType);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse response as entity of type " + entityType, e);
        }
    }

    public <T> T readEntity(GenericType<T> entityType) {
        throw new UnsupportedOperationException();
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) {
        throw new UnsupportedOperationException();
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        throw new UnsupportedOperationException();
    }

    public boolean hasEntity() {
        return this.responseBody != null && this.responseBody.length > 0;
    }

    public boolean bufferEntity() {
        return true;
    }

    public void close() {
        if (this.closeCallback != null) {
            this.closeCallback.run();
        }
    }

    public MediaType getMediaType() {
        return MediaType.APPLICATION_JSON_TYPE;
    }

    public Locale getLanguage() {
        return null;
    }

    public int getLength() {
        return this.responseBody == null ? 0 : this.responseBody.length;
    }

    public Set<String> getAllowedMethods() {
        String allowHeader = this.getHeaderString("Allow");
        if (allowHeader == null || allowHeader.trim().isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> allowed = new HashSet<String>();
        for (String allow : allowHeader.split(",")) {
            String trimmed = allow.trim().toUpperCase();
            if (trimmed.isEmpty()) continue;
            allowed.add(trimmed);
        }
        return allowed;
    }

    public Map<String, NewCookie> getCookies() {
        return Collections.emptyMap();
    }

    public EntityTag getEntityTag() {
        return null;
    }

    public Date getDate() {
        return null;
    }

    public Date getLastModified() {
        return null;
    }

    public URI getLocation() {
        return this.location;
    }

    public Set<Link> getLinks() {
        return Collections.emptySet();
    }

    public boolean hasLink(String relation) {
        return false;
    }

    public Link getLink(String relation) {
        return null;
    }

    public Link.Builder getLinkBuilder(String relation) {
        return null;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return new MultivaluedHashMap();
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.responseHeaders;
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return this.responseHeaders;
    }

    public String getHeaderString(String name) {
        String headerValue = (String)this.responseHeaders.getFirst((Object)name);
        if (headerValue != null) {
            return headerValue;
        }
        return (String)this.responseHeaders.getFirst((Object)name.toLowerCase());
    }
}

